/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.csvinput;

import com.univocity.parsers.common.TextParsingException;
import java.io.IOException;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.processing.loading.csvinput.StringArrayWritable;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class CSVRecordReaderIterator
extends CarbonIterator<Object[]> {
    private RecordReader<NullWritable, StringArrayWritable> recordReader;
    private boolean isConsumed;
    private InputSplit split;
    private TaskAttemptContext context;

    public CSVRecordReaderIterator(RecordReader<NullWritable, StringArrayWritable> recordReader, InputSplit split, TaskAttemptContext context) {
        this.recordReader = recordReader;
        this.split = split;
        this.context = context;
    }

    public boolean hasNext() {
        try {
            if (!this.isConsumed) {
                this.isConsumed = this.recordReader.nextKeyValue();
                return this.isConsumed;
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof TextParsingException) {
                throw new CarbonDataLoadingException(CarbonDataProcessorUtil.trimErrorMessage(e.getMessage()));
            }
            throw new CarbonDataLoadingException(e);
        }
    }

    public Object[] next() {
        try {
            Object[] data = ((StringArrayWritable)this.recordReader.getCurrentValue()).get();
            this.isConsumed = false;
            return data;
        }
        catch (Exception e) {
            throw new CarbonDataLoadingException(e);
        }
    }

    public void initialize() {
        try {
            this.recordReader.initialize(this.split, this.context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.recordReader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

