/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.dictionary;

import java.util.Map;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.devapi.BiDictionary;
import org.apache.carbondata.core.devapi.DictionaryGenerationException;
import org.apache.carbondata.core.dictionary.client.DictionaryClient;
import org.apache.carbondata.core.dictionary.generator.key.DictionaryMessage;
import org.apache.carbondata.core.dictionary.generator.key.DictionaryMessageType;

public class DictionaryServerClientDictionary
implements BiDictionary<Integer, Object> {
    private Dictionary dictionary;
    private DictionaryClient client;
    private Map<Object, Integer> localCache;
    private DictionaryMessage dictionaryMessage;
    private int base;

    public DictionaryServerClientDictionary(Dictionary dictionary, DictionaryClient client, DictionaryMessage key, Map<Object, Integer> localCache) {
        this.dictionary = dictionary;
        this.client = client;
        this.dictionaryMessage = key;
        this.localCache = localCache;
        this.base = dictionary == null ? 0 : dictionary.getDictionaryChunks().getSize() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getOrGenerateKey(Object value) throws DictionaryGenerationException {
        Integer key = this.getKey(value);
        if (key == null) {
            this.dictionaryMessage.setData(value.toString());
            DictionaryMessage dictionaryValue = this.client.getDictionary(this.dictionaryMessage);
            key = dictionaryValue.getDictionaryValue();
            Map<Object, Integer> map = this.localCache;
            synchronized (map) {
                this.localCache.put(value, key);
            }
            return key + this.base;
        }
        return key;
    }

    public Integer getKey(Object value) {
        Integer key = -1;
        if (this.dictionary != null) {
            key = this.dictionary.getSurrogateKey(value.toString());
        }
        if (key == -1 && (key = this.localCache.get(value)) != null) {
            return key + this.base;
        }
        return key;
    }

    public Object getValue(Integer key) {
        throw new UnsupportedOperationException("Not supported here");
    }

    public int size() {
        this.dictionaryMessage.setType(DictionaryMessageType.SIZE);
        return this.client.getDictionary(this.dictionaryMessage).getDictionaryValue() + this.base;
    }
}

