/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.parser.impl;

import java.util.regex.Pattern;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.processing.loading.complexobjects.ArrayObject;
import org.apache.carbondata.processing.loading.parser.ComplexParser;
import org.apache.carbondata.processing.loading.parser.GenericParser;
import org.apache.commons.lang.ArrayUtils;

public class ArrayParserImpl
implements ComplexParser<ArrayObject> {
    private Pattern pattern;
    private GenericParser child;
    private String nullFormat;

    public ArrayParserImpl(String delimiter, String nullFormat) {
        this.pattern = Pattern.compile(CarbonUtil.delimiterConverter((String)delimiter));
        this.nullFormat = nullFormat;
    }

    @Override
    public ArrayObject parse(Object data) {
        Object[] split;
        String value;
        if (data != null && !(value = data.toString()).isEmpty() && !value.equals(this.nullFormat) && ArrayUtils.isNotEmpty((Object[])(split = this.pattern.split(value, -1)))) {
            Object[] array = new Object[split.length];
            for (int i = 0; i < split.length; ++i) {
                array[i] = this.child.parse(split[i]);
            }
            return new ArrayObject(array);
        }
        return null;
    }

    @Override
    public void addChildren(GenericParser parser) {
        this.child = parser;
    }
}

