/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.sort;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.metadata.schema.ColumnRangeInfo;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.sort.AbstractMergeSorter;
import org.apache.carbondata.processing.loading.sort.SortScopeOptions;
import org.apache.carbondata.processing.loading.sort.Sorter;
import org.apache.carbondata.processing.loading.sort.impl.ParallelReadMergeSorterImpl;
import org.apache.carbondata.processing.loading.sort.impl.ParallelReadMergeSorterWithColumnRangeImpl;
import org.apache.carbondata.processing.loading.sort.impl.UnsafeBatchParallelReadMergeSorterImpl;
import org.apache.carbondata.processing.loading.sort.impl.UnsafeParallelReadMergeSorterImpl;
import org.apache.carbondata.processing.loading.sort.impl.UnsafeParallelReadMergeSorterWithColumnRangeImpl;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;

public class SorterFactory {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)SorterFactory.class.getName());

    public static Sorter createSorter(CarbonDataLoadConfiguration configuration, AtomicLong counter) {
        boolean offheapsort = Boolean.parseBoolean(CarbonProperties.getInstance().getProperty("enable.unsafe.sort", "true"));
        SortScopeOptions.SortScope sortScope = CarbonDataProcessorUtil.getSortScope(configuration);
        AbstractMergeSorter sorter = offheapsort ? (configuration.getBucketingInfo() != null ? new UnsafeParallelReadMergeSorterWithColumnRangeImpl(counter, (ColumnRangeInfo)configuration.getBucketingInfo()) : (configuration.getSortColumnRangeInfo() != null ? new UnsafeParallelReadMergeSorterWithColumnRangeImpl(counter, (ColumnRangeInfo)configuration.getSortColumnRangeInfo()) : new UnsafeParallelReadMergeSorterImpl(counter))) : (configuration.getBucketingInfo() != null ? new ParallelReadMergeSorterWithColumnRangeImpl(counter, (ColumnRangeInfo)configuration.getBucketingInfo()) : (configuration.getSortColumnRangeInfo() != null ? new ParallelReadMergeSorterWithColumnRangeImpl(counter, (ColumnRangeInfo)configuration.getSortColumnRangeInfo()) : new ParallelReadMergeSorterImpl(counter)));
        if (sortScope.equals((Object)SortScopeOptions.SortScope.BATCH_SORT)) {
            if (configuration.getBucketingInfo() == null) {
                sorter = new UnsafeBatchParallelReadMergeSorterImpl(counter);
            } else {
                LOGGER.warn("Batch sort is not enabled in case of bucketing. Falling back to " + sorter.getClass().getName());
            }
        }
        return sorter;
    }
}

