/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.sort.unsafe.comparator;

import org.apache.carbondata.core.memory.CarbonUnsafe;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonUnsafeUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.core.util.comparator.Comparator;
import org.apache.carbondata.core.util.comparator.SerializableComparator;
import org.apache.carbondata.processing.loading.sort.unsafe.UnsafeCarbonRowPage;
import org.apache.carbondata.processing.loading.sort.unsafe.holder.UnsafeCarbonRow;
import org.apache.carbondata.processing.sort.sortdata.TableFieldStat;

public class UnsafeRowComparator
implements java.util.Comparator<UnsafeCarbonRow> {
    private Object baseObject;
    private TableFieldStat tableFieldStat;
    private int dictSizeInMemory;

    public UnsafeRowComparator(UnsafeCarbonRowPage rowPage) {
        this.baseObject = rowPage.getDataBlock().getBaseObject();
        this.tableFieldStat = rowPage.getTableFieldStat();
        this.dictSizeInMemory = this.tableFieldStat.getDictSortDimCnt() * 4;
    }

    @Override
    public int compare(UnsafeCarbonRow rowL, UnsafeCarbonRow rowR) {
        return this.compare(rowL, this.baseObject, rowR, this.baseObject);
    }

    public int compare(UnsafeCarbonRow rowL, Object baseObjectL, UnsafeCarbonRow rowR, Object baseObjectR) {
        int diff = 0;
        long rowA = rowL.address;
        long rowB = rowR.address;
        int sizeInDictPartA = 0;
        int noDicSortIdx = 0;
        int sizeInNonDictPartA = 0;
        int sizeInDictPartB = 0;
        int sizeInNonDictPartB = 0;
        for (boolean isNoDictionary : this.tableFieldStat.getIsSortColNoDictFlags()) {
            if (isNoDictionary) {
                short lengthA = CarbonUnsafe.getUnsafe().getShort(baseObjectL, rowA + (long)this.dictSizeInMemory + (long)sizeInNonDictPartA);
                sizeInNonDictPartA += 2;
                short lengthB = CarbonUnsafe.getUnsafe().getShort(baseObjectR, rowB + (long)this.dictSizeInMemory + (long)sizeInNonDictPartB);
                sizeInNonDictPartB += 2;
                DataType dataType = this.tableFieldStat.getNoDictDataType()[noDicSortIdx++];
                if (DataTypeUtil.isPrimitiveColumn((DataType)dataType)) {
                    SerializableComparator comparator;
                    int difference;
                    Object data1 = null;
                    if (0 != lengthA) {
                        data1 = CarbonUnsafeUtil.getDataFromUnsafe((DataType)dataType, (Object)baseObjectL, (long)(rowA + (long)this.dictSizeInMemory), (int)sizeInNonDictPartA, (int)lengthA);
                        sizeInNonDictPartA += lengthA;
                    }
                    Object data2 = null;
                    if (0 != lengthB) {
                        data2 = CarbonUnsafeUtil.getDataFromUnsafe((DataType)dataType, (Object)baseObjectR, (long)(rowB + (long)this.dictSizeInMemory), (int)sizeInNonDictPartB, (int)lengthB);
                        sizeInNonDictPartB += lengthB;
                    }
                    if ((difference = (comparator = Comparator.getComparator((DataType)dataType)).compare(data1, data2)) == 0) continue;
                    return difference;
                }
                byte[] byteArr1 = new byte[lengthA];
                CarbonUnsafe.getUnsafe().copyMemory(baseObjectL, rowA + (long)this.dictSizeInMemory + (long)sizeInNonDictPartA, byteArr1, CarbonUnsafe.BYTE_ARRAY_OFFSET, lengthA);
                sizeInNonDictPartA += lengthA;
                byte[] byteArr2 = new byte[lengthB];
                CarbonUnsafe.getUnsafe().copyMemory(baseObjectR, rowB + (long)this.dictSizeInMemory + (long)sizeInNonDictPartB, byteArr2, CarbonUnsafe.BYTE_ARRAY_OFFSET, lengthB);
                sizeInNonDictPartB += lengthB;
                int difference = ByteUtil.UnsafeComparer.INSTANCE.compareTo(byteArr1, byteArr2);
                if (difference == 0) continue;
                return difference;
            }
            int dimFieldA = CarbonUnsafe.getUnsafe().getInt(baseObjectL, rowA + (long)sizeInDictPartA);
            sizeInDictPartA += 4;
            int dimFieldB = CarbonUnsafe.getUnsafe().getInt(baseObjectR, rowB + (long)sizeInDictPartB);
            sizeInDictPartB += 4;
            diff = dimFieldA - dimFieldB;
            if (diff == 0) continue;
            return diff;
        }
        return diff;
    }
}

