/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.sort.unsafe.merger;

import java.io.File;
import java.io.FileFilter;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.exception.CarbonDataWriterException;
import org.apache.carbondata.processing.loading.row.IntermediateSortTempRow;
import org.apache.carbondata.processing.loading.sort.SortStepRowHandler;
import org.apache.carbondata.processing.loading.sort.unsafe.UnsafeCarbonRowPage;
import org.apache.carbondata.processing.loading.sort.unsafe.holder.SortTempChunkHolder;
import org.apache.carbondata.processing.loading.sort.unsafe.holder.UnsafeFinalMergePageHolder;
import org.apache.carbondata.processing.loading.sort.unsafe.holder.UnsafeInmemoryHolder;
import org.apache.carbondata.processing.loading.sort.unsafe.holder.UnsafeSortTempFileChunkHolder;
import org.apache.carbondata.processing.loading.sort.unsafe.merger.UnsafeInMemoryIntermediateDataMerger;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;

public class UnsafeSingleThreadFinalSortFilesMerger
extends CarbonIterator<Object[]> {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)UnsafeSingleThreadFinalSortFilesMerger.class.getName());
    private int fileCounter;
    private AbstractQueue<SortTempChunkHolder> recordHolderHeapLocal;
    private SortParameters parameters;
    private SortStepRowHandler sortStepRowHandler;
    private String[] tempFileLocation;
    private String tableName;
    private boolean isStopProcess;

    public UnsafeSingleThreadFinalSortFilesMerger(SortParameters parameters, String[] tempFileLocation) {
        this.parameters = parameters;
        this.sortStepRowHandler = new SortStepRowHandler(parameters);
        this.tempFileLocation = tempFileLocation;
        this.tableName = parameters.getTableName();
    }

    public void startFinalMerge(UnsafeCarbonRowPage[] rowPages, List<UnsafeInMemoryIntermediateDataMerger> merges) throws CarbonDataWriterException {
        Iterator<UnsafeInMemoryIntermediateDataMerger> iter = merges.iterator();
        while (iter.hasNext()) {
            UnsafeInMemoryIntermediateDataMerger merger = iter.next();
            if (!merger.isSpillDisk()) continue;
            iter.remove();
        }
        this.startSorting(rowPages, merges);
    }

    private void startSorting(UnsafeCarbonRowPage[] rowPages, List<UnsafeInMemoryIntermediateDataMerger> merges) throws CarbonDataWriterException {
        try {
            List<File> filesToMergeSort = this.getFilesToMergeSort();
            this.fileCounter = rowPages.length + filesToMergeSort.size() + merges.size();
            if (this.fileCounter == 0) {
                LOGGER.info("No files to merge sort");
                return;
            }
            LOGGER.info(String.format("Starting final merge of %d pages, including row pages: %d, sort temp files: %d, intermediate merges: %d", this.fileCounter, rowPages.length, filesToMergeSort.size(), merges.size()));
            this.createRecordHolderQueue();
            LOGGER.info("Started adding first record from each page");
            for (UnsafeCarbonRowPage rowPage : rowPages) {
                UnsafeInmemoryHolder sortTempFileChunkHolder = new UnsafeInmemoryHolder(rowPage);
                sortTempFileChunkHolder.readRow();
                this.recordHolderHeapLocal.add(sortTempFileChunkHolder);
            }
            for (UnsafeInMemoryIntermediateDataMerger merger : merges) {
                UnsafeFinalMergePageHolder sortTempFileChunkHolder = new UnsafeFinalMergePageHolder(merger, this.parameters.getNoDictionarySortColumn());
                sortTempFileChunkHolder.readRow();
                this.recordHolderHeapLocal.add(sortTempFileChunkHolder);
            }
            for (File file : filesToMergeSort) {
                UnsafeSortTempFileChunkHolder sortTempFileChunkHolder = new UnsafeSortTempFileChunkHolder(file, this.parameters, true);
                sortTempFileChunkHolder.readRow();
                this.recordHolderHeapLocal.add(sortTempFileChunkHolder);
            }
            LOGGER.info("Heap Size: " + this.recordHolderHeapLocal.size());
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            throw new CarbonDataWriterException((Throwable)e);
        }
    }

    private List<File> getFilesToMergeSort() {
        final int rangeId = this.parameters.getRangeId();
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith(UnsafeSingleThreadFinalSortFilesMerger.this.tableName + '_' + rangeId);
            }
        };
        ArrayList<File> files = new ArrayList<File>(this.tempFileLocation.length);
        for (String tempLoc : this.tempFileLocation) {
            File[] subFiles = new File(tempLoc).listFiles(fileFilter);
            if (null == subFiles || subFiles.length <= 0) continue;
            files.addAll(Arrays.asList(subFiles));
        }
        return files;
    }

    private void createRecordHolderQueue() {
        this.recordHolderHeapLocal = new PriorityQueue<SortTempChunkHolder>(this.fileCounter);
    }

    public Object[] next() {
        if (this.hasNext()) {
            return this.sortStepRowHandler.convertIntermediateSortTempRowTo3Parted(this.getSortedRecordFromFile());
        }
        throw new NoSuchElementException("No more elements to return");
    }

    private IntermediateSortTempRow getSortedRecordFromFile() throws CarbonDataWriterException {
        IntermediateSortTempRow row = null;
        SortTempChunkHolder poll = (SortTempChunkHolder)this.recordHolderHeapLocal.poll();
        row = poll.getRow();
        if (!poll.hasNext()) {
            poll.close();
            --this.fileCounter;
            return row;
        }
        try {
            poll.readRow();
        }
        catch (Exception e) {
            throw new CarbonDataWriterException(e.getMessage(), (Throwable)e);
        }
        this.recordHolderHeapLocal.add(poll);
        return row;
    }

    public boolean hasNext() {
        return this.fileCounter > 0;
    }

    public void clear() {
        if (null != this.recordHolderHeapLocal) {
            for (SortTempChunkHolder pageHolder : this.recordHolderHeapLocal) {
                pageHolder.close();
            }
            this.recordHolderHeapLocal = null;
        }
    }

    public boolean isStopProcess() {
        return this.isStopProcess;
    }

    public void setStopProcess(boolean stopProcess) {
        this.isStopProcess = stopProcess;
    }
}

