/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.merger;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.datastore.block.TaskBlockInfo;
import org.apache.carbondata.core.metadata.blocklet.DataFileFooter;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.scan.executor.QueryExecutor;
import org.apache.carbondata.core.scan.executor.QueryExecutorFactory;
import org.apache.carbondata.core.scan.executor.exception.QueryExecutionException;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.scan.model.QueryModelBuilder;
import org.apache.carbondata.core.scan.result.RowBatch;
import org.apache.carbondata.core.scan.result.iterator.RawResultIterator;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.stats.QueryStatisticsRecorder;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonTimeStatisticsFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeConverter;
import org.apache.carbondata.processing.merger.CarbonCompactionUtil;
import org.apache.hadoop.conf.Configuration;

public class CarbonCompactionExecutor {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)CarbonCompactionExecutor.class.getName());
    private final Map<String, List<DataFileFooter>> dataFileMetadataSegMapping;
    private final SegmentProperties destinationSegProperties;
    private final Map<String, TaskBlockInfo> segmentMapping;
    private List<QueryExecutor> queryExecutorList;
    private List<QueryStatisticsRecorder> queryStatisticsRecorders = new ArrayList<QueryStatisticsRecorder>(16);
    private CarbonTable carbonTable;
    private QueryModel queryModel;
    private boolean restructuredBlockExists;
    private DataTypeConverter dataTypeConverter;

    public CarbonCompactionExecutor(Map<String, TaskBlockInfo> segmentMapping, SegmentProperties segmentProperties, CarbonTable carbonTable, Map<String, List<DataFileFooter>> dataFileMetadataSegMapping, boolean restructuredBlockExists, DataTypeConverter dataTypeConverter) {
        this.segmentMapping = segmentMapping;
        this.destinationSegProperties = segmentProperties;
        this.carbonTable = carbonTable;
        this.dataFileMetadataSegMapping = dataFileMetadataSegMapping;
        this.restructuredBlockExists = restructuredBlockExists;
        this.queryExecutorList = new ArrayList<QueryExecutor>(16);
        this.dataTypeConverter = dataTypeConverter;
    }

    public List<RawResultIterator> processTableBlocks(Configuration configuration) throws QueryExecutionException, IOException {
        ArrayList<RawResultIterator> resultList = new ArrayList<RawResultIterator>(16);
        List list = null;
        QueryModelBuilder builder = new QueryModelBuilder(this.carbonTable).projectAllColumns().dataConverter(this.dataTypeConverter).enableForcedDetailRawQuery();
        if (this.enablePageLevelReaderForCompaction()) {
            builder.enableReadPageByPage();
        }
        this.queryModel = builder.build();
        for (Map.Entry<String, TaskBlockInfo> taskMap : this.segmentMapping.entrySet()) {
            String segmentId = taskMap.getKey();
            List<DataFileFooter> listMetadata = this.dataFileMetadataSegMapping.get(segmentId);
            SegmentProperties sourceSegProperties = this.getSourceSegmentProperties(listMetadata);
            TaskBlockInfo taskBlockInfo = taskMap.getValue();
            Set taskBlockListMapping = taskBlockInfo.getTaskSet();
            for (String task : taskBlockListMapping) {
                list = taskBlockInfo.getTableBlockInfoList(task);
                Collections.sort(list);
                LOGGER.info("for task -" + task + "- in segment id -" + segmentId + "- block size is -" + list.size());
                this.queryModel.setTableBlockInfos(list);
                resultList.add(new RawResultIterator(this.executeBlockList(list, segmentId, task, configuration), sourceSegProperties, this.destinationSegProperties));
            }
        }
        return resultList;
    }

    private SegmentProperties getSourceSegmentProperties(List<DataFileFooter> listMetadata) {
        SegmentProperties sourceSegProperties = null;
        if (this.restructuredBlockExists) {
            HashMap<String, Integer> columnToCardinalityMap = new HashMap<String, Integer>(16);
            CarbonCompactionUtil.addColumnCardinalityToMap(columnToCardinalityMap, listMetadata.get(0).getColumnInTable(), listMetadata.get(0).getSegmentInfo().getColumnCardinality());
            ArrayList<ColumnSchema> updatedColumnSchemaList = new ArrayList<ColumnSchema>(listMetadata.get(0).getColumnInTable().size());
            int[] updatedColumnCardinalities = CarbonCompactionUtil.updateColumnSchemaAndGetCardinality(columnToCardinalityMap, this.carbonTable, updatedColumnSchemaList);
            sourceSegProperties = new SegmentProperties(updatedColumnSchemaList, updatedColumnCardinalities);
        } else {
            sourceSegProperties = new SegmentProperties(listMetadata.get(0).getColumnInTable(), listMetadata.get(0).getSegmentInfo().getColumnCardinality());
        }
        return sourceSegProperties;
    }

    private CarbonIterator<RowBatch> executeBlockList(List<TableBlockInfo> blockList, String segmentId, String taskId, Configuration configuration) throws QueryExecutionException, IOException {
        this.queryModel.setTableBlockInfos(blockList);
        QueryStatisticsRecorder executorRecorder = CarbonTimeStatisticsFactory.createExecutorRecorder((String)(this.queryModel.getQueryId() + "_" + segmentId + "_" + taskId));
        this.queryStatisticsRecorders.add(executorRecorder);
        this.queryModel.setStatisticsRecorder(executorRecorder);
        QueryExecutor queryExecutor = QueryExecutorFactory.getQueryExecutor((QueryModel)this.queryModel, (Configuration)configuration);
        this.queryExecutorList.add(queryExecutor);
        return queryExecutor.execute(this.queryModel);
    }

    public void close(List<RawResultIterator> rawResultIteratorList, long queryStartTime) {
        try {
            if (null != rawResultIteratorList) {
                for (RawResultIterator rawResultIterator : rawResultIteratorList) {
                    rawResultIterator.close();
                }
            }
            for (QueryExecutor queryExecutor : this.queryExecutorList) {
                queryExecutor.finish();
            }
            this.logStatistics(queryStartTime);
        }
        catch (QueryExecutionException e) {
            LOGGER.error((Throwable)e, "Problem while close. Ignoring the exception");
        }
        this.clearDictionaryFromQueryModel();
    }

    private void logStatistics(long queryStartTime) {
        if (!this.queryStatisticsRecorders.isEmpty()) {
            QueryStatistic queryStatistic = new QueryStatistic();
            queryStatistic.addFixedTimeStatistic("Total Time taken to execute the query in executor Side", System.currentTimeMillis() - queryStartTime);
            for (QueryStatisticsRecorder recorder : this.queryStatisticsRecorders) {
                recorder.recordStatistics(queryStatistic);
                recorder.logStatistics();
            }
        }
    }

    private void clearDictionaryFromQueryModel() {
        Map columnToDictionaryMapping;
        if (null != this.queryModel && null != (columnToDictionaryMapping = this.queryModel.getColumnToDictionaryMapping())) {
            for (Map.Entry entry : columnToDictionaryMapping.entrySet()) {
                CarbonUtil.clearDictionaryCache((Dictionary)((Dictionary)entry.getValue()));
            }
        }
    }

    private boolean enablePageLevelReaderForCompaction() {
        boolean enablePageReader;
        String enablePageReaderProperty = CarbonProperties.getInstance().getProperty("carbon.enable.page.level.reader.in.compaction", "false");
        try {
            enablePageReader = Boolean.parseBoolean(enablePageReaderProperty);
        }
        catch (Exception e) {
            enablePageReader = Boolean.parseBoolean("false");
        }
        LOGGER.info("Page level reader is set to: " + enablePageReader);
        return enablePageReader;
    }
}

