/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.merger;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.datastore.block.TaskBlockInfo;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.blocklet.DataFileFooter;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.processing.merger.CompactionType;
import org.apache.commons.lang3.ArrayUtils;

public class CarbonCompactionUtil {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)CarbonCompactionUtil.class.getName());

    public static Map<String, TaskBlockInfo> createMappingForSegments(List<TableBlockInfo> tableBlockInfoList) {
        HashMap<String, TaskBlockInfo> segmentBlockInfoMapping = new HashMap<String, TaskBlockInfo>(16);
        for (TableBlockInfo info : tableBlockInfoList) {
            String segId = info.getSegmentId();
            TaskBlockInfo taskBlockInfoMapping = (TaskBlockInfo)segmentBlockInfoMapping.get(segId);
            String taskNo = CarbonTablePath.DataFileUtil.getTaskNo((String)info.getFilePath());
            if (null == taskBlockInfoMapping) {
                taskBlockInfoMapping = new TaskBlockInfo();
                CarbonCompactionUtil.groupCorrespodingInfoBasedOnTask(info, taskBlockInfoMapping, taskNo);
                segmentBlockInfoMapping.put(segId, taskBlockInfoMapping);
                continue;
            }
            CarbonCompactionUtil.groupCorrespodingInfoBasedOnTask(info, taskBlockInfoMapping, taskNo);
        }
        return segmentBlockInfoMapping;
    }

    private static void groupCorrespodingInfoBasedOnTask(TableBlockInfo info, TaskBlockInfo taskBlockMapping, String taskNo) {
        ArrayList<TableBlockInfo> blockLists = taskBlockMapping.getTableBlockInfoList(taskNo);
        if (null != blockLists) {
            blockLists.add(info);
        } else {
            blockLists = new ArrayList<TableBlockInfo>(16);
            blockLists.add(info);
            taskBlockMapping.addTableBlockInfoList(taskNo, blockLists);
        }
    }

    public static Map<String, List<DataFileFooter>> createDataFileFooterMappingForSegments(List<TableBlockInfo> tableBlockInfoList) throws IOException {
        HashMap<String, List<DataFileFooter>> segmentBlockInfoMapping = new HashMap<String, List<DataFileFooter>>();
        for (TableBlockInfo blockInfo : tableBlockInfoList) {
            ArrayList<DataFileFooter> eachSegmentBlocks = new ArrayList<DataFileFooter>();
            String segId = blockInfo.getSegmentId();
            DataFileFooter dataFileMatadata = null;
            List metadataList = (List)segmentBlockInfoMapping.get(segId);
            dataFileMatadata = null != blockInfo.getDetailInfo() && blockInfo.getDetailInfo().getSchemaUpdatedTimeStamp() == 0L ? CarbonUtil.readMetadatFile((TableBlockInfo)blockInfo, (boolean)true) : CarbonUtil.readMetadatFile((TableBlockInfo)blockInfo);
            if (null == metadataList) {
                eachSegmentBlocks.add(dataFileMatadata);
                segmentBlockInfoMapping.put(segId, eachSegmentBlocks);
                continue;
            }
            metadataList.add(dataFileMatadata);
        }
        return segmentBlockInfoMapping;
    }

    public static boolean isCompactionRequiredForTable(String metaFolderPath) {
        String minorCompactionStatusFile = metaFolderPath + "/" + "compactionRequired_minor";
        String majorCompactionStatusFile = metaFolderPath + "/" + "compactionRequired_major";
        try {
            if (FileFactory.isFileExist((String)minorCompactionStatusFile, (FileFactory.FileType)FileFactory.getFileType((String)minorCompactionStatusFile)) || FileFactory.isFileExist((String)majorCompactionStatusFile, (FileFactory.FileType)FileFactory.getFileType((String)majorCompactionStatusFile))) {
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.error("Exception in isFileExist compaction request file " + e.getMessage());
        }
        return false;
    }

    public static CompactionType determineCompactionType(String metaFolderPath) {
        String minorCompactionStatusFile = metaFolderPath + "/" + "compactionRequired_minor";
        String majorCompactionStatusFile = metaFolderPath + "/" + "compactionRequired_major";
        try {
            if (FileFactory.isFileExist((String)minorCompactionStatusFile, (FileFactory.FileType)FileFactory.getFileType((String)minorCompactionStatusFile))) {
                return CompactionType.MINOR;
            }
            if (FileFactory.isFileExist((String)majorCompactionStatusFile, (FileFactory.FileType)FileFactory.getFileType((String)majorCompactionStatusFile))) {
                return CompactionType.MAJOR;
            }
        }
        catch (IOException e) {
            LOGGER.error("Exception in determining the compaction request file " + e.getMessage());
        }
        return CompactionType.MINOR;
    }

    public static boolean deleteCompactionRequiredFile(String metaFolderPath, CompactionType compactionType) {
        String compactionRequiredFile = compactionType.equals((Object)CompactionType.MINOR) ? metaFolderPath + "/" + "compactionRequired_minor" : metaFolderPath + "/" + "compactionRequired_major";
        try {
            if (FileFactory.isFileExist((String)compactionRequiredFile, (FileFactory.FileType)FileFactory.getFileType((String)compactionRequiredFile))) {
                if (FileFactory.getCarbonFile((String)compactionRequiredFile, (FileFactory.FileType)FileFactory.getFileType((String)compactionRequiredFile)).delete()) {
                    LOGGER.info("Deleted the compaction request file " + compactionRequiredFile);
                    return true;
                }
                LOGGER.error("Unable to delete the compaction request file " + compactionRequiredFile);
            } else {
                LOGGER.info("Compaction request file is not present. file is : " + compactionRequiredFile);
            }
        }
        catch (IOException e) {
            LOGGER.error("Exception in deleting the compaction request file " + e.getMessage());
        }
        return false;
    }

    public static boolean createCompactionRequiredFile(String metaFolderPath, CompactionType compactionType) {
        String statusFile = CompactionType.MINOR == compactionType ? metaFolderPath + "/" + "compactionRequired_minor" : metaFolderPath + "/" + "compactionRequired_major";
        try {
            if (!FileFactory.isFileExist((String)statusFile, (FileFactory.FileType)FileFactory.getFileType((String)statusFile))) {
                if (FileFactory.createNewFile((String)statusFile, (FileFactory.FileType)FileFactory.getFileType((String)statusFile))) {
                    LOGGER.info("successfully created a compaction required file - " + statusFile);
                    return true;
                }
                LOGGER.error("Not able to create a compaction required file - " + statusFile);
                return false;
            }
            LOGGER.info("Compaction request file : " + statusFile + " already exist.");
        }
        catch (IOException e) {
            LOGGER.error("Exception in creating the compaction request file " + e.getMessage());
        }
        return false;
    }

    public static CarbonTable getNextTableToCompact(CarbonTable[] carbonTables, List<CarbonTableIdentifier> skipList) {
        for (CarbonTable ctable : carbonTables) {
            String metadataPath = ctable.getMetadataPath();
            if (!CarbonCompactionUtil.isCompactionRequiredForTable(metadataPath) || skipList.contains(ctable.getCarbonTableIdentifier())) continue;
            return ctable;
        }
        return null;
    }

    public static void addColumnCardinalityToMap(Map<String, Integer> columnCardinalityMap, List<ColumnSchema> currentBlockSchema, int[] currentBlockCardinality) {
        for (int i = 0; i < currentBlockCardinality.length; ++i) {
            String columnUniqueId = currentBlockSchema.get(i).getColumnUniqueId();
            Integer value = columnCardinalityMap.get(columnUniqueId);
            if (null == value) {
                columnCardinalityMap.put(columnUniqueId, currentBlockCardinality[i]);
                continue;
            }
            if (currentBlockCardinality[i] <= value) continue;
            columnCardinalityMap.put(columnUniqueId, currentBlockCardinality[i]);
        }
    }

    public static int[] updateColumnSchemaAndGetCardinality(Map<String, Integer> columnCardinalityMap, CarbonTable carbonTable, List<ColumnSchema> updatedColumnSchemaList) {
        List masterDimensions = carbonTable.getDimensionByTableName(carbonTable.getTableName());
        ArrayList<Integer> updatedCardinalityList = new ArrayList<Integer>(columnCardinalityMap.size());
        for (CarbonDimension dimension : masterDimensions) {
            Integer value = columnCardinalityMap.get(dimension.getColumnId());
            if (null == value) {
                updatedCardinalityList.add(CarbonCompactionUtil.getDimensionDefaultCardinality(dimension));
            } else {
                updatedCardinalityList.add(value);
            }
            updatedColumnSchemaList.add(dimension.getColumnSchema());
        }
        List masterSchemaMeasures = carbonTable.getMeasureByTableName(carbonTable.getTableName());
        for (CarbonMeasure measure : masterSchemaMeasures) {
            updatedColumnSchemaList.add(measure.getColumnSchema());
        }
        return ArrayUtils.toPrimitive((Integer[])updatedCardinalityList.toArray(new Integer[updatedCardinalityList.size()]));
    }

    private static int getDimensionDefaultCardinality(CarbonDimension dimension) {
        int cardinality = 0;
        cardinality = dimension.hasEncoding(Encoding.DIRECT_DICTIONARY) ? Integer.MAX_VALUE : (dimension.hasEncoding(Encoding.DICTIONARY) ? (null != dimension.getDefaultValue() ? 2 : 1) : -1);
        return cardinality;
    }

    public static boolean checkIfAnyRestructuredBlockExists(Map<String, TaskBlockInfo> segmentMapping, Map<String, List<DataFileFooter>> dataFileMetadataSegMapping, long tableLastUpdatedTime) {
        boolean restructuredBlockExists = false;
        for (Map.Entry<String, TaskBlockInfo> taskMap : segmentMapping.entrySet()) {
            String segmentId = taskMap.getKey();
            List<DataFileFooter> listMetadata = dataFileMetadataSegMapping.get(segmentId);
            for (DataFileFooter dataFileFooter : listMetadata) {
                if (tableLastUpdatedTime <= dataFileFooter.getSchemaUpdatedTimeStamp()) continue;
                restructuredBlockExists = true;
                break;
            }
            if (!restructuredBlockExists) continue;
            break;
        }
        return restructuredBlockExists;
    }
}

