/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.partition.spliter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.block.TaskBlockInfo;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.scan.executor.exception.QueryExecutionException;
import org.apache.carbondata.core.scan.model.QueryModelBuilder;
import org.apache.carbondata.core.scan.result.iterator.PartitionSpliterRawResultIterator;
import org.apache.carbondata.core.util.DataTypeConverter;
import org.apache.carbondata.processing.partition.spliter.AbstractCarbonQueryExecutor;
import org.apache.hadoop.conf.Configuration;

public class CarbonSplitExecutor
extends AbstractCarbonQueryExecutor {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)CarbonSplitExecutor.class.getName());

    public CarbonSplitExecutor(Map<String, TaskBlockInfo> segmentMapping, CarbonTable carbonTable) {
        this.segmentMapping = segmentMapping;
        this.carbonTable = carbonTable;
    }

    public List<PartitionSpliterRawResultIterator> processDataBlocks(String segmentId, DataTypeConverter converter, Configuration configuration) throws QueryExecutionException, IOException {
        List list = null;
        this.queryModel = new QueryModelBuilder(this.carbonTable).projectAllColumns().dataConverter(converter).enableForcedDetailRawQuery().build();
        ArrayList<PartitionSpliterRawResultIterator> resultList = new ArrayList<PartitionSpliterRawResultIterator>(16);
        TaskBlockInfo taskBlockInfo = (TaskBlockInfo)this.segmentMapping.get(segmentId);
        Set taskBlockListMapping = taskBlockInfo.getTaskSet();
        for (String task : taskBlockListMapping) {
            list = taskBlockInfo.getTableBlockInfoList(task);
            LOGGER.info("for task -" + task + "-block size is -" + list.size());
            this.queryModel.setTableBlockInfos(list);
            resultList.add(new PartitionSpliterRawResultIterator(this.executeBlockList(list, configuration)));
        }
        return resultList;
    }
}

