/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.partition.spliter;

import java.util.List;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.exception.CarbonDataWriterException;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.datastore.row.WriteStepRowUtil;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.store.CarbonDataFileAttributes;
import org.apache.carbondata.processing.store.CarbonFactDataHandlerColumnar;
import org.apache.carbondata.processing.store.CarbonFactDataHandlerModel;
import org.apache.carbondata.processing.store.CarbonFactHandler;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;

public class RowResultProcessor {
    private CarbonFactHandler dataHandler;
    private SegmentProperties segmentProperties;
    private CarbonColumn[] noDicAndComplexColumns;
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)RowResultProcessor.class.getName());

    public RowResultProcessor(CarbonTable carbonTable, CarbonLoadModel loadModel, SegmentProperties segProp, String[] tempStoreLocation, Integer bucketId) {
        CarbonDataProcessorUtil.createLocations(tempStoreLocation);
        this.segmentProperties = segProp;
        String tableName = carbonTable.getTableName();
        String carbonStoreLocation = CarbonDataProcessorUtil.createCarbonStoreLocation(loadModel.getDatabaseName(), tableName, loadModel.getSegmentId());
        CarbonFactDataHandlerModel carbonFactDataHandlerModel = CarbonFactDataHandlerModel.getCarbonFactDataHandlerModel(loadModel, carbonTable, segProp, tableName, tempStoreLocation, carbonStoreLocation);
        CarbonDataFileAttributes carbonDataFileAttributes = new CarbonDataFileAttributes(Long.parseLong(loadModel.getTaskNo()), loadModel.getFactTimeStamp());
        carbonFactDataHandlerModel.setCarbonDataFileAttributes(carbonDataFileAttributes);
        carbonFactDataHandlerModel.setBucketId(bucketId);
        carbonFactDataHandlerModel.setCompactionFlow(true);
        carbonFactDataHandlerModel.setSegmentId(loadModel.getSegmentId());
        this.noDicAndComplexColumns = carbonFactDataHandlerModel.getNoDictAndComplexColumns();
        this.dataHandler = new CarbonFactDataHandlerColumnar(carbonFactDataHandlerModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(List<Object[]> resultList) {
        boolean processStatus;
        boolean isDataPresent = false;
        try {
            if (!isDataPresent) {
                this.dataHandler.initialise();
                isDataPresent = true;
            }
            for (Object[] row : resultList) {
                this.addRow(row);
            }
            if (isDataPresent) {
                this.dataHandler.finish();
            }
            processStatus = true;
        }
        catch (CarbonDataWriterException e) {
            LOGGER.error((Throwable)e, e.getMessage());
            LOGGER.error("Exception in executing RowResultProcessor" + e.getMessage());
            processStatus = false;
        }
        finally {
            try {
                if (isDataPresent) {
                    this.dataHandler.closeHandler();
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception while closing the handler in RowResultProcessor" + e.getMessage());
                processStatus = false;
            }
        }
        return processStatus;
    }

    private void addRow(Object[] carbonTuple) throws CarbonDataWriterException {
        CarbonRow row = WriteStepRowUtil.fromMergerRow((Object[])carbonTuple, (SegmentProperties)this.segmentProperties, (CarbonColumn[])this.noDicAndComplexColumns);
        try {
            this.dataHandler.addDataToStore(row);
        }
        catch (CarbonDataWriterException e) {
            throw new CarbonDataWriterException("Exception in adding rows in RowResultProcessor", (Throwable)e);
        }
    }
}

