/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.sort.sortdata;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonThreadFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.processing.loading.row.IntermediateSortTempRow;
import org.apache.carbondata.processing.loading.sort.SortStepRowHandler;
import org.apache.carbondata.processing.sort.exception.CarbonSortKeyAndGroupByException;
import org.apache.carbondata.processing.sort.sortdata.IntermediateSortTempRowComparator;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;
import org.apache.carbondata.processing.sort.sortdata.TableFieldStat;

public class SortTempFileChunkHolder
implements Comparable<SortTempFileChunkHolder> {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)SortTempFileChunkHolder.class.getName());
    private File tempFile;
    private DataInputStream stream;
    private int entryCount;
    private int numberOfObjectRead;
    private IntermediateSortTempRow returnRow;
    private int readBufferSize;
    private String compressorName;
    private IntermediateSortTempRow[] currentBuffer;
    private IntermediateSortTempRow[] backupBuffer;
    private boolean isBackupFilled;
    private boolean prefetch;
    private int bufferSize;
    private int bufferRowCounter;
    private ExecutorService executorService;
    private Future<Void> submit;
    private int prefetchRecordsProceesed;
    private int totalRecordFetch;
    private TableFieldStat tableFieldStat;
    private SortStepRowHandler sortStepRowHandler;
    private Comparator<IntermediateSortTempRow> comparator;
    private boolean convertToActualField;

    public SortTempFileChunkHolder(File tempFile, SortParameters sortParameters, String tableName, boolean convertToActualField) {
        this.tempFile = tempFile;
        this.readBufferSize = sortParameters.getBufferSize();
        this.compressorName = sortParameters.getSortTempCompressorName();
        this.tableFieldStat = new TableFieldStat(sortParameters);
        this.sortStepRowHandler = new SortStepRowHandler(this.tableFieldStat);
        this.comparator = new IntermediateSortTempRowComparator(this.tableFieldStat.getIsSortColNoDictFlags(), this.tableFieldStat.getNoDictDataType());
        this.executorService = Executors.newFixedThreadPool(1, (ThreadFactory)new CarbonThreadFactory("SafeSortTempChunkHolderPool:" + tableName));
        this.convertToActualField = convertToActualField;
    }

    public void initialize() throws CarbonSortKeyAndGroupByException {
        this.prefetch = Boolean.parseBoolean(CarbonProperties.getInstance().getProperty("carbon.merge.sort.prefetch", "true"));
        this.bufferSize = Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.prefetch.buffersize", "1000"));
        this.initialise();
    }

    private void initialise() throws CarbonSortKeyAndGroupByException {
        try {
            this.stream = FileFactory.getDataInputStream((String)this.tempFile.getPath(), (FileFactory.FileType)FileFactory.FileType.LOCAL, (int)this.readBufferSize, (String)this.compressorName);
            this.entryCount = this.stream.readInt();
            if (this.prefetch) {
                new DataFetcher(false).call();
                this.totalRecordFetch += this.currentBuffer.length;
                if (this.totalRecordFetch < this.entryCount) {
                    this.submit = this.executorService.submit(new DataFetcher(true));
                }
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Throwable)e);
            throw new CarbonSortKeyAndGroupByException(this.tempFile + " No Found", e);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
            throw new CarbonSortKeyAndGroupByException(this.tempFile + " No Found", e);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            throw new CarbonSortKeyAndGroupByException(this.tempFile + " Problem while reading", e);
        }
    }

    public void readRow() throws CarbonSortKeyAndGroupByException {
        if (this.prefetch) {
            this.fillDataForPrefetch();
        } else {
            try {
                this.returnRow = this.convertToActualField ? this.sortStepRowHandler.readWithNoSortFieldConvert(this.stream) : this.sortStepRowHandler.readWithoutNoSortFieldConvert(this.stream);
                ++this.numberOfObjectRead;
            }
            catch (IOException e) {
                throw new CarbonSortKeyAndGroupByException("Problem while reading rows", e);
            }
        }
    }

    private void fillDataForPrefetch() {
        if (this.bufferRowCounter >= this.bufferSize) {
            if (this.isBackupFilled) {
                this.bufferRowCounter = 0;
                this.currentBuffer = this.backupBuffer;
                this.totalRecordFetch += this.currentBuffer.length;
                this.isBackupFilled = false;
                if (this.totalRecordFetch < this.entryCount) {
                    this.submit = this.executorService.submit(new DataFetcher(true));
                }
            } else {
                try {
                    this.submit.get();
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                }
                this.bufferRowCounter = 0;
                this.currentBuffer = this.backupBuffer;
                this.isBackupFilled = false;
                this.totalRecordFetch += this.currentBuffer.length;
                if (this.totalRecordFetch < this.entryCount) {
                    this.submit = this.executorService.submit(new DataFetcher(true));
                }
            }
        }
        ++this.prefetchRecordsProceesed;
        this.returnRow = this.currentBuffer[this.bufferRowCounter++];
    }

    private IntermediateSortTempRow[] readBatchedRowFromStream(int expected) throws IOException {
        IntermediateSortTempRow[] holders = new IntermediateSortTempRow[expected];
        for (int i = 0; i < expected; ++i) {
            holders[i] = this.convertToActualField ? this.sortStepRowHandler.readWithNoSortFieldConvert(this.stream) : this.sortStepRowHandler.readWithoutNoSortFieldConvert(this.stream);
        }
        this.numberOfObjectRead += expected;
        return holders;
    }

    public IntermediateSortTempRow getRow() {
        return this.returnRow;
    }

    public boolean hasNext() {
        if (this.prefetch) {
            return this.prefetchRecordsProceesed < this.entryCount;
        }
        return this.numberOfObjectRead < this.entryCount;
    }

    public void closeStream() {
        CarbonUtil.closeStreams((Closeable[])new Closeable[]{this.stream});
        if (null != this.executorService) {
            this.executorService.shutdownNow();
        }
        this.backupBuffer = null;
        this.currentBuffer = null;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    @Override
    public int compareTo(SortTempFileChunkHolder other) {
        return this.comparator.compare(this.returnRow, other.getRow());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SortTempFileChunkHolder)) {
            return false;
        }
        SortTempFileChunkHolder o = (SortTempFileChunkHolder)obj;
        return this == o;
    }

    public int hashCode() {
        int hash = 0;
        hash += this.tableFieldStat.hashCode();
        return hash += this.tempFile.hashCode();
    }

    private IntermediateSortTempRow[] prefetchRecordsFromFile(int numberOfRecords) throws IOException {
        return this.readBatchedRowFromStream(numberOfRecords);
    }

    static /* synthetic */ IntermediateSortTempRow[] access$402(SortTempFileChunkHolder x0, IntermediateSortTempRow[] x1) {
        x0.backupBuffer = x1;
        return x1;
    }

    static /* synthetic */ IntermediateSortTempRow[] access$702(SortTempFileChunkHolder x0, IntermediateSortTempRow[] x1) {
        x0.currentBuffer = x1;
        return x1;
    }

    private final class DataFetcher
    implements Callable<Void> {
        private boolean isBackUpFilling;
        private int numberOfRecords;

        private DataFetcher(boolean backUp) {
            this.isBackUpFilling = backUp;
            this.calculateNumberOfRecordsToBeFetched();
        }

        private void calculateNumberOfRecordsToBeFetched() {
            int numberOfRecordsLeftToBeRead = SortTempFileChunkHolder.this.entryCount - SortTempFileChunkHolder.this.totalRecordFetch;
            this.numberOfRecords = SortTempFileChunkHolder.this.bufferSize < numberOfRecordsLeftToBeRead ? SortTempFileChunkHolder.this.bufferSize : numberOfRecordsLeftToBeRead;
        }

        @Override
        public Void call() throws Exception {
            try {
                if (this.isBackUpFilling) {
                    SortTempFileChunkHolder.access$402(SortTempFileChunkHolder.this, SortTempFileChunkHolder.this.prefetchRecordsFromFile(this.numberOfRecords));
                    SortTempFileChunkHolder.this.isBackupFilled = true;
                } else {
                    SortTempFileChunkHolder.access$702(SortTempFileChunkHolder.this, SortTempFileChunkHolder.this.prefetchRecordsFromFile(this.numberOfRecords));
                }
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
            }
            return null;
        }
    }
}

