/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.sort.sortdata;

import java.io.Serializable;
import java.util.Objects;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;

public class TableFieldStat
implements Serializable {
    private static final long serialVersionUID = 201712070950L;
    private int dictSortDimCnt = 0;
    private int dictNoSortDimCnt = 0;
    private int noDictSortDimCnt = 0;
    private int noDictNoSortDimCnt = 0;
    private int complexDimCnt = 0;
    private int varcharDimCnt = 0;
    private boolean[] isSortColNoDictFlags;
    private boolean[] isVarcharDimFlags;
    private int measureCnt;
    private DataType[] measureDataType;
    private DataType[] noDictDataType;
    private DataType[] noDictSortDataType;
    private DataType[] noDictNoSortDataType;
    private int[] dictSortDimIdx;
    private int[] dictNoSortDimIdx;
    private int[] noDictSortDimIdx;
    private int[] noDictNoSortDimIdx;
    private int[] varcharDimIdx;
    private int[] complexDimIdx;
    private int[] measureIdx;

    public TableFieldStat(SortParameters sortParameters) {
        int i;
        int noDictDimCnt = sortParameters.getNoDictionaryCount();
        int dictDimCnt = sortParameters.getDimColCount() - noDictDimCnt;
        this.complexDimCnt = sortParameters.getComplexDimColCount();
        this.isSortColNoDictFlags = sortParameters.getNoDictionarySortColumn();
        this.isVarcharDimFlags = sortParameters.getIsVarcharDimensionColumn();
        boolean[] isDimNoDictFlags = sortParameters.getNoDictionaryDimnesionColumn();
        boolean[] sortColumn = sortParameters.getSortColumn();
        for (int i2 = 0; i2 < isDimNoDictFlags.length; ++i2) {
            if (isDimNoDictFlags[i2] && sortColumn[i2]) {
                ++this.noDictSortDimCnt;
                continue;
            }
            if (isDimNoDictFlags[i2] || !sortColumn[i2]) continue;
            ++this.dictSortDimCnt;
        }
        this.measureCnt = sortParameters.getMeasureColCount();
        this.measureDataType = sortParameters.getMeasureDataType();
        this.noDictDataType = sortParameters.getNoDictDataType();
        this.noDictSortDataType = sortParameters.getNoDictSortDataType();
        this.noDictNoSortDataType = sortParameters.getNoDictNoSortDataType();
        for (boolean flag : this.isVarcharDimFlags) {
            if (!flag) continue;
            ++this.varcharDimCnt;
        }
        this.dictSortDimIdx = new int[this.dictSortDimCnt];
        this.dictNoSortDimIdx = new int[dictDimCnt - this.dictSortDimCnt];
        this.noDictSortDimIdx = new int[this.noDictSortDimCnt];
        this.noDictNoSortDimIdx = new int[noDictDimCnt - this.noDictSortDimCnt - this.varcharDimCnt];
        this.complexDimIdx = new int[this.complexDimCnt];
        this.varcharDimIdx = new int[this.varcharDimCnt];
        this.measureIdx = new int[this.measureCnt];
        int tmpNoDictSortCnt = 0;
        int tmpNoDictNoSortCnt = 0;
        int tmpDictSortCnt = 0;
        int tmpDictNoSortCnt = 0;
        int tmpVarcharCnt = 0;
        for (int i3 = 0; i3 < isDimNoDictFlags.length; ++i3) {
            if (isDimNoDictFlags[i3]) {
                if (this.isVarcharDimFlags[i3]) {
                    this.varcharDimIdx[tmpVarcharCnt++] = i3;
                    continue;
                }
                if (sortColumn[i3]) {
                    this.noDictSortDimIdx[tmpNoDictSortCnt++] = i3;
                    continue;
                }
                this.noDictNoSortDimIdx[tmpNoDictNoSortCnt++] = i3;
                continue;
            }
            if (sortColumn[i3]) {
                this.dictSortDimIdx[tmpDictSortCnt++] = i3;
                continue;
            }
            this.dictNoSortDimIdx[tmpDictNoSortCnt++] = i3;
        }
        this.dictNoSortDimCnt = tmpDictNoSortCnt;
        this.noDictNoSortDimCnt = tmpNoDictNoSortCnt;
        int base = isDimNoDictFlags.length;
        for (i = 0; i < this.complexDimCnt; ++i) {
            this.complexDimIdx[i] = base + i;
        }
        base += this.complexDimCnt;
        for (i = 0; i < this.measureCnt; ++i) {
            this.measureIdx[i] = base + i;
        }
    }

    public int getDictSortDimCnt() {
        return this.dictSortDimCnt;
    }

    public int getDictNoSortDimCnt() {
        return this.dictNoSortDimCnt;
    }

    public int getNoDictSortDimCnt() {
        return this.noDictSortDimCnt;
    }

    public int getNoDictNoSortDimCnt() {
        return this.noDictNoSortDimCnt;
    }

    public int getComplexDimCnt() {
        return this.complexDimCnt;
    }

    public int getVarcharDimCnt() {
        return this.varcharDimCnt;
    }

    public boolean[] getIsSortColNoDictFlags() {
        return this.isSortColNoDictFlags;
    }

    public boolean[] getIsVarcharDimFlags() {
        return this.isVarcharDimFlags;
    }

    public int getMeasureCnt() {
        return this.measureCnt;
    }

    public DataType[] getMeasureDataType() {
        return this.measureDataType;
    }

    public int[] getDictSortDimIdx() {
        return this.dictSortDimIdx;
    }

    public int[] getDictNoSortDimIdx() {
        return this.dictNoSortDimIdx;
    }

    public int[] getNoDictSortDimIdx() {
        return this.noDictSortDimIdx;
    }

    public int[] getNoDictNoSortDimIdx() {
        return this.noDictNoSortDimIdx;
    }

    public int[] getComplexDimIdx() {
        return this.complexDimIdx;
    }

    public int[] getVarcharDimIdx() {
        return this.varcharDimIdx;
    }

    public int[] getMeasureIdx() {
        return this.measureIdx;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableFieldStat)) {
            return false;
        }
        TableFieldStat that = (TableFieldStat)o;
        return this.dictSortDimCnt == that.dictSortDimCnt && this.dictNoSortDimCnt == that.dictNoSortDimCnt && this.noDictSortDimCnt == that.noDictSortDimCnt && this.noDictNoSortDimCnt == that.noDictNoSortDimCnt && this.complexDimCnt == that.complexDimCnt && this.varcharDimCnt == that.varcharDimCnt && this.measureCnt == that.measureCnt;
    }

    public int hashCode() {
        return Objects.hash(this.dictSortDimCnt, this.dictNoSortDimCnt, this.noDictSortDimCnt, this.noDictNoSortDimCnt, this.complexDimCnt, this.varcharDimCnt, this.measureCnt);
    }

    public DataType[] getNoDictSortDataType() {
        return this.noDictSortDataType;
    }

    public DataType[] getNoDictNoSortDataType() {
        return this.noDictNoSortDataType;
    }

    public DataType[] getNoDictDataType() {
        return this.noDictDataType;
    }
}

