/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.store;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.keygenerator.KeyGenerator;
import org.apache.carbondata.core.localdictionary.generator.LocalDictionaryGenerator;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.CarbonMetadata;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.processing.datamap.DataMapWriterListener;
import org.apache.carbondata.processing.datatypes.GenericDataType;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.loading.sort.SortScopeOptions;
import org.apache.carbondata.processing.store.CarbonDataFileAttributes;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;

public class CarbonFactDataHandlerModel {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)CarbonFactDataHandlerModel.class.getName());
    private String databaseName;
    private String tableName;
    private int blockSize;
    private int measureCount;
    private String[] storeLocation;
    private int[] dimLens;
    private int noDictionaryCount;
    private int dimensionCount;
    private Map<Integer, GenericDataType> complexIndexMap;
    private SegmentProperties segmentProperties;
    private int[] primitiveDimLens;
    private DataType[] measureDataType;
    private CarbonColumn[] noDictAndComplexColumns;
    private CarbonDataFileAttributes carbonDataFileAttributes;
    private String carbonDataDirectoryPath;
    private int[] colCardinality;
    private List<ColumnSchema> wrapperColumnSchema;
    private boolean isCompactionFlow;
    private int bucketId = 0;
    private String segmentId;
    private long schemaUpdatedTimeStamp;
    private int taskExtension;
    private KeyGenerator[] complexDimensionKeyGenerator;
    private TableSpec tableSpec;
    private SortScopeOptions.SortScope sortScope;
    private DataMapWriterListener dataMapWriterlistener;
    private short writingCoresCount;
    private Map<String, LocalDictionaryGenerator> columnLocalDictGenMap;
    private int numberOfCores;
    private List<Integer> varcharDimIdxInNoDict;
    private String columnCompressor;

    public int getBlockSizeInMB() {
        return this.blockSize;
    }

    public void setBlockSizeInMB(int blockSize) {
        this.blockSize = blockSize;
    }

    public static CarbonFactDataHandlerModel createCarbonFactDataHandlerModel(CarbonDataLoadConfiguration configuration, String[] storeLocation, int bucketId, int taskExtension, DataMapWriterListener listener) {
        CarbonTableIdentifier identifier = configuration.getTableIdentifier().getCarbonTableIdentifier();
        int[] dimLensWithComplex = configuration.getCardinalityFinder().getCardinality();
        if (!configuration.isSortTable()) {
            for (int i = 0; i < dimLensWithComplex.length; ++i) {
                if (dimLensWithComplex[i] == 0) continue;
                dimLensWithComplex[i] = Integer.MAX_VALUE;
            }
        }
        CarbonTable carbonTable = CarbonMetadata.getInstance().getCarbonTable(identifier.getDatabaseName(), identifier.getTableName());
        List wrapperColumnSchema = CarbonUtil.getColumnSchemaList((List)carbonTable.getDimensionByTableName(identifier.getTableName()), (List)carbonTable.getMeasureByTableName(identifier.getTableName()));
        int[] colCardinality = CarbonUtil.getFormattedCardinality((int[])dimLensWithComplex, (List)wrapperColumnSchema);
        SegmentProperties segmentProperties = new SegmentProperties(wrapperColumnSchema, colCardinality);
        int[] dimLens = configuration.calcDimensionLengths();
        int dimensionCount = configuration.getDimensionCount();
        int noDictionaryCount = configuration.getNoDictionaryCount();
        int complexDimensionCount = configuration.getComplexDictionaryColumnCount() + configuration.getComplexNonDictionaryColumnCount();
        int measureCount = configuration.getMeasureCount();
        int simpleDimsCount = dimensionCount - noDictionaryCount - complexDimensionCount;
        int[] simpleDimsLen = new int[simpleDimsCount];
        for (int i = 0; i < simpleDimsCount; ++i) {
            simpleDimsLen[i] = dimLens[i];
        }
        int noDictionayDimensionIndex = 0;
        ArrayList<Integer> varcharDimIdxInNoDict = new ArrayList<Integer>();
        for (DataField dataField : configuration.getDataFields()) {
            CarbonColumn column = dataField.getColumn();
            if (dataField.hasDictionaryEncoding()) continue;
            if (!column.isComplex().booleanValue() && column.getDataType() == DataTypes.VARCHAR) {
                varcharDimIdxInNoDict.add(noDictionayDimensionIndex);
            }
            ++noDictionayDimensionIndex;
        }
        int surrIndex = simpleDimsCount;
        Iterator<Map.Entry<String, GenericDataType>> complexMap = CarbonDataProcessorUtil.getComplexTypesMap(configuration.getDataFields(), configuration).entrySet().iterator();
        HashMap<Integer, GenericDataType> complexIndexMap = new HashMap<Integer, GenericDataType>(complexDimensionCount);
        while (complexMap.hasNext()) {
            Map.Entry<String, GenericDataType> complexDataType = complexMap.next();
            complexDataType.getValue().setOutputArrayIndex(0);
            complexIndexMap.put(simpleDimsCount, complexDataType.getValue());
            ++simpleDimsCount;
            ArrayList<GenericDataType> primitiveTypes = new ArrayList<GenericDataType>();
            complexDataType.getValue().getAllPrimitiveChildren(primitiveTypes);
            for (GenericDataType eachPrimitive : primitiveTypes) {
                if (!eachPrimitive.getIsColumnDictionary()) continue;
                eachPrimitive.setSurrogateIndex(surrIndex++);
            }
        }
        CarbonDataFileAttributes carbonDataFileAttributes = new CarbonDataFileAttributes(Long.parseLong(configuration.getTaskNo()), (Long)configuration.getDataLoadProperty("FACT_TIME_STAMP"));
        String carbonDataDirectoryPath = CarbonFactDataHandlerModel.getCarbonDataFolderLocation(configuration);
        CarbonFactDataHandlerModel carbonFactDataHandlerModel = new CarbonFactDataHandlerModel();
        carbonFactDataHandlerModel.setSchemaUpdatedTimeStamp(configuration.getSchemaUpdatedTimeStamp());
        carbonFactDataHandlerModel.setDatabaseName(identifier.getDatabaseName());
        carbonFactDataHandlerModel.setTableName(identifier.getTableName());
        carbonFactDataHandlerModel.setMeasureCount(measureCount);
        carbonFactDataHandlerModel.setStoreLocation(storeLocation);
        carbonFactDataHandlerModel.setDimLens(dimLens);
        carbonFactDataHandlerModel.setNoDictionaryCount(noDictionaryCount);
        carbonFactDataHandlerModel.setDimensionCount(configuration.getDimensionCount() - noDictionaryCount);
        carbonFactDataHandlerModel.setComplexIndexMap(complexIndexMap);
        carbonFactDataHandlerModel.setSegmentProperties(segmentProperties);
        carbonFactDataHandlerModel.setColCardinality(colCardinality);
        carbonFactDataHandlerModel.setMeasureDataType(configuration.getMeasureDataType());
        carbonFactDataHandlerModel.setNoDictAndComplexColumns(configuration.getNoDictAndComplexDimensions());
        carbonFactDataHandlerModel.setWrapperColumnSchema(wrapperColumnSchema);
        carbonFactDataHandlerModel.setPrimitiveDimLens(simpleDimsLen);
        carbonFactDataHandlerModel.setCarbonDataFileAttributes(carbonDataFileAttributes);
        carbonFactDataHandlerModel.setCarbonDataDirectoryPath(carbonDataDirectoryPath);
        carbonFactDataHandlerModel.setBlockSizeInMB(carbonTable.getBlockSizeInMB());
        carbonFactDataHandlerModel.setComplexDimensionKeyGenerator(configuration.createKeyGeneratorForComplexDimension());
        carbonFactDataHandlerModel.bucketId = bucketId;
        carbonFactDataHandlerModel.segmentId = configuration.getSegmentId();
        carbonFactDataHandlerModel.taskExtension = taskExtension;
        carbonFactDataHandlerModel.tableSpec = configuration.getTableSpec();
        carbonFactDataHandlerModel.sortScope = CarbonDataProcessorUtil.getSortScope(configuration);
        carbonFactDataHandlerModel.columnCompressor = configuration.getColumnCompressor();
        if (listener == null) {
            listener = new DataMapWriterListener();
            listener.registerAllWriter(configuration.getTableSpec().getCarbonTable(), configuration.getSegmentId(), CarbonTablePath.getShardName((Long)carbonDataFileAttributes.getTaskId(), (int)bucketId, (int)0, (String)String.valueOf(carbonDataFileAttributes.getFactTimeStamp()), (String)configuration.getSegmentId()), segmentProperties);
        }
        carbonFactDataHandlerModel.dataMapWriterlistener = listener;
        carbonFactDataHandlerModel.writingCoresCount = configuration.getWritingCoresCount();
        CarbonFactDataHandlerModel.setNumberOfCores(carbonFactDataHandlerModel);
        carbonFactDataHandlerModel.setVarcharDimIdxInNoDict(varcharDimIdxInNoDict);
        return carbonFactDataHandlerModel;
    }

    public static CarbonFactDataHandlerModel getCarbonFactDataHandlerModel(CarbonLoadModel loadModel, CarbonTable carbonTable, SegmentProperties segmentProperties, String tableName, String[] tempStoreLocation, String carbonDataDirectoryPath) {
        ArrayList<Integer> varcharDimIdxInNoDict = new ArrayList<Integer>();
        List allDimensions = carbonTable.getDimensions();
        int dictDimCount = allDimensions.size() - segmentProperties.getNumberOfNoDictionaryDimension() - segmentProperties.getComplexDimensions().size();
        CarbonColumn[] noDicAndComplexColumns = new CarbonColumn[segmentProperties.getNumberOfNoDictionaryDimension() + segmentProperties.getComplexDimensions().size()];
        int noDicAndComp = 0;
        for (CarbonDimension dim : allDimensions) {
            if (!dim.isComplex().booleanValue() && !dim.hasEncoding(Encoding.DICTIONARY) && dim.getDataType() == DataTypes.VARCHAR) {
                varcharDimIdxInNoDict.add(dim.getOrdinal() - dictDimCount);
            }
            if (dim.hasEncoding(Encoding.DICTIONARY)) continue;
            noDicAndComplexColumns[noDicAndComp++] = new CarbonColumn(dim.getColumnSchema(), dim.getOrdinal(), dim.getSchemaOrdinal());
        }
        CarbonFactDataHandlerModel carbonFactDataHandlerModel = new CarbonFactDataHandlerModel();
        carbonFactDataHandlerModel.setSchemaUpdatedTimeStamp(carbonTable.getTableLastUpdatedTime());
        carbonFactDataHandlerModel.setDatabaseName(loadModel.getDatabaseName());
        carbonFactDataHandlerModel.setTableName(tableName);
        carbonFactDataHandlerModel.setMeasureCount(segmentProperties.getMeasures().size());
        carbonFactDataHandlerModel.setStoreLocation(tempStoreLocation);
        carbonFactDataHandlerModel.setDimLens(segmentProperties.getDimColumnsCardinality());
        carbonFactDataHandlerModel.setSegmentProperties(segmentProperties);
        carbonFactDataHandlerModel.setSegmentId(loadModel.getSegmentId());
        carbonFactDataHandlerModel.setNoDictionaryCount(segmentProperties.getNumberOfNoDictionaryDimension());
        carbonFactDataHandlerModel.setDimensionCount(segmentProperties.getDimensions().size() - carbonFactDataHandlerModel.getNoDictionaryCount());
        List wrapperColumnSchema = CarbonUtil.getColumnSchemaList((List)carbonTable.getDimensionByTableName(tableName), (List)carbonTable.getMeasureByTableName(tableName));
        carbonFactDataHandlerModel.setWrapperColumnSchema(wrapperColumnSchema);
        int[] formattedCardinality = CarbonUtil.getFormattedCardinality((int[])segmentProperties.getDimColumnsCardinality(), (List)wrapperColumnSchema);
        carbonFactDataHandlerModel.setColCardinality(formattedCardinality);
        HashMap<Integer, GenericDataType> complexIndexMap = new HashMap<Integer, GenericDataType>(segmentProperties.getComplexDimensions().size());
        carbonFactDataHandlerModel.setComplexIndexMap(complexIndexMap);
        DataType[] measureDataTypes = new DataType[segmentProperties.getMeasures().size()];
        int i = 0;
        for (CarbonMeasure msr : segmentProperties.getMeasures()) {
            measureDataTypes[i++] = msr.getDataType();
        }
        carbonFactDataHandlerModel.setMeasureDataType(measureDataTypes);
        carbonFactDataHandlerModel.setNoDictAndComplexColumns(noDicAndComplexColumns);
        CarbonUtil.checkAndCreateFolderWithPermission((String)carbonDataDirectoryPath);
        carbonFactDataHandlerModel.setCarbonDataDirectoryPath(carbonDataDirectoryPath);
        carbonFactDataHandlerModel.setPrimitiveDimLens(segmentProperties.getDimColumnsCardinality());
        carbonFactDataHandlerModel.setBlockSizeInMB(carbonTable.getBlockSizeInMB());
        carbonFactDataHandlerModel.setColumnCompressor(loadModel.getColumnCompressor());
        carbonFactDataHandlerModel.tableSpec = new TableSpec(carbonTable);
        DataMapWriterListener listener = new DataMapWriterListener();
        listener.registerAllWriter(carbonTable, loadModel.getSegmentId(), CarbonTablePath.getShardName((Long)CarbonTablePath.DataFileUtil.getTaskIdFromTaskNo((String)loadModel.getTaskNo()), (int)carbonFactDataHandlerModel.getBucketId(), (int)carbonFactDataHandlerModel.getTaskExtension(), (String)String.valueOf(loadModel.getFactTimeStamp()), (String)loadModel.getSegmentId()), segmentProperties);
        carbonFactDataHandlerModel.dataMapWriterlistener = listener;
        CarbonFactDataHandlerModel.setNumberOfCores(carbonFactDataHandlerModel);
        carbonFactDataHandlerModel.setColumnLocalDictGenMap(CarbonUtil.getLocalDictionaryModel((CarbonTable)carbonTable));
        carbonFactDataHandlerModel.setVarcharDimIdxInNoDict(varcharDimIdxInNoDict);
        return carbonFactDataHandlerModel;
    }

    private static String getCarbonDataFolderLocation(CarbonDataLoadConfiguration configuration) {
        if (configuration.getDataWritePath() != null) {
            AbsoluteTableIdentifier absoluteTableIdentifier;
            String partPath;
            String paths = configuration.getDataWritePath();
            String[] dirs = paths.split(partPath = (absoluteTableIdentifier = configuration.getTableIdentifier()).getTablePath());
            if (dirs.length > 1) {
                String[] partDirs;
                for (String partDir : partDirs = dirs[1].split("/")) {
                    if (partDir.isEmpty()) continue;
                    partPath = partPath.concat("/" + partDir);
                    CarbonUtil.checkAndCreateFolderWithPermission((String)partPath);
                }
            } else {
                CarbonUtil.checkAndCreateFolderWithPermission((String)paths);
            }
            return paths;
        }
        AbsoluteTableIdentifier absoluteTableIdentifier = configuration.getTableIdentifier();
        String carbonDataDirectoryPath = !configuration.isCarbonTransactionalTable() ? absoluteTableIdentifier.getTablePath() : CarbonTablePath.getSegmentPath((String)absoluteTableIdentifier.getTablePath(), (String)(configuration.getSegmentId() + ""));
        CarbonUtil.checkAndCreateFolder((String)carbonDataDirectoryPath);
        return carbonDataDirectoryPath;
    }

    public int[] getColCardinality() {
        return this.colCardinality;
    }

    public void setColCardinality(int[] colCardinality) {
        this.colCardinality = colCardinality;
    }

    public CarbonDataFileAttributes getCarbonDataFileAttributes() {
        return this.carbonDataFileAttributes;
    }

    public void setCarbonDataFileAttributes(CarbonDataFileAttributes carbonDataFileAttributes) {
        this.carbonDataFileAttributes = carbonDataFileAttributes;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public int getMeasureCount() {
        return this.measureCount;
    }

    public void setMeasureCount(int measureCount) {
        this.measureCount = measureCount;
    }

    public String[] getStoreLocation() {
        return this.storeLocation;
    }

    public void setStoreLocation(String[] storeLocation) {
        this.storeLocation = storeLocation;
    }

    public int[] getDimLens() {
        return this.dimLens;
    }

    public void setDimLens(int[] dimLens) {
        this.dimLens = dimLens;
    }

    public int getNoDictionaryCount() {
        return this.noDictionaryCount;
    }

    public void setNoDictionaryCount(int noDictionaryCount) {
        this.noDictionaryCount = noDictionaryCount;
    }

    public int getDimensionCount() {
        return this.dimensionCount;
    }

    public void setDimensionCount(int dimensionCount) {
        this.dimensionCount = dimensionCount;
    }

    public Map<Integer, GenericDataType> getComplexIndexMap() {
        return this.complexIndexMap;
    }

    public void setComplexIndexMap(Map<Integer, GenericDataType> complexIndexMap) {
        this.complexIndexMap = complexIndexMap;
    }

    public int[] getPrimitiveDimLens() {
        return this.primitiveDimLens;
    }

    public void setPrimitiveDimLens(int[] primitiveDimLens) {
        this.primitiveDimLens = primitiveDimLens;
    }

    public DataType[] getMeasureDataType() {
        return this.measureDataType;
    }

    public void setMeasureDataType(DataType[] measureDataType) {
        this.measureDataType = measureDataType;
    }

    public String getCarbonDataDirectoryPath() {
        return this.carbonDataDirectoryPath;
    }

    public void setCarbonDataDirectoryPath(String carbonDataDirectoryPath) {
        this.carbonDataDirectoryPath = carbonDataDirectoryPath;
    }

    public boolean isCompactionFlow() {
        return this.isCompactionFlow;
    }

    public void setCompactionFlow(boolean compactionFlow) {
        this.isCompactionFlow = compactionFlow;
    }

    public SegmentProperties getSegmentProperties() {
        return this.segmentProperties;
    }

    public void setSegmentProperties(SegmentProperties segmentProperties) {
        this.segmentProperties = segmentProperties;
    }

    public List<ColumnSchema> getWrapperColumnSchema() {
        return this.wrapperColumnSchema;
    }

    public void setWrapperColumnSchema(List<ColumnSchema> wrapperColumnSchema) {
        this.wrapperColumnSchema = wrapperColumnSchema;
    }

    public int getBucketId() {
        return this.bucketId;
    }

    public void setBucketId(Integer bucketId) {
        this.bucketId = bucketId;
    }

    public long getSchemaUpdatedTimeStamp() {
        return this.schemaUpdatedTimeStamp;
    }

    public void setSchemaUpdatedTimeStamp(long schemaUpdatedTimeStamp) {
        this.schemaUpdatedTimeStamp = schemaUpdatedTimeStamp;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public void setSegmentId(String segmentId) {
        this.segmentId = segmentId;
    }

    public int getTaskExtension() {
        return this.taskExtension;
    }

    public KeyGenerator[] getComplexDimensionKeyGenerator() {
        return this.complexDimensionKeyGenerator;
    }

    public void setComplexDimensionKeyGenerator(KeyGenerator[] complexDimensionKeyGenerator) {
        this.complexDimensionKeyGenerator = complexDimensionKeyGenerator;
    }

    public KeyGenerator getMDKeyGenerator() {
        return this.segmentProperties.getDimensionKeyGenerator();
    }

    public int getComplexColumnCount() {
        return this.complexIndexMap.size();
    }

    public int getExpandedComplexColsCount() {
        int count = 0;
        int dictDimensionCount = this.getDimensionCount();
        for (int i = 0; i < dictDimensionCount; ++i) {
            GenericDataType complexDataType = this.getComplexIndexMap().get(i);
            if (complexDataType == null) continue;
            count += complexDataType.getColsCount();
        }
        return count;
    }

    public TableSpec getTableSpec() {
        return this.tableSpec;
    }

    public SortScopeOptions.SortScope getSortScope() {
        return this.sortScope;
    }

    public short getWritingCoresCount() {
        return this.writingCoresCount;
    }

    public DataMapWriterListener getDataMapWriterlistener() {
        return this.dataMapWriterlistener;
    }

    public Map<String, LocalDictionaryGenerator> getColumnLocalDictGenMap() {
        return this.columnLocalDictGenMap;
    }

    public void setColumnLocalDictGenMap(Map<String, LocalDictionaryGenerator> columnLocalDictGenMap) {
        this.columnLocalDictGenMap = columnLocalDictGenMap;
    }

    private static void setNumberOfCores(CarbonFactDataHandlerModel model) {
        if (model.isCompactionFlow()) {
            try {
                model.numberOfCores = Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.number.of.cores.while.compacting", "2"));
            }
            catch (NumberFormatException exc) {
                LOGGER.error("Configured value for property carbon.number.of.cores.while.compactingis wrong.Falling back to the default value 2");
                model.numberOfCores = Integer.parseInt("2");
            }
        } else {
            model.numberOfCores = CarbonProperties.getInstance().getNumberOfCores();
        }
        if (model.sortScope != null && model.sortScope.equals((Object)SortScopeOptions.SortScope.GLOBAL_SORT)) {
            model.numberOfCores = 1;
        }
        if (model.getWritingCoresCount() > 0) {
            model.numberOfCores = model.getWritingCoresCount();
        }
    }

    public int getNumberOfCores() {
        return this.numberOfCores;
    }

    public void setVarcharDimIdxInNoDict(List<Integer> varcharDimIdxInNoDict) {
        this.varcharDimIdxInNoDict = varcharDimIdxInNoDict;
    }

    public List<Integer> getVarcharDimIdxInNoDict() {
        return this.varcharDimIdxInNoDict;
    }

    public String getColumnCompressor() {
        return this.columnCompressor;
    }

    public void setColumnCompressor(String columnCompressor) {
        this.columnCompressor = columnCompressor;
    }

    public CarbonColumn[] getNoDictAndComplexColumns() {
        return this.noDictAndComplexColumns;
    }

    public void setNoDictAndComplexColumns(CarbonColumn[] noDictAndComplexColumns) {
        this.noDictAndComplexColumns = noDictAndComplexColumns;
    }
}

