/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.store;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.ColumnType;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.datastore.exception.CarbonDataWriterException;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.ComplexColumnPage;
import org.apache.carbondata.core.datastore.page.EncodedTablePage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoder;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.datastore.page.encoding.DefaultEncodingFactory;
import org.apache.carbondata.core.datastore.page.encoding.EncodedColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.EncodingFactory;
import org.apache.carbondata.core.datastore.page.key.TablePageKey;
import org.apache.carbondata.core.datastore.page.statistics.ColumnPageStatsCollector;
import org.apache.carbondata.core.datastore.page.statistics.KeyPageStatsCollector;
import org.apache.carbondata.core.datastore.page.statistics.LVLongStringStatsCollector;
import org.apache.carbondata.core.datastore.page.statistics.LVShortStringStatsCollector;
import org.apache.carbondata.core.datastore.page.statistics.PrimitivePageStatsCollector;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.datastore.row.ComplexColumnInfo;
import org.apache.carbondata.core.datastore.row.WriteStepRowUtil;
import org.apache.carbondata.core.keygenerator.KeyGenException;
import org.apache.carbondata.core.keygenerator.KeyGenerator;
import org.apache.carbondata.core.localdictionary.generator.LocalDictionaryGenerator;
import org.apache.carbondata.core.memory.MemoryException;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.processing.datatypes.GenericDataType;
import org.apache.carbondata.processing.store.CarbonFactDataHandlerModel;

public class TablePage {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)TablePage.class.getName());
    private ColumnPage[] dictDimensionPages;
    private ColumnPage[] noDictDimensionPages;
    private ColumnPage[] measurePages;
    private ComplexColumnPage[] complexDimensionPages;
    private int pageSize;
    private CarbonFactDataHandlerModel model;
    private TablePageKey key;
    private EncodedTablePage encodedTablePage;
    private EncodingFactory encodingFactory = DefaultEncodingFactory.getInstance();
    private boolean isLastPage;
    private Map<Integer, GenericDataType> complexIndexMap = null;
    private String columnCompressor;

    TablePage(CarbonFactDataHandlerModel model, int pageSize) throws MemoryException {
        ColumnPage page;
        int i;
        this.model = model;
        this.pageSize = pageSize;
        int numDictDimension = model.getMDKeyGenerator().getDimCount();
        TableSpec tableSpec = model.getTableSpec();
        this.columnCompressor = model.getColumnCompressor();
        this.dictDimensionPages = new ColumnPage[numDictDimension];
        this.noDictDimensionPages = new ColumnPage[model.getNoDictionaryCount()];
        int tmpNumDictDimIdx = 0;
        int tmpNumNoDictDimIdx = 0;
        for (i = 0; i < this.dictDimensionPages.length + this.noDictDimensionPages.length; ++i) {
            TableSpec.DimensionSpec spec = tableSpec.getDimensionSpec(i);
            ColumnType columnType = tableSpec.getDimensionSpec(i).getColumnType();
            if (ColumnType.GLOBAL_DICTIONARY == columnType || ColumnType.DIRECT_DICTIONARY == columnType) {
                page = ColumnPage.newPage((ColumnPageEncoderMeta)new ColumnPageEncoderMeta((TableSpec.ColumnSpec)spec, DataTypes.BYTE_ARRAY, this.columnCompressor), (int)pageSize);
                page.setStatsCollector((ColumnPageStatsCollector)KeyPageStatsCollector.newInstance((DataType)DataTypes.BYTE_ARRAY));
                this.dictDimensionPages[tmpNumDictDimIdx++] = page;
                continue;
            }
            LocalDictionaryGenerator localDictionaryGenerator = model.getColumnLocalDictGenMap().get(spec.getFieldName());
            DataType dataType = DataTypes.STRING;
            if (DataTypes.VARCHAR == spec.getSchemaDataType()) {
                dataType = DataTypes.VARCHAR;
            }
            ColumnPageEncoderMeta columnPageEncoderMeta = new ColumnPageEncoderMeta((TableSpec.ColumnSpec)spec, dataType, this.columnCompressor);
            if (null != localDictionaryGenerator) {
                page = ColumnPage.newLocalDictPage((ColumnPageEncoderMeta)columnPageEncoderMeta, (int)pageSize, (LocalDictionaryGenerator)localDictionaryGenerator, (boolean)false);
            } else if (DataTypeUtil.isPrimitiveColumn((DataType)spec.getSchemaDataType())) {
                columnPageEncoderMeta = spec.getSchemaDataType() == DataTypes.TIMESTAMP ? new ColumnPageEncoderMeta((TableSpec.ColumnSpec)spec, DataTypes.LONG, this.columnCompressor) : new ColumnPageEncoderMeta((TableSpec.ColumnSpec)spec, spec.getSchemaDataType(), this.columnCompressor);
                page = DataTypes.isDecimal((DataType)spec.getSchemaDataType()) ? ColumnPage.newDecimalPage((ColumnPageEncoderMeta)columnPageEncoderMeta, (int)pageSize) : ColumnPage.newPage((ColumnPageEncoderMeta)columnPageEncoderMeta, (int)pageSize);
            } else {
                page = ColumnPage.newPage((ColumnPageEncoderMeta)columnPageEncoderMeta, (int)pageSize);
            }
            if (DataTypes.VARCHAR == dataType) {
                page.setStatsCollector((ColumnPageStatsCollector)LVLongStringStatsCollector.newInstance());
            } else if (DataTypeUtil.isPrimitiveColumn((DataType)spec.getSchemaDataType())) {
                if (spec.getSchemaDataType() == DataTypes.TIMESTAMP) {
                    page.setStatsCollector((ColumnPageStatsCollector)PrimitivePageStatsCollector.newInstance((DataType)DataTypes.LONG));
                } else {
                    page.setStatsCollector((ColumnPageStatsCollector)PrimitivePageStatsCollector.newInstance((DataType)spec.getSchemaDataType()));
                }
            } else {
                page.setStatsCollector((ColumnPageStatsCollector)LVShortStringStatsCollector.newInstance());
            }
            this.noDictDimensionPages[tmpNumNoDictDimIdx++] = page;
        }
        this.complexDimensionPages = new ComplexColumnPage[model.getComplexColumnCount()];
        for (i = 0; i < this.complexDimensionPages.length; ++i) {
            this.complexDimensionPages[i] = null;
        }
        this.measurePages = new ColumnPage[model.getMeasureCount()];
        DataType[] dataTypes = model.getMeasureDataType();
        for (int i2 = 0; i2 < this.measurePages.length; ++i2) {
            ColumnPageEncoderMeta columnPageEncoderMeta = new ColumnPageEncoderMeta((TableSpec.ColumnSpec)model.getTableSpec().getMeasureSpec(i2), dataTypes[i2], this.columnCompressor);
            page = DataTypes.isDecimal((DataType)columnPageEncoderMeta.getSchemaDataType()) ? ColumnPage.newDecimalPage((ColumnPageEncoderMeta)columnPageEncoderMeta, (int)pageSize) : ColumnPage.newPage((ColumnPageEncoderMeta)columnPageEncoderMeta, (int)pageSize);
            page.setStatsCollector((ColumnPageStatsCollector)PrimitivePageStatsCollector.newInstance((DataType)dataTypes[i2]));
            this.measurePages[i2] = page;
        }
        boolean hasNoDictionary = this.noDictDimensionPages.length > 0;
        this.key = new TablePageKey(pageSize, model.getSegmentProperties(), hasNoDictionary);
        this.complexIndexMap = new HashMap<Integer, GenericDataType>();
        for (Map.Entry<Integer, GenericDataType> entry : model.getComplexIndexMap().entrySet()) {
            this.complexIndexMap.put(entry.getKey(), entry.getValue().deepCopy());
        }
    }

    public void addRow(int rowId, CarbonRow row) throws KeyGenException {
        byte[] mdk = WriteStepRowUtil.getMdk((CarbonRow)row, (KeyGenerator)this.model.getMDKeyGenerator());
        this.convertToColumnarAndAddToPages(rowId, row, mdk);
        this.key.update(rowId, row, mdk);
    }

    private void convertToColumnarAndAddToPages(int rowId, CarbonRow row, byte[] mdk) throws KeyGenException {
        byte[][] keys = this.model.getSegmentProperties().getFixedLengthKeySplitter().splitKey(mdk);
        for (int i = 0; i < this.dictDimensionPages.length; ++i) {
            this.dictDimensionPages[i].putData(rowId, (Object)keys[i]);
        }
        int noDictionaryCount = this.noDictDimensionPages.length;
        int complexColumnCount = this.complexDimensionPages.length;
        if (noDictionaryCount > 0 || complexColumnCount > 0) {
            TableSpec tableSpec = this.model.getTableSpec();
            List noDictionaryDimensionSpec = tableSpec.getNoDictionaryDimensionSpec();
            Object[] noDictAndComplex = WriteStepRowUtil.getNoDictAndComplexDimension((CarbonRow)row);
            for (int i = 0; i < noDictAndComplex.length; ++i) {
                byte[] valueWithLength;
                if (((TableSpec.DimensionSpec)noDictionaryDimensionSpec.get(i)).getSchemaDataType() == DataTypes.VARCHAR) {
                    valueWithLength = this.addIntLengthToByteArray((byte[])noDictAndComplex[i]);
                    this.noDictDimensionPages[i].putData(rowId, (Object)valueWithLength);
                    continue;
                }
                if (i < noDictionaryCount) {
                    if (DataTypeUtil.isPrimitiveColumn((DataType)this.noDictDimensionPages[i].getColumnSpec().getSchemaDataType())) {
                        Object value = noDictAndComplex[i];
                        if (DataTypes.isDecimal((DataType)this.noDictDimensionPages[i].getDataType()) && this.model.isCompactionFlow() && value != null) {
                            value = DataTypeUtil.getDataTypeConverter().convertFromDecimalToBigDecimal(value);
                        }
                        this.noDictDimensionPages[i].putData(rowId, value);
                        continue;
                    }
                    valueWithLength = this.addShortLengthToByteArray((byte[])noDictAndComplex[i]);
                    this.noDictDimensionPages[i].putData(rowId, (Object)valueWithLength);
                    continue;
                }
                this.addComplexColumn(i - noDictionaryCount, rowId, (byte[])noDictAndComplex[i]);
            }
        }
        Object[] measureColumns = WriteStepRowUtil.getMeasure((CarbonRow)row);
        for (int i = 0; i < this.measurePages.length; ++i) {
            Object value = measureColumns[i];
            if (DataTypes.isDecimal((DataType)this.measurePages[i].getDataType()) && this.model.isCompactionFlow() && value != null) {
                value = DataTypeUtil.getDataTypeConverter().convertFromDecimalToBigDecimal(value);
            }
            this.measurePages[i].putData(rowId, value);
        }
    }

    private void addComplexColumn(int index, int rowId, byte[] complexColumns) {
        GenericDataType complexDataType = this.complexIndexMap.get(index + this.model.getPrimitiveDimLens().length);
        if (rowId == 0) {
            ArrayList<ComplexColumnInfo> complexColumnInfoList = new ArrayList<ComplexColumnInfo>();
            complexDataType.getComplexColumnInfo(complexColumnInfoList);
            this.complexDimensionPages[index] = new ComplexColumnPage(complexColumnInfoList);
            try {
                this.complexDimensionPages[index].initialize(this.model.getColumnLocalDictGenMap(), this.pageSize, this.columnCompressor);
            }
            catch (MemoryException e) {
                throw new RuntimeException(e);
            }
        }
        int depthInComplexColumn = this.complexDimensionPages[index].getComplexColumnIndex();
        ArrayList<ArrayList<byte[]>> encodedComplexColumnar = new ArrayList<ArrayList<byte[]>>(depthInComplexColumn);
        for (int k = 0; k < depthInComplexColumn; ++k) {
            encodedComplexColumnar.add(new ArrayList());
        }
        try {
            ByteBuffer byteArrayInput = ByteBuffer.wrap(complexColumns);
            ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutput);
            complexDataType.parseComplexValue(byteArrayInput, dataOutputStream, this.model.getComplexDimensionKeyGenerator());
            complexDataType.getColumnarDataForComplexType(encodedComplexColumnar, ByteBuffer.wrap(byteArrayOutput.toByteArray()));
            byteArrayOutput.close();
        }
        catch (IOException | KeyGenException e) {
            throw new CarbonDataWriterException("Problem while bit packing and writing complex datatype", e);
        }
        for (int depth = 0; depth < depthInComplexColumn; ++depth) {
            this.complexDimensionPages[index].putComplexData(depth, (List)encodedComplexColumnar.get(depth));
        }
    }

    void freeMemory() {
        for (ColumnPage columnPage : this.dictDimensionPages) {
            columnPage.freeMemory();
        }
        for (ColumnPage columnPage : this.noDictDimensionPages) {
            columnPage.freeMemory();
        }
        for (ColumnPage columnPage : this.measurePages) {
            columnPage.freeMemory();
        }
        for (ColumnPage columnPage : this.complexDimensionPages) {
            if (null == columnPage) continue;
            columnPage.freeMemory();
        }
    }

    private byte[] addShortLengthToByteArray(byte[] input) {
        if (input.length > Short.MAX_VALUE) {
            throw new RuntimeException("input data length " + input.length + " bytes too long, maximum length supported is " + Short.MAX_VALUE + " bytes");
        }
        byte[] output = new byte[input.length + 2];
        ByteBuffer buffer = ByteBuffer.wrap(output);
        buffer.putShort((short)input.length);
        buffer.put(input, 0, input.length);
        return output;
    }

    private byte[] addIntLengthToByteArray(byte[] input) {
        byte[] output = new byte[input.length + 4];
        ByteBuffer buffer = ByteBuffer.wrap(output);
        buffer.putInt(input.length);
        buffer.put(input, 0, input.length);
        return output;
    }

    void encode() throws KeyGenException, MemoryException, IOException {
        EncodedColumnPage[] dimensions = this.encodeAndCompressDimensions();
        EncodedColumnPage[] measures = this.encodeAndCompressMeasures();
        this.encodedTablePage = EncodedTablePage.newInstance((int)this.pageSize, (EncodedColumnPage[])dimensions, (EncodedColumnPage[])measures, (TablePageKey)this.key);
    }

    public EncodedTablePage getEncodedTablePage() {
        return this.encodedTablePage;
    }

    private EncodedColumnPage[] encodeAndCompressMeasures() throws MemoryException, IOException {
        EncodedColumnPage[] encodedMeasures = new EncodedColumnPage[this.measurePages.length];
        for (int i = 0; i < this.measurePages.length; ++i) {
            ColumnPageEncoder encoder = this.encodingFactory.createEncoder((TableSpec.ColumnSpec)this.model.getTableSpec().getMeasureSpec(i), this.measurePages[i]);
            encodedMeasures[i] = encoder.encode(this.measurePages[i]);
        }
        return encodedMeasures;
    }

    private EncodedColumnPage[] encodeAndCompressDimensions() throws KeyGenException, IOException, MemoryException {
        ArrayList<Object> encodedDimensions = new ArrayList<Object>();
        ArrayList<EncodedColumnPage> encodedComplexDimenions = new ArrayList<EncodedColumnPage>();
        TableSpec tableSpec = this.model.getTableSpec();
        int dictIndex = 0;
        int noDictIndex = 0;
        int complexDimIndex = 0;
        int numDimensions = tableSpec.getNumDimensions();
        block5: for (int i = 0; i < numDimensions; ++i) {
            TableSpec.DimensionSpec spec = tableSpec.getDimensionSpec(i);
            switch (spec.getColumnType()) {
                case GLOBAL_DICTIONARY: 
                case DIRECT_DICTIONARY: {
                    ColumnPageEncoder columnPageEncoder = this.encodingFactory.createEncoder((TableSpec.ColumnSpec)spec, this.dictDimensionPages[dictIndex]);
                    EncodedColumnPage encodedPage = columnPageEncoder.encode(this.dictDimensionPages[dictIndex++]);
                    encodedDimensions.add(encodedPage);
                    continue block5;
                }
                case PLAIN_VALUE: {
                    DataType targetDataType;
                    ColumnPageEncoder columnPageEncoder = this.encodingFactory.createEncoder((TableSpec.ColumnSpec)spec, this.noDictDimensionPages[noDictIndex]);
                    EncodedColumnPage encodedPage = columnPageEncoder.encode(this.noDictDimensionPages[noDictIndex]);
                    if (LOGGER.isDebugEnabled() && null != (targetDataType = columnPageEncoder.getTargetDataType(this.noDictDimensionPages[noDictIndex]))) {
                        LOGGER.debug("Encoder result ---> Source data type: " + this.noDictDimensionPages[noDictIndex].getDataType().getName() + " Destination data type: " + targetDataType.getName() + " for the column: " + this.noDictDimensionPages[noDictIndex].getColumnSpec().getFieldName() + " having encoding type: " + columnPageEncoder.getEncodingType());
                    }
                    ++noDictIndex;
                    encodedDimensions.add(encodedPage);
                    continue block5;
                }
                case COMPLEX: {
                    EncodedColumnPage[] encodedPages = ColumnPageEncoder.encodeComplexColumn((ComplexColumnPage)this.complexDimensionPages[complexDimIndex++]);
                    encodedComplexDimenions.addAll(Arrays.asList(encodedPages));
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("unsupported dimension type:" + spec.getColumnType());
                }
            }
        }
        encodedDimensions.addAll(encodedComplexDimenions);
        return encodedDimensions.toArray(new EncodedColumnPage[encodedDimensions.size()]);
    }

    public ColumnPage getColumnPage(String columnName) {
        String fieldName;
        int dictDimensionIndex = -1;
        int noDictDimensionIndex = -1;
        ColumnPage page = null;
        TableSpec spec = this.model.getTableSpec();
        int numDimensions = spec.getNumDimensions();
        for (int i = 0; i < numDimensions; ++i) {
            ColumnType type = spec.getDimensionSpec(i).getColumnType();
            if (type == ColumnType.GLOBAL_DICTIONARY || type == ColumnType.DIRECT_DICTIONARY) {
                page = this.dictDimensionPages[++dictDimensionIndex];
            } else {
                if (type != ColumnType.PLAIN_VALUE) continue;
                page = this.noDictDimensionPages[++noDictDimensionIndex];
            }
            fieldName = spec.getDimensionSpec(i).getFieldName();
            if (!fieldName.equalsIgnoreCase(columnName)) continue;
            return page;
        }
        int numMeasures = spec.getNumMeasures();
        for (int i = 0; i < numMeasures; ++i) {
            fieldName = spec.getMeasureSpec(i).getFieldName();
            if (!fieldName.equalsIgnoreCase(columnName)) continue;
            return this.measurePages[i];
        }
        throw new IllegalArgumentException("DataMap: must have '" + columnName + "' column in schema");
    }

    public boolean isLastPage() {
        return this.isLastPage;
    }

    public void setIsLastPage(boolean isWriteAll) {
        this.isLastPage = isWriteAll;
    }

    public int getPageSize() {
        return this.pageSize;
    }
}

