/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.util;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.processing.loading.BadRecordsLogger;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;
import org.apache.commons.lang.StringUtils;

public class CarbonBadRecordUtil {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)CarbonDataProcessorUtil.class.getName());

    public static void renameBadRecord(CarbonDataLoadConfiguration configuration) {
        String storeLocation = "";
        storeLocation = configuration.isCarbonTransactionalTable() ? configuration.getSegmentId() + "/" + configuration.getTaskNo() : "SdkWriterBadRecords/" + configuration.getTaskNo();
        CarbonBadRecordUtil.renameBadRecordsFromInProgressToNormal(configuration, storeLocation);
    }

    private static void renameBadRecordsFromInProgressToNormal(CarbonDataLoadConfiguration configuration, String storeLocation) {
        String badLogStoreLocation = (String)configuration.getDataLoadProperty("carbon.options.bad.record.path");
        if (null == badLogStoreLocation) {
            badLogStoreLocation = CarbonProperties.getInstance().getProperty("carbon.badRecords.location");
        }
        badLogStoreLocation = badLogStoreLocation + File.separator + storeLocation;
        FileFactory.FileType fileType = FileFactory.getFileType((String)badLogStoreLocation);
        try {
            if (!FileFactory.isFileExist((String)badLogStoreLocation, (FileFactory.FileType)fileType)) {
                return;
            }
        }
        catch (IOException e1) {
            LOGGER.info("bad record folder does not exist");
        }
        CarbonFile carbonFile = FileFactory.getCarbonFile((String)badLogStoreLocation, (FileFactory.FileType)fileType);
        CarbonFile[] listFiles = carbonFile.listFiles(new CarbonFileFilter(){

            public boolean accept(CarbonFile pathname) {
                return pathname.getName().indexOf(".inprogress") > -1;
            }
        });
        String badRecordsInProgressFileName = null;
        String changedFileName = null;
        for (CarbonFile badFiles : listFiles) {
            badRecordsInProgressFileName = badFiles.getName();
            changedFileName = badLogStoreLocation + File.separator + badRecordsInProgressFileName.substring(0, badRecordsInProgressFileName.lastIndexOf(46));
            badFiles.renameTo(changedFileName);
            if (!badFiles.exists() || badFiles.delete()) continue;
            LOGGER.error("Unable to delete File : " + badFiles.getName());
        }
    }

    public static boolean hasBadRecord(CarbonLoadModel loadModel) {
        String key = loadModel.getCarbonDataLoadSchema().getCarbonTable().getCarbonTableIdentifier().getBadRecordLoggerKey();
        return null != BadRecordsLogger.hasBadRecord(key);
    }

    public static String getBadRecordsPath(Map<String, String> loadOptions, CarbonTable table) {
        String badRecordsPath;
        String badRecordsFromLoad = loadOptions.get("bad_record_path");
        String badRecordsFromCreate = (String)table.getTableInfo().getFactTable().getTableProperties().get("bad_record_path");
        if (StringUtils.isNotEmpty((String)badRecordsFromLoad)) {
            badRecordsPath = badRecordsFromLoad + "/" + table.getDatabaseName() + "/" + table.getTableName();
        } else if (StringUtils.isNotEmpty((String)badRecordsFromCreate)) {
            badRecordsPath = badRecordsFromCreate;
        } else {
            String badRecordsFromProp = CarbonProperties.getInstance().getProperty("carbon.options.bad.record.path", CarbonProperties.getInstance().getProperty("carbon.badRecords.location", ""));
            if (!badRecordsFromProp.isEmpty()) {
                badRecordsFromProp = badRecordsFromProp + "/" + table.getDatabaseName() + "/" + table.getTableName();
            }
            badRecordsPath = badRecordsFromProp;
        }
        return badRecordsPath;
    }
}

