/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.datatypes;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.datastore.ColumnType;
import org.apache.carbondata.core.datastore.row.ComplexColumnInfo;
import org.apache.carbondata.core.devapi.BiDictionary;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.processing.datatypes.GenericDataType;
import org.apache.carbondata.processing.loading.converter.BadRecordLogHolder;
import org.apache.carbondata.processing.loading.converter.impl.binary.BinaryDecoder;
import org.apache.carbondata.processing.loading.dictionary.DirectDictionary;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;

public class PrimitiveDataType
implements GenericDataType<Object> {
    private static final long serialVersionUID = -1518322888733363638L;
    private int index;
    private String name;
    private String parentName;
    private String columnId;
    private int keySize;
    private int outputArrayIndex;
    private int dataCounter;
    private transient BiDictionary<Integer, Object> dictionaryGenerator;
    private CarbonDimension carbonDimension;
    private boolean isDictionary;
    private String nullFormat;
    private boolean isDirectDictionary;
    private DataType dataType;
    private transient BinaryDecoder binaryDecoder;

    private PrimitiveDataType(int outputArrayIndex, int dataCounter) {
        this.outputArrayIndex = outputArrayIndex;
        this.dataCounter = dataCounter;
    }

    public PrimitiveDataType(String name, DataType dataType, String parentName, String columnId, boolean isDictionary, String nullFormat) {
        this.name = name;
        this.parentName = parentName;
        this.columnId = columnId;
        this.isDictionary = isDictionary;
        this.nullFormat = nullFormat;
        this.dataType = dataType;
    }

    public PrimitiveDataType(CarbonColumn carbonColumn, String parentName, String columnId, CarbonDimension carbonDimension, String nullFormat, BinaryDecoder binaryDecoder) {
        this.name = carbonColumn.getColName();
        this.parentName = parentName;
        this.columnId = columnId;
        this.carbonDimension = carbonDimension;
        this.isDictionary = this.isDictionaryDimension(carbonDimension);
        this.nullFormat = nullFormat;
        this.binaryDecoder = binaryDecoder;
        this.dataType = carbonColumn.getDataType();
        if (carbonDimension.hasEncoding(Encoding.DIRECT_DICTIONARY) || carbonColumn.getDataType() == DataTypes.DATE) {
            this.dictionaryGenerator = new DirectDictionary(DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator((DataType)carbonDimension.getDataType(), (String)this.getDateFormat(carbonDimension)));
            this.isDirectDictionary = true;
        }
    }

    private String getDateFormat(CarbonDimension carbonDimension) {
        String dateFormat = null;
        if (this.carbonDimension.getDataType() == DataTypes.DATE) {
            dateFormat = carbonDimension.getDateFormat();
        }
        String format = dateFormat != null && !dateFormat.trim().isEmpty() ? dateFormat : CarbonUtil.getFormatFromProperty((DataType)this.dataType);
        return format;
    }

    private boolean isDictionaryDimension(CarbonDimension carbonDimension) {
        return carbonDimension.hasEncoding(Encoding.DICTIONARY);
    }

    @Override
    public void addChildren(GenericDataType children) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getParentName() {
        return this.parentName;
    }

    @Override
    public String getColumnNames() {
        return this.columnId;
    }

    @Override
    public void getAllPrimitiveChildren(List<GenericDataType> primitiveChild) {
    }

    @Override
    public void setSurrogateIndex(int surrIndex) {
        this.index = this.carbonDimension != null && !this.carbonDimension.hasEncoding(Encoding.DICTIONARY) ? 0 : (this.carbonDimension == null && !this.isDictionary ? 0 : surrIndex);
    }

    @Override
    public boolean getIsColumnDictionary() {
        return this.isDictionary;
    }

    @Override
    public void writeByteArray(Object input, DataOutputStream dataOutputStream, BadRecordLogHolder logHolder, Boolean isWithoutConverter) throws IOException {
        String parsedValue = null;
        if (null == input || (this.carbonDimension.getDataType() == DataTypes.STRING || this.carbonDimension.getDataType() == DataTypes.VARCHAR) && input.equals(this.nullFormat)) {
            this.updateNullValue(dataOutputStream, logHolder);
            return;
        }
        if (!isWithoutConverter.booleanValue() && (null == (parsedValue = DataTypeUtil.parseValue((String)input.toString(), (CarbonDimension)this.carbonDimension)) || (this.carbonDimension.getDataType() == DataTypes.STRING || this.carbonDimension.getDataType() == DataTypes.VARCHAR) && parsedValue.equals(this.nullFormat))) {
            this.updateNullValue(dataOutputStream, logHolder);
            return;
        }
        try {
            if (!this.carbonDimension.getUseActualData()) {
                byte[] value;
                if (this.isDirectDictionary) {
                    value = this.writeDirectDictionary(input, parsedValue, isWithoutConverter);
                } else {
                    value = this.carbonDimension.getDataType().equals((Object)DataTypes.DATE) || this.carbonDimension.getDataType().equals((Object)DataTypes.TIMESTAMP) && input instanceof Long ? (this.dictionaryGenerator != null ? ByteUtil.toXorBytes((int)((DirectDictionary)this.dictionaryGenerator).generateKey((Long)input)) : (isWithoutConverter.booleanValue() ? ByteUtil.toXorBytes((long)((Long)input)) : ByteUtil.toXorBytes((long)Long.parseLong(parsedValue)))) : (this.carbonDimension.getDataType().equals((Object)DataTypes.BINARY) ? (this.binaryDecoder == null ? DataTypeUtil.getBytesDataDataTypeForNoDictionaryColumn((Object)input, (DataType)this.carbonDimension.getDataType()) : (isWithoutConverter.booleanValue() ? this.binaryDecoder.decode((String)input) : this.binaryDecoder.decode(parsedValue))) : (isWithoutConverter != false ? DataTypeUtil.getBytesDataDataTypeForNoDictionaryColumn((Object)input, (DataType)this.carbonDimension.getDataType()) : DataTypeUtil.getBytesBasedOnDataTypeForNoDictionaryColumn((String)parsedValue, (DataType)this.carbonDimension.getDataType(), (String)this.getDateOrTimeFormat())));
                    if (this.carbonDimension.getDataType() == DataTypes.STRING && value.length > 32000) {
                        logHolder.setReason(String.format("Record of column %s exceeded 32000 characters. Please consider long string data type.", this.carbonDimension.getColName()));
                        this.updateNullValue(dataOutputStream, logHolder);
                        return;
                    }
                }
                this.updateValueToByteStream(dataOutputStream, value);
            } else {
                byte[] value = this.dictionaryGenerator instanceof DirectDictionary && input instanceof Long ? ByteUtil.toXorBytes((int)((DirectDictionary)this.dictionaryGenerator).generateKey((Long)input)) : (isWithoutConverter != false ? DataTypeUtil.getBytesDataDataTypeForNoDictionaryColumn((Object)input, (DataType)this.carbonDimension.getDataType()) : DataTypeUtil.getBytesBasedOnDataTypeForNoDictionaryColumn((String)parsedValue, (DataType)this.carbonDimension.getDataType(), (String)this.getDateOrTimeFormat()));
                this.checkAndWriteByteArray(input, dataOutputStream, logHolder, isWithoutConverter, parsedValue, value);
            }
        }
        catch (NumberFormatException e) {
            this.updateNullValue(dataOutputStream, logHolder);
        }
    }

    private void checkAndWriteByteArray(Object input, DataOutputStream dataOutputStream, BadRecordLogHolder logHolder, Boolean isWithoutConverter, String parsedValue, byte[] value) throws IOException {
        if (isWithoutConverter.booleanValue()) {
            if (this.carbonDimension.getDataType() == DataTypes.STRING && input instanceof String && ((String)input).length() > 32000) {
                logHolder.setReason(String.format("Record of column %s exceeded 32000 characters. Please consider long string data type.", this.carbonDimension.getColName()));
                this.updateNullValue(dataOutputStream, logHolder);
                return;
            }
            this.updateValueToByteStream(dataOutputStream, value);
        } else {
            if (this.carbonDimension.getDataType() == DataTypes.STRING && value.length > 32000) {
                logHolder.setReason(String.format("Record of column %s exceeded 32000 characters. Please consider long string data type.", this.carbonDimension.getColName()));
                this.updateNullValue(dataOutputStream, logHolder);
                return;
            }
            if (parsedValue.length() > 0) {
                this.updateValueToByteStream(dataOutputStream, parsedValue.getBytes(Charset.forName("UTF-8")));
            } else {
                this.updateNullValue(dataOutputStream, logHolder);
            }
        }
    }

    private String getDateOrTimeFormat() {
        if (this.carbonDimension.getDataType() == DataTypes.DATE) {
            return this.carbonDimension.getDateFormat();
        }
        if (this.carbonDimension.getDataType() == DataTypes.TIMESTAMP) {
            return this.carbonDimension.getTimestampFormat();
        }
        return null;
    }

    private byte[] writeDirectDictionary(Object input, String parsedValue, Boolean isWithoutConverter) {
        int surrogateKey = input instanceof Long ? ((DirectDictionary)this.dictionaryGenerator).generateKey((Long)input) : (input instanceof Integer ? (Integer)input : (isWithoutConverter != false ? ((Integer)this.dictionaryGenerator.getOrGenerateKey((Object)input.toString())).intValue() : ((Integer)this.dictionaryGenerator.getOrGenerateKey((Object)parsedValue)).intValue()));
        byte[] value = surrogateKey == -1 ? new byte[]{} : ByteUtil.toXorBytes((int)surrogateKey);
        return value;
    }

    private void updateValueToByteStream(DataOutputStream dataOutputStream, byte[] value) throws IOException {
        if (DataTypeUtil.isByteArrayComplexChildColumn((DataType)this.dataType)) {
            dataOutputStream.writeInt(value.length);
        } else {
            dataOutputStream.writeShort(value.length);
        }
        dataOutputStream.write(value);
    }

    private void updateNullValue(DataOutputStream dataOutputStream, BadRecordLogHolder logHolder) throws IOException {
        CarbonUtil.updateNullValueBasedOnDatatype((DataOutputStream)dataOutputStream, (DataType)this.carbonDimension.getDataType());
        String message = logHolder.getColumnMessageMap().get(this.carbonDimension.getColName());
        if (null == message) {
            message = CarbonDataProcessorUtil.prepareFailureReason(this.carbonDimension.getColName(), this.carbonDimension.getDataType());
            logHolder.getColumnMessageMap().put(this.carbonDimension.getColName(), message);
        }
        logHolder.setReason(message);
    }

    @Override
    public void parseComplexValue(ByteBuffer byteArrayInput, DataOutputStream dataOutputStream) throws IOException {
        if (!this.isDictionary) {
            int sizeOfData;
            if (DataTypeUtil.isByteArrayComplexChildColumn((DataType)this.dataType)) {
                sizeOfData = byteArrayInput.getInt();
                dataOutputStream.writeInt(sizeOfData);
            } else {
                sizeOfData = byteArrayInput.getShort();
                dataOutputStream.writeShort(sizeOfData);
            }
            byte[] bb = new byte[sizeOfData];
            byteArrayInput.get(bb, 0, sizeOfData);
            dataOutputStream.write(bb);
        } else {
            int data = byteArrayInput.getInt();
            byte[] v = ByteUtil.convertIntToBytes((int)data);
            dataOutputStream.write(v);
        }
    }

    @Override
    public int getColsCount() {
        return 1;
    }

    @Override
    public void setOutputArrayIndex(int outputArrayIndex) {
        this.outputArrayIndex = outputArrayIndex;
    }

    @Override
    public int getMaxOutputArrayIndex() {
        return this.outputArrayIndex;
    }

    @Override
    public void getColumnarDataForComplexType(List<ArrayList<byte[]>> columnsArray, ByteBuffer inputArray) {
        if (!this.isDictionary) {
            int length = DataTypeUtil.isByteArrayComplexChildColumn((DataType)this.dataType) ? inputArray.getInt() : (int)inputArray.getShort();
            byte[] key = new byte[length];
            inputArray.get(key);
            columnsArray.get(this.outputArrayIndex).add(key);
        } else {
            byte[] key = new byte[this.keySize];
            inputArray.get(key);
            columnsArray.get(this.outputArrayIndex).add(key);
        }
        ++this.dataCounter;
    }

    @Override
    public int getDataCounter() {
        return this.dataCounter;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    @Override
    public GenericDataType<Object> deepCopy() {
        PrimitiveDataType dataType = new PrimitiveDataType(this.outputArrayIndex, 0);
        dataType.carbonDimension = this.carbonDimension;
        dataType.isDictionary = this.isDictionary;
        dataType.parentName = this.parentName;
        dataType.columnId = this.columnId;
        dataType.dictionaryGenerator = this.dictionaryGenerator;
        dataType.nullFormat = this.nullFormat;
        dataType.setKeySize(this.keySize);
        dataType.setSurrogateIndex(this.index);
        dataType.name = this.name;
        dataType.dataType = this.dataType;
        return dataType;
    }

    @Override
    public void getComplexColumnInfo(List<ComplexColumnInfo> columnInfoList) {
        columnInfoList.add(new ComplexColumnInfo(ColumnType.COMPLEX_PRIMITIVE, this.dataType, this.name, !this.isDictionary));
    }

    @Override
    public int getDepth() {
        return 1;
    }
}

