/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.log4j.Logger;

public class BadRecordsLogger {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)BadRecordsLogger.class.getName());
    private static Map<String, String> badRecordEntry = new ConcurrentHashMap<String, String>(16);
    private String fileName;
    private String storePath;
    private BufferedWriter bufferedWriter;
    private DataOutputStream outStream;
    private BufferedWriter bufferedCSVWriter;
    private DataOutputStream outCSVStream;
    private String logFilePath;
    private String csvFilePath;
    private String taskKey;
    private boolean badRecordsLogRedirect;
    private boolean badRecordLoggerEnable;
    private boolean badRecordConvertNullDisable;
    private boolean isDataLoadFail;

    public BadRecordsLogger(String key, String fileName, String storePath, boolean badRecordsLogRedirect, boolean badRecordLoggerEnable, boolean badRecordConvertNullDisable, boolean isDataLoadFail) {
        this.taskKey = key;
        this.fileName = fileName;
        this.storePath = storePath;
        this.badRecordsLogRedirect = badRecordsLogRedirect;
        this.badRecordLoggerEnable = badRecordLoggerEnable;
        this.badRecordConvertNullDisable = badRecordConvertNullDisable;
        this.isDataLoadFail = isDataLoadFail;
    }

    public static String hasBadRecord(String key) {
        return badRecordEntry.get(key);
    }

    public static String removeBadRecordKey(String key) {
        return badRecordEntry.remove(key);
    }

    public void addBadRecordsToBuilder(Object[] row, String reason) throws CarbonDataLoadingException {
        badRecordEntry.put(this.taskKey, "Partially");
        if (this.badRecordsLogRedirect || this.badRecordLoggerEnable) {
            int size;
            StringBuilder logStrings = new StringBuilder();
            int count = size = row.length;
            for (int i = 0; i < size; ++i) {
                if (null == row[i]) {
                    int ch;
                    int n = ch = logStrings.length() > 0 ? (int)logStrings.charAt(logStrings.length() - 1) : 65535;
                    if (ch != 44) break;
                    logStrings = logStrings.deleteCharAt(logStrings.lastIndexOf(","));
                    break;
                }
                if ("@NU#LL$!".equals(row[i].toString())) {
                    logStrings.append("null");
                } else {
                    logStrings.append(row[i]);
                }
                if (count > 1) {
                    logStrings.append(',');
                }
                --count;
            }
            if (this.badRecordsLogRedirect) {
                this.writeBadRecordsToCSVFile(logStrings);
            }
            if (this.badRecordLoggerEnable) {
                logStrings.append("----->");
                if (null != reason) {
                    if (reason.indexOf("@NU#LL$!") > -1) {
                        logStrings.append(reason.replace("@NU#LL$!", "null"));
                    } else {
                        logStrings.append(reason);
                    }
                }
                this.writeBadRecordsToFile(logStrings);
            }
        }
    }

    private synchronized void writeBadRecordsToFile(StringBuilder logStrings) throws CarbonDataLoadingException {
        if (null == this.logFilePath) {
            this.logFilePath = this.storePath + File.separator + this.fileName + ".log" + ".inprogress";
        }
        try {
            if (null == this.bufferedWriter) {
                if (!FileFactory.isFileExist((String)this.storePath)) {
                    FileFactory.mkdirs((String)this.storePath);
                    FileFactory.createNewFile((String)this.logFilePath);
                }
                this.outStream = FileFactory.getDataOutputStream((String)this.logFilePath);
                this.bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)this.outStream, Charset.forName("UTF-8")));
            }
            this.bufferedWriter.write(logStrings.toString());
            this.bufferedWriter.newLine();
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"Bad Log Files not found");
            throw new CarbonDataLoadingException("Bad Log Files not found", e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error While writing bad record log File");
            throw new CarbonDataLoadingException("Error While writing bad record log File", e);
        }
    }

    private synchronized void writeBadRecordsToCSVFile(StringBuilder logStrings) throws CarbonDataLoadingException {
        if (null == this.csvFilePath) {
            this.csvFilePath = this.storePath + File.separator + this.fileName + ".csv" + ".inprogress";
        }
        try {
            if (null == this.bufferedCSVWriter) {
                if (!FileFactory.isFileExist((String)this.storePath)) {
                    FileFactory.mkdirs((String)this.storePath);
                    FileFactory.createNewFile((String)this.csvFilePath);
                }
                this.outCSVStream = FileFactory.getDataOutputStream((String)this.csvFilePath);
                this.bufferedCSVWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)this.outCSVStream, Charset.forName("UTF-8")));
            }
            this.bufferedCSVWriter.write(logStrings.toString());
            this.bufferedCSVWriter.newLine();
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"Bad record csv Files not found");
            throw new CarbonDataLoadingException("Bad record csv Files not found", e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error While writing bad record csv File");
            throw new CarbonDataLoadingException("Error While writing bad record csv File", e);
        }
    }

    public boolean isBadRecordConvertNullDisable() {
        return this.badRecordConvertNullDisable;
    }

    public boolean isDataLoadFail() {
        return this.isDataLoadFail;
    }

    public boolean isBadRecordLoggerEnable() {
        return this.badRecordLoggerEnable;
    }

    public boolean isBadRecordsLogRedirect() {
        return this.badRecordsLogRedirect;
    }

    public synchronized void closeStreams() {
        BadRecordsLogger.removeBadRecordKey(this.taskKey);
        CarbonUtil.closeStreams((Closeable[])new Closeable[]{this.bufferedWriter, this.outStream, this.bufferedCSVWriter, this.outCSVStream});
    }
}

