/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonThreadFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;
import org.apache.carbondata.processing.util.CarbonLoaderUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class TableProcessingOperations {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonLoaderUtil.class.getName());

    public static void deleteLocalDataLoadFolderLocation(CarbonLoadModel loadModel, boolean isCompactionFlow, boolean isAltPartitionFlow) {
        String tableName = loadModel.getTableName();
        String databaseName = loadModel.getDatabaseName();
        String tempLocationKey = CarbonDataProcessorUtil.getTempStoreLocationKey(databaseName, tableName, loadModel.getSegmentId(), loadModel.getTaskNo(), isCompactionFlow, isAltPartitionFlow);
        TableProcessingOperations.deleteLocalDataLoadFolderLocation(tempLocationKey, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteLocalDataLoadFolderLocation(String tempLocationKey, String tableName) {
        final String localStoreLocations = CarbonProperties.getInstance().getProperty(tempLocationKey);
        if (localStoreLocations == null) {
            throw new RuntimeException("Store location not set for the key " + tempLocationKey);
        }
        ExecutorService localFolderDeletionService = Executors.newFixedThreadPool(1, (ThreadFactory)new CarbonThreadFactory("LocalFolderDeletionPool:" + tableName, true));
        try {
            localFolderDeletionService.submit(new Callable<Void>(){

                @Override
                public Void call() {
                    String[] locArray;
                    long startTime = System.currentTimeMillis();
                    for (String loc : locArray = StringUtils.split((String)localStoreLocations, (String)File.pathSeparator)) {
                        try {
                            CarbonUtil.deleteFoldersAndFiles((File[])new File[]{new File(loc)});
                        }
                        catch (IOException | InterruptedException e) {
                            LOGGER.error((Object)("Failed to delete local data load folder location: " + loc), (Throwable)e);
                        }
                    }
                    LOGGER.info((Object)("Deleted the local store location: " + localStoreLocations + " : Time taken: " + (System.currentTimeMillis() - startTime)));
                    return null;
                }
            });
        }
        finally {
            CarbonProperties.getInstance().removeProperty(tempLocationKey);
            if (null != localFolderDeletionService) {
                localFolderDeletionService.shutdown();
            }
        }
    }
}

