/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.converter.impl;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.processing.datatypes.GenericDataType;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.converter.BadRecordLogHolder;
import org.apache.carbondata.processing.loading.converter.FieldConverter;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;

public class ComplexFieldConverterImpl
implements FieldConverter {
    private GenericDataType genericDataType;
    private int index;
    private DataField dataField;

    public ComplexFieldConverterImpl(DataField dataField, GenericDataType genericDataType, int index) {
        this.genericDataType = genericDataType;
        this.index = index;
        this.dataField = dataField;
    }

    @Override
    public void convert(CarbonRow row, BadRecordLogHolder logHolder) {
        Object object = row.getObject(this.index);
        row.update(this.convert(object, logHolder), this.index);
    }

    @Override
    public Object convert(Object value, BadRecordLogHolder logHolder) throws RuntimeException {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArray);
        try {
            this.genericDataType.writeByteArray(value, dataOutputStream, logHolder, false);
            dataOutputStream.close();
            return byteArray.toByteArray();
        }
        catch (Exception e) {
            throw new CarbonDataLoadingException(value + "", e);
        }
    }

    @Override
    public DataField getDataField() {
        return this.dataField;
    }

    @Override
    public void clear() {
    }
}

