/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.converter.impl;

import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.converter.BadRecordLogHolder;
import org.apache.carbondata.processing.loading.converter.FieldConverter;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;

public class NonDictionaryFieldConverterImpl
implements FieldConverter {
    private DataType dataType;
    private int index;
    private String nullFormat;
    private CarbonColumn column;
    private boolean isEmptyBadRecord;
    private DataField dataField;

    public NonDictionaryFieldConverterImpl(DataField dataField, String nullFormat, int index, boolean isEmptyBadRecord) {
        this.dataField = dataField;
        this.dataType = dataField.getColumn().getDataType();
        this.column = dataField.getColumn();
        this.index = index;
        this.nullFormat = nullFormat;
        this.isEmptyBadRecord = isEmptyBadRecord;
    }

    @Override
    public void convert(CarbonRow row, BadRecordLogHolder logHolder) {
        String dimensionValue = row.getString(this.index);
        row.update(this.convert(dimensionValue, logHolder), this.index);
    }

    @Override
    public Object convert(Object value, BadRecordLogHolder logHolder) throws RuntimeException {
        String dimensionValue = (String)value;
        if (null == dimensionValue && this.column.getDataType() != DataTypes.STRING) {
            logHolder.setReason(CarbonDataProcessorUtil.prepareFailureReason(this.column.getColName(), this.column.getDataType()));
            return this.getNullValue();
        }
        if (dimensionValue == null || dimensionValue.equals(this.nullFormat)) {
            return this.getNullValue();
        }
        String dateFormat = null;
        if (this.dataType == DataTypes.DATE) {
            dateFormat = this.dataField.getDateFormat();
        } else if (this.dataType == DataTypes.TIMESTAMP) {
            dateFormat = this.dataField.getTimestampFormat();
        }
        try {
            if (!this.dataField.isUseActualData()) {
                byte[] parsedValue = DataTypeUtil.getBytesBasedOnDataTypeForNoDictionaryColumn((String)dimensionValue, (DataType)this.dataType, (String)dateFormat);
                if (this.dataType == DataTypes.STRING && parsedValue.length > 32000) {
                    logHolder.setReason("Record of column %s exceeded 32000 characters. Please consider long string data type.");
                    return this.getNullValue();
                }
                return parsedValue;
            }
            Object parsedValue = DataTypeUtil.getDataDataTypeForNoDictionaryColumn((String)dimensionValue, (DataType)this.dataType, (String)dateFormat);
            if (this.dataType == DataTypes.STRING && parsedValue.toString().length() > 32000) {
                logHolder.setReason("Record of column %s exceeded 32000 characters. Please consider long string data type.");
                return this.getNullValue();
            }
            return parsedValue;
        }
        catch (CarbonDataLoadingException e) {
            throw e;
        }
        catch (Throwable ex) {
            if (dimensionValue.length() > 0 || dimensionValue.length() == 0 && this.isEmptyBadRecord) {
                String message = logHolder.getColumnMessageMap().get(this.column.getColName());
                if (null == message) {
                    message = CarbonDataProcessorUtil.prepareFailureReason(this.column.getColName(), this.column.getDataType());
                    logHolder.getColumnMessageMap().put(this.column.getColName(), message);
                }
                logHolder.setReason(message);
            }
            return this.getNullValue();
        }
    }

    @Override
    public DataField getDataField() {
        return this.dataField;
    }

    @Override
    public void clear() {
    }

    private byte[] getNullValue() {
        if (this.dataField.isUseActualData()) {
            return null;
        }
        if (this.dataType == DataTypes.STRING) {
            return CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY;
        }
        return CarbonCommonConstants.EMPTY_BYTE_ARRAY;
    }
}

