/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.converter.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.util.CustomIndex;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.converter.BadRecordLogHolder;
import org.apache.carbondata.processing.loading.converter.impl.MeasureFieldConverterImpl;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.log4j.Logger;

public class SpatialIndexFieldConverterImpl
extends MeasureFieldConverterImpl {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)MeasureFieldConverterImpl.class.getName());
    private int index;
    private int[] sourceIndexes;
    CustomIndex instance;

    public SpatialIndexFieldConverterImpl(DataField dataField, String nullFormat, int index, boolean isEmptyBadRecord, CarbonDataLoadConfiguration configuration) {
        super(dataField, nullFormat, index, isEmptyBadRecord);
        this.index = index;
        Map properties = configuration.getTableSpec().getCarbonTable().getTableInfo().getFactTable().getTableProperties();
        try {
            this.instance = CustomIndex.getCustomInstance((String)((String)properties.get("spatial_index." + dataField.getColumn().getColName() + ".instance")));
        }
        catch (IOException e) {
            LOGGER.error((Object)"Failed to get the custom instance", (Throwable)e);
            throw new RuntimeException(e);
        }
        String sourceColumns = (String)properties.get("spatial_index." + dataField.getColumn().getColName() + ".sourcecolumns");
        String[] sources = sourceColumns.split(",");
        this.sourceIndexes = new int[sources.length];
        int idx = 0;
        for (String source : sources) {
            this.sourceIndexes[idx++] = this.getDataFieldIndexByName(configuration.getDataFields(), source);
        }
    }

    private int getDataFieldIndexByName(DataField[] fields, String column) {
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getColumn().getColName().equalsIgnoreCase(column)) continue;
            return i;
        }
        return -1;
    }

    private String generateIndexValue(CarbonRow row) {
        ArrayList<Object> sourceValues = new ArrayList<Object>();
        for (int sourceIndex : this.sourceIndexes) {
            sourceValues.add(row.getData()[sourceIndex]);
        }
        String value = null;
        try {
            value = this.instance.generate(sourceValues);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to generate index column value", (Throwable)e);
        }
        return value;
    }

    @Override
    public void convert(CarbonRow row, BadRecordLogHolder logHolder) throws CarbonDataLoadingException {
        if (row.getData()[this.index] == null) {
            row.update((Object)this.generateIndexValue(row), this.index);
        }
        super.convert(row, logHolder);
    }
}

