/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.csvinput;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BoundedInputStream
extends InputStream {
    private static final byte END_OF_LINE_BYTE_VALUE = 10;
    private static final int NUMBER_OF_EXTRA_CHARACTER_TO_READ = 100;
    private long remaining;
    private boolean endOfLineFound = false;
    private DataInputStream in;

    public BoundedInputStream(DataInputStream in, long limit) {
        this.in = in;
        this.remaining = limit;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining == 0L) {
            return -1;
        }
        int var1 = this.in.read();
        if (var1 >= 0) {
            --this.remaining;
        }
        return var1;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.remaining == 0L) {
            return -1;
        }
        if (this.remaining < (long)length) {
            length = (int)this.remaining;
        }
        if ((length = this.in.read(buffer, offset, length)) >= 0) {
            this.remaining -= (long)length;
            if (this.remaining == 0L && !this.endOfLineFound) {
                this.endOfLineFound = true;
                this.remaining += 100L;
            } else if (this.endOfLineFound) {
                int end = offset + length;
                for (int i = offset; i < end; ++i) {
                    if (buffer[i] != 10) continue;
                    this.remaining = 0L;
                    return i - offset + 1;
                }
                this.remaining += 100L;
            }
        }
        return length;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    public long getRemaining() {
        return this.remaining;
    }
}

