/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.iterator;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.log4j.Logger;

public class CarbonOutputIteratorWrapper
extends CarbonIterator<Object[]> {
    private static final Logger LOG = LogServiceFactory.getLogService((String)CarbonOutputIteratorWrapper.class.getName());
    private boolean close;
    private int batchSize = CarbonProperties.getInstance().getBatchSize();
    private RowBatch loadBatch = new RowBatch(this.batchSize);
    private RowBatch readBatch;
    private ArrayBlockingQueue<RowBatch> queue = new ArrayBlockingQueue(10);

    public void write(Object[] row) throws InterruptedException {
        if (this.close) {
            return;
        }
        if (!this.loadBatch.addRow(row)) {
            this.loadBatch.readyRead();
            this.queue.put(this.loadBatch);
            this.loadBatch = new RowBatch(this.batchSize);
        }
    }

    public boolean hasNext() {
        if (this.readBatch == null || !this.readBatch.hasNext()) {
            this.readBatch = null;
            try {
                while (!this.close) {
                    this.readBatch = this.queue.poll(5L, TimeUnit.MINUTES);
                    if (this.readBatch != null) break;
                    LOG.warn((Object)"try to poll a row batch again.");
                }
                if (this.close && this.readBatch == null) {
                    LOG.warn((Object)"try to poll a row batch one more time.");
                    this.readBatch = this.queue.poll();
                }
                if (this.readBatch == null) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return this.readBatch.hasNext();
    }

    public Object[] next() {
        return this.readBatch.next();
    }

    public void closeWriter(boolean isForceClose) {
        if (this.close) {
            return;
        }
        try {
            if (isForceClose) {
                this.close = true;
                this.queue.clear();
                return;
            }
            this.loadBatch.readyRead();
            if (this.loadBatch.size > 0) {
                this.queue.put(this.loadBatch);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.queue.isEmpty() && !this.queue.offer(new RowBatch(0))) {
            LOG.warn((Object)"The default last element is not added to queue");
        }
        this.close = true;
    }

    private static class RowBatch
    extends CarbonIterator<Object[]> {
        private int counter;
        private Object[][] batch;
        private int size;

        private RowBatch(int size) {
            this.batch = new Object[size][];
            this.size = size;
        }

        public boolean addRow(Object[] row) {
            this.batch[this.counter++] = row;
            return this.counter < this.size;
        }

        public void readyRead() {
            this.size = this.counter;
            this.counter = 0;
        }

        public boolean hasNext() {
            return this.counter < this.size;
        }

        public Object[] next() {
            assert (this.counter < this.size);
            return this.batch[this.counter++];
        }
    }
}

