/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.statusmanager.SegmentUpdateStatusManager;
import org.apache.carbondata.core.util.DataLoadMetrics;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.processing.loading.model.CarbonDataLoadSchema;

public class CarbonLoadModel
implements Serializable {
    private static final long serialVersionUID = 6580168429197697465L;
    private String databaseName;
    private String tableName;
    private String factFilePath;
    private CarbonDataLoadSchema carbonDataLoadSchema;
    private String tablePath;
    private boolean carbonTransactionalTable = true;
    private short sdkWriterCores;
    private String csvHeader;
    private String[] csvHeaderColumns;
    private String csvDelimiter;
    private ArrayList<String> complexDelimiters;
    private List<LoadMetadataDetails> loadMetadataDetails;
    private transient SegmentUpdateStatusManager segmentUpdateStatusManager;
    private String blocksID;
    private String taskNo;
    private long factTimeStamp;
    private Segment segment;
    private String escapeChar;
    private String quoteChar;
    private String commentChar;
    private String lineSeparator;
    private String timestampFormat;
    private String dateFormat;
    private String defaultTimestampFormat;
    private String defaultDateFormat;
    private String serializationNullFormat;
    private String badRecordsLoggerEnable;
    private String badRecordsAction;
    private String maxColumns;
    private String isEmptyDataBadRecord;
    private String skipEmptyLine;
    private boolean preFetch;
    private String sortScope;
    private String badRecordsLocation;
    private String globalSortPartitions;
    private boolean isAggLoadRequest;
    private String sortColumnsBoundsStr;
    private boolean isLoadWithoutConverterStep;
    private boolean nonSchemaColumnsPresent;
    private boolean isLoadWithoutConverterWithoutReArrangeStep;
    private boolean isJsonFileLoad;
    private String dataWritePath;
    private String loadMinSize;
    private List<String> mergedSegmentIds;
    private String columnCompressor;
    private String binaryDecoder;
    private long totalSize;
    private CarbonColumn rangePartitionColumn;
    private int scaleFactor;
    private int bucketId;
    private DataLoadMetrics metrics;
    private boolean skipParsers = false;

    public void setSkipParsers() {
        this.skipParsers = true;
    }

    public boolean isSkipParsers() {
        return this.skipParsers;
    }

    public boolean isAggLoadRequest() {
        return this.isAggLoadRequest;
    }

    public void setAggLoadRequest(boolean aggLoadRequest) {
        this.isAggLoadRequest = aggLoadRequest;
    }

    public String getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(String escapeChar) {
        this.escapeChar = escapeChar;
    }

    public String getCsvDelimiter() {
        return this.csvDelimiter;
    }

    public void setCsvDelimiter(String csvDelimiter) {
        this.csvDelimiter = csvDelimiter;
    }

    public void setComplexDelimiter(String delimiter) {
        this.checkAndInitializeComplexDelimiterList();
        this.complexDelimiters.add(delimiter);
    }

    public ArrayList<String> getComplexDelimiters() {
        this.checkAndInitializeComplexDelimiterList();
        return this.complexDelimiters;
    }

    public String getCsvHeader() {
        return this.csvHeader;
    }

    public void setCsvHeader(String csvHeader) {
        this.csvHeader = csvHeader;
    }

    public String[] getCsvHeaderColumns() {
        return this.csvHeaderColumns;
    }

    public void setCsvHeaderColumns(String[] csvHeaderColumns) {
        this.csvHeaderColumns = csvHeaderColumns;
    }

    public CarbonDataLoadSchema getCarbonDataLoadSchema() {
        return this.carbonDataLoadSchema;
    }

    public void setCarbonDataLoadSchema(CarbonDataLoadSchema carbonDataLoadSchema) {
        this.carbonDataLoadSchema = carbonDataLoadSchema;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getFactFilePath() {
        return this.factFilePath;
    }

    public void setFactFilePath(String factFilePath) {
        this.factFilePath = factFilePath;
    }

    public String getSortColumnsBoundsStr() {
        return this.sortColumnsBoundsStr;
    }

    public void setSortColumnsBoundsStr(String sortColumnsBoundsStr) {
        this.sortColumnsBoundsStr = sortColumnsBoundsStr;
    }

    public String getLoadMinSize() {
        return this.loadMinSize;
    }

    public void setLoadMinSize(String loadMinSize) {
        this.loadMinSize = loadMinSize;
    }

    public int getBucketId() {
        return this.bucketId;
    }

    public void setBucketId(int bucketId) {
        this.bucketId = bucketId;
    }

    public CarbonLoadModel getCopyWithTaskNo(String taskNo) {
        CarbonLoadModel copy = new CarbonLoadModel();
        copy.tableName = this.tableName;
        copy.factFilePath = this.factFilePath;
        copy.databaseName = this.databaseName;
        copy.loadMetadataDetails = this.loadMetadataDetails;
        copy.csvHeader = this.csvHeader;
        copy.csvHeaderColumns = this.csvHeaderColumns;
        copy.csvDelimiter = this.csvDelimiter;
        copy.complexDelimiters = this.complexDelimiters;
        copy.carbonDataLoadSchema = this.carbonDataLoadSchema;
        copy.blocksID = this.blocksID;
        copy.taskNo = taskNo;
        copy.factTimeStamp = this.factTimeStamp;
        copy.segment = this.segment;
        copy.serializationNullFormat = this.serializationNullFormat;
        copy.badRecordsLoggerEnable = this.badRecordsLoggerEnable;
        copy.badRecordsAction = this.badRecordsAction;
        copy.escapeChar = this.escapeChar;
        copy.quoteChar = this.quoteChar;
        copy.lineSeparator = this.lineSeparator;
        copy.commentChar = this.commentChar;
        copy.timestampFormat = this.timestampFormat;
        copy.dateFormat = this.dateFormat;
        copy.defaultTimestampFormat = this.defaultTimestampFormat;
        copy.maxColumns = this.maxColumns;
        copy.tablePath = this.tablePath;
        copy.carbonTransactionalTable = this.carbonTransactionalTable;
        copy.preFetch = this.preFetch;
        copy.isEmptyDataBadRecord = this.isEmptyDataBadRecord;
        copy.skipEmptyLine = this.skipEmptyLine;
        copy.sortScope = this.sortScope;
        copy.isAggLoadRequest = this.isAggLoadRequest;
        copy.badRecordsLocation = this.badRecordsLocation;
        copy.isLoadWithoutConverterStep = this.isLoadWithoutConverterStep;
        copy.sortColumnsBoundsStr = this.sortColumnsBoundsStr;
        copy.loadMinSize = this.loadMinSize;
        copy.sdkWriterCores = this.sdkWriterCores;
        copy.columnCompressor = this.columnCompressor;
        copy.binaryDecoder = this.binaryDecoder;
        copy.rangePartitionColumn = this.rangePartitionColumn;
        copy.scaleFactor = this.scaleFactor;
        copy.totalSize = this.totalSize;
        copy.metrics = this.metrics;
        copy.isLoadWithoutConverterWithoutReArrangeStep = this.isLoadWithoutConverterWithoutReArrangeStep;
        return copy;
    }

    public CarbonLoadModel getCopyWithPartition(String header, String delimiter) {
        CarbonLoadModel copyObj = new CarbonLoadModel();
        copyObj.tableName = this.tableName;
        copyObj.factFilePath = null;
        copyObj.databaseName = this.databaseName;
        copyObj.loadMetadataDetails = this.loadMetadataDetails;
        copyObj.carbonDataLoadSchema = this.carbonDataLoadSchema;
        copyObj.csvHeader = header;
        copyObj.csvHeaderColumns = this.csvHeaderColumns;
        copyObj.csvDelimiter = delimiter;
        copyObj.complexDelimiters = this.complexDelimiters;
        copyObj.blocksID = this.blocksID;
        copyObj.taskNo = this.taskNo;
        copyObj.factTimeStamp = this.factTimeStamp;
        copyObj.segment = this.segment;
        copyObj.serializationNullFormat = this.serializationNullFormat;
        copyObj.badRecordsLoggerEnable = this.badRecordsLoggerEnable;
        copyObj.badRecordsAction = this.badRecordsAction;
        copyObj.escapeChar = this.escapeChar;
        copyObj.quoteChar = this.quoteChar;
        copyObj.lineSeparator = this.lineSeparator;
        copyObj.commentChar = this.commentChar;
        copyObj.timestampFormat = this.timestampFormat;
        copyObj.dateFormat = this.dateFormat;
        copyObj.defaultTimestampFormat = this.defaultTimestampFormat;
        copyObj.maxColumns = this.maxColumns;
        copyObj.tablePath = this.tablePath;
        copyObj.carbonTransactionalTable = this.carbonTransactionalTable;
        copyObj.preFetch = this.preFetch;
        copyObj.isEmptyDataBadRecord = this.isEmptyDataBadRecord;
        copyObj.skipEmptyLine = this.skipEmptyLine;
        copyObj.sortScope = this.sortScope;
        copyObj.badRecordsLocation = this.badRecordsLocation;
        copyObj.isAggLoadRequest = this.isAggLoadRequest;
        copyObj.sortColumnsBoundsStr = this.sortColumnsBoundsStr;
        copyObj.loadMinSize = this.loadMinSize;
        copyObj.sdkWriterCores = this.sdkWriterCores;
        copyObj.columnCompressor = this.columnCompressor;
        copyObj.binaryDecoder = this.binaryDecoder;
        copyObj.rangePartitionColumn = this.rangePartitionColumn;
        copyObj.scaleFactor = this.scaleFactor;
        copyObj.totalSize = this.totalSize;
        copyObj.metrics = this.metrics;
        copyObj.isLoadWithoutConverterStep = this.isLoadWithoutConverterStep;
        copyObj.isLoadWithoutConverterWithoutReArrangeStep = this.isLoadWithoutConverterWithoutReArrangeStep;
        return copyObj;
    }

    public void setTablePath(String tablePath) {
        this.tablePath = tablePath;
    }

    public String getTablePath() {
        return this.tablePath;
    }

    public List<LoadMetadataDetails> getLoadMetadataDetails() {
        return this.loadMetadataDetails;
    }

    public LoadMetadataDetails getCurrentLoadMetadataDetail() {
        if (this.loadMetadataDetails != null && this.loadMetadataDetails.size() > 0) {
            return this.loadMetadataDetails.get(this.loadMetadataDetails.size() - 1);
        }
        return null;
    }

    public void setLoadMetadataDetails(List<LoadMetadataDetails> loadMetadataDetails) {
        this.loadMetadataDetails = loadMetadataDetails;
    }

    public SegmentUpdateStatusManager getSegmentUpdateStatusManager() {
        return this.segmentUpdateStatusManager;
    }

    public void setSegmentUpdateStatusManager(SegmentUpdateStatusManager segmentUpdateStatusManager) {
        this.segmentUpdateStatusManager = segmentUpdateStatusManager;
    }

    public String getTaskNo() {
        return this.taskNo;
    }

    public void setTaskNo(String taskNo) {
        this.taskNo = taskNo;
    }

    public long getFactTimeStamp() {
        return this.factTimeStamp;
    }

    public void setFactTimeStamp(long factTimeStamp) {
        this.factTimeStamp = factTimeStamp;
    }

    private void checkAndInitializeComplexDelimiterList() {
        if (null == this.complexDelimiters) {
            this.complexDelimiters = new ArrayList();
        }
    }

    public String getSegmentId() {
        if (this.segment != null) {
            return this.segment.getSegmentNo();
        }
        return null;
    }

    public void setSegmentId(String segmentId) {
        if (segmentId != null) {
            this.segment = Segment.toSegment((String)segmentId);
        }
    }

    public Segment getSegment() {
        return this.segment;
    }

    public String getSerializationNullFormat() {
        return this.serializationNullFormat;
    }

    public void setSerializationNullFormat(String serializationNullFormat) {
        this.serializationNullFormat = serializationNullFormat;
    }

    public String getBadRecordsLoggerEnable() {
        return this.badRecordsLoggerEnable;
    }

    public void setBadRecordsLoggerEnable(String badRecordsLoggerEnable) {
        this.badRecordsLoggerEnable = badRecordsLoggerEnable;
    }

    public String getQuoteChar() {
        return this.quoteChar;
    }

    public void setQuoteChar(String quoteChar) {
        this.quoteChar = quoteChar;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public String getCommentChar() {
        return this.commentChar;
    }

    public void setCommentChar(String commentChar) {
        this.commentChar = commentChar;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDefaultTimestampFormat() {
        return this.defaultTimestampFormat;
    }

    public void setDefaultTimestampFormat(String defaultTimestampFormat) {
        this.defaultTimestampFormat = defaultTimestampFormat;
    }

    public String getMaxColumns() {
        return this.maxColumns;
    }

    public void setMaxColumns(String maxColumns) {
        this.maxColumns = maxColumns;
    }

    public String getBadRecordsAction() {
        return this.badRecordsAction;
    }

    public void setBadRecordsAction(String badRecordsAction) {
        this.badRecordsAction = badRecordsAction;
    }

    public boolean isPreFetch() {
        return this.preFetch;
    }

    public void setPreFetch(boolean preFetch) {
        this.preFetch = preFetch;
    }

    public String getDefaultDateFormat() {
        return this.defaultDateFormat;
    }

    public void setDefaultDateFormat(String defaultDateFormat) {
        this.defaultDateFormat = defaultDateFormat;
    }

    public String getIsEmptyDataBadRecord() {
        return this.isEmptyDataBadRecord;
    }

    public void setIsEmptyDataBadRecord(String isEmptyDataBadRecord) {
        this.isEmptyDataBadRecord = isEmptyDataBadRecord;
    }

    public String getSortScope() {
        return this.sortScope;
    }

    public void setSortScope(String sortScope) {
        this.sortScope = sortScope;
    }

    public String getGlobalSortPartitions() {
        return this.globalSortPartitions;
    }

    public void setGlobalSortPartitions(String globalSortPartitions) {
        this.globalSortPartitions = globalSortPartitions;
    }

    public String getBadRecordsLocation() {
        return this.badRecordsLocation;
    }

    public void setBadRecordsLocation(String badRecordsLocation) {
        this.badRecordsLocation = badRecordsLocation;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public void setTimestampFormat(String timestampFormat) {
        this.timestampFormat = timestampFormat;
    }

    public String getSkipEmptyLine() {
        return this.skipEmptyLine;
    }

    public void setSkipEmptyLine(String skipEmptyLine) {
        this.skipEmptyLine = skipEmptyLine;
    }

    public boolean isLoadWithoutConverterStep() {
        return this.isLoadWithoutConverterStep;
    }

    public void setLoadWithoutConverterStep(boolean loadWithoutConverterStep) {
        this.isLoadWithoutConverterStep = loadWithoutConverterStep;
    }

    public boolean isJsonFileLoad() {
        return this.isJsonFileLoad;
    }

    public void setJsonFileLoad(boolean isJsonFileLoad) {
        this.isJsonFileLoad = isJsonFileLoad;
    }

    public String getDataWritePath() {
        return this.dataWritePath;
    }

    public void setDataWritePath(String dataWritePath) {
        this.dataWritePath = dataWritePath;
    }

    public void readAndSetLoadMetadataDetails() {
        String metadataPath = CarbonTablePath.getMetadataPath((String)this.tablePath);
        LoadMetadataDetails[] details = SegmentStatusManager.readLoadMetadata((String)metadataPath);
        this.setLoadMetadataDetails(Arrays.asList(details));
    }

    public boolean isCarbonTransactionalTable() {
        return this.carbonTransactionalTable;
    }

    public void setCarbonTransactionalTable(boolean carbonTransactionalTable) {
        this.carbonTransactionalTable = carbonTransactionalTable;
    }

    public void setMergedSegmentIds(List<String> mergedSegmentIds) {
        this.mergedSegmentIds = mergedSegmentIds;
    }

    public List<String> getMergedSegmentIds() {
        if (null == this.mergedSegmentIds) {
            this.mergedSegmentIds = new ArrayList<String>(16);
        }
        return this.mergedSegmentIds;
    }

    public short getSdkWriterCores() {
        return this.sdkWriterCores;
    }

    public void setSdkWriterCores(short sdkWriterCores) {
        this.sdkWriterCores = sdkWriterCores;
    }

    public String getColumnCompressor() {
        return this.columnCompressor;
    }

    public void setColumnCompressor(String columnCompressor) {
        this.columnCompressor = columnCompressor;
    }

    public String getBinaryDecoder() {
        return this.binaryDecoder;
    }

    public void setBinaryDecoder(String binaryDecoder) {
        this.binaryDecoder = binaryDecoder;
    }

    public CarbonColumn getRangePartitionColumn() {
        return this.rangePartitionColumn;
    }

    public void setRangePartitionColumn(CarbonColumn rangePartitionColumn) {
        this.rangePartitionColumn = rangePartitionColumn;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public void setScaleFactor(int scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public DataLoadMetrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(DataLoadMetrics metrics) {
        this.metrics = metrics;
    }

    public boolean isLoadWithoutConverterWithoutReArrangeStep() {
        return this.isLoadWithoutConverterWithoutReArrangeStep;
    }

    public void setLoadWithoutConverterWithoutReArrangeStep(boolean loadWithoutConverterWithoutReArrangeStep) {
        this.isLoadWithoutConverterWithoutReArrangeStep = loadWithoutConverterWithoutReArrangeStep;
    }

    public boolean isNonSchemaColumnsPresent() {
        return this.nonSchemaColumnsPresent;
    }

    public void setNonSchemaColumnsPresent(boolean nonSchemaColumnsPresent) {
        this.nonSchemaColumnsPresent = nonSchemaColumnsPresent;
    }
}

