/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.Maps;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.exceptions.sql.InvalidLoadOptionException;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.constants.CarbonLoadOptionConstants;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.processing.loading.ComplexDelimitersEnum;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;
import org.apache.carbondata.processing.util.CarbonLoaderUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

@InterfaceAudience.Internal
public class LoadOption {
    private static final Logger LOG = LogServiceFactory.getLogService((String)LoadOption.class.getName());

    public static Map<String, String> fillOptionWithDefaultValue(Map<String, String> options) throws InvalidLoadOptionException {
        HashMap<String, String> optionsFinal = new HashMap<String, String>();
        optionsFinal.put("delimiter", (String)Maps.getOrDefault(options, (Object)"delimiter", (Object)","));
        optionsFinal.put("quotechar", (String)Maps.getOrDefault(options, (Object)"quotechar", (Object)"\""));
        optionsFinal.put("fileheader", (String)Maps.getOrDefault(options, (Object)"fileheader", (Object)""));
        optionsFinal.put("commentchar", (String)Maps.getOrDefault(options, (Object)"commentchar", (Object)"#"));
        String headerOption = options.get("header");
        if (headerOption != null && !headerOption.equalsIgnoreCase("true") && !headerOption.equalsIgnoreCase("false")) {
            throw new InvalidLoadOptionException("'header' option should be either 'true' or 'false'.");
        }
        optionsFinal.put("header", (String)Maps.getOrDefault(options, (Object)"header", (Object)""));
        optionsFinal.put("escapechar", CarbonLoaderUtil.getEscapeChar((String)Maps.getOrDefault(options, (Object)"escapechar", (Object)"\\")));
        optionsFinal.put("serialization_null_format", (String)Maps.getOrDefault(options, (Object)"serialization_null_format", (Object)"\\N"));
        optionsFinal.put("bad_records_logger_enable", (String)Maps.getOrDefault(options, (Object)"bad_records_logger_enable", (Object)CarbonProperties.getInstance().getProperty("carbon.options.bad.records.logger.enable", CarbonLoadOptionConstants.CARBON_OPTIONS_BAD_RECORDS_LOGGER_ENABLE_DEFAULT)));
        String badRecordActionValue = CarbonProperties.getInstance().getProperty("carbon.bad.records.action", "FAIL");
        optionsFinal.put("bad_records_action", (String)Maps.getOrDefault(options, (Object)"bad_records_action", (Object)CarbonProperties.getInstance().getProperty("carbon.options.bad.records.action", badRecordActionValue)));
        optionsFinal.put("is_empty_data_bad_record", (String)Maps.getOrDefault(options, (Object)"is_empty_data_bad_record", (Object)CarbonProperties.getInstance().getProperty("carbon.options.is.empty.data.bad.record", "false")));
        optionsFinal.put("skip_empty_line", (String)Maps.getOrDefault(options, (Object)"skip_empty_line", (Object)CarbonProperties.getInstance().getProperty("carbon.options.is.empty.data.bad.record")));
        optionsFinal.put("complex_delimiter_level_1", (String)Maps.getOrDefault(options, (Object)"complex_delimiter_level_1", (Object)CarbonProperties.getInstance().getProperty("carbon.complex.delimiter.level.1", ComplexDelimitersEnum.COMPLEX_DELIMITERS_LEVEL_1.value())));
        optionsFinal.put("complex_delimiter_level_2", (String)Maps.getOrDefault(options, (Object)"complex_delimiter_level_2", (Object)CarbonProperties.getInstance().getProperty("carbon.complex.delimiter.level.2", ComplexDelimitersEnum.COMPLEX_DELIMITERS_LEVEL_2.value())));
        optionsFinal.put("complex_delimiter_level_3", (String)Maps.getOrDefault(options, (Object)"complex_delimiter_level_3", (Object)CarbonProperties.getInstance().getProperty("carbon.complex.delimiter.level.3", ComplexDelimitersEnum.COMPLEX_DELIMITERS_LEVEL_3.value())));
        optionsFinal.put("complex_delimiter_level_4", (String)Maps.getOrDefault(options, (Object)"complex_delimiter_level_4", (Object)CarbonProperties.getInstance().getProperty("carbon.complex.delimiter.level.4", ComplexDelimitersEnum.COMPLEX_DELIMITERS_LEVEL_4.value())));
        optionsFinal.put("dateformat", (String)Maps.getOrDefault(options, (Object)"dateformat", (Object)CarbonProperties.getInstance().getProperty("carbon.options.date.format", "")));
        optionsFinal.put("timestampformat", (String)Maps.getOrDefault(options, (Object)"timestampformat", (Object)CarbonProperties.getInstance().getProperty("carbon.options.timestamp.format", "")));
        optionsFinal.put("global_sort_partitions", (String)Maps.getOrDefault(options, (Object)"global_sort_partitions", (Object)CarbonProperties.getInstance().getProperty("carbon.options.global.sort.partitions", null)));
        optionsFinal.put("maxcolumns", (String)Maps.getOrDefault(options, (Object)"maxcolumns", null));
        optionsFinal.put("sort_scope", "NO_SORT");
        optionsFinal.put("sort_column_bounds", (String)Maps.getOrDefault(options, (Object)"sort_column_bounds", (Object)""));
        optionsFinal.put("load_min_size_inmb", (String)Maps.getOrDefault(options, (Object)"load_min_size_inmb", (Object)"0"));
        optionsFinal.put("range_column", (String)Maps.getOrDefault(options, (Object)"range_column", null));
        optionsFinal.put("scale_factor", (String)Maps.getOrDefault(options, (Object)"scale_factor", null));
        return optionsFinal;
    }

    public static String[] getCsvHeaderColumns(CarbonLoadModel carbonLoadModel, Configuration hadoopConf) throws IOException {
        return LoadOption.getCsvHeaderColumns(carbonLoadModel, hadoopConf, new LinkedList<String>());
    }

    public static String[] getCsvHeaderColumns(CarbonLoadModel carbonLoadModel, Configuration hadoopConf, List<String> staticPartitionCols) throws IOException {
        int i;
        String[] csvColumns;
        String[] headers;
        String delimiter = StringUtils.isEmpty((String)carbonLoadModel.getCsvDelimiter()) ? "," : CarbonUtil.delimiterConverter((String)carbonLoadModel.getCsvDelimiter());
        String csvFile = null;
        String csvHeader = carbonLoadModel.getCsvHeader();
        if (StringUtils.isBlank((String)csvHeader)) {
            csvFile = carbonLoadModel.getFactFilePath().split(",")[0];
            csvHeader = CarbonUtil.readHeader((String)csvFile, (Configuration)hadoopConf);
            if (StringUtils.isBlank((String)csvHeader)) {
                throw new CarbonDataLoadingException("First line of the csv is not valid.");
            }
            headers = csvHeader.toLowerCase().split(delimiter);
            csvColumns = new String[headers.length];
            for (i = 0; i < csvColumns.length; ++i) {
                csvColumns[i] = headers[i].replaceAll("\"", "").trim();
            }
        } else {
            headers = csvHeader.toLowerCase().split(",");
            csvColumns = new String[headers.length];
            for (i = 0; i < csvColumns.length; ++i) {
                csvColumns[i] = headers[i].trim();
            }
        }
        if (hadoopConf != null && !CarbonDataProcessorUtil.isHeaderValid(carbonLoadModel.getTableName(), csvColumns, carbonLoadModel.getCarbonDataLoadSchema(), staticPartitionCols)) {
            if (csvFile == null) {
                LOG.error((Object)"CSV header in DDL is not proper. Column names in schema and CSV header are not the same.");
                throw new CarbonDataLoadingException("CSV header in DDL is not proper. Column names in schema and CSV header are not the same.");
            }
            LOG.error((Object)("CSV header in input file is not proper. Column names in schema and csv header are not the same. Input file : " + CarbonUtil.removeAKSK((String)csvFile)));
            throw new CarbonDataLoadingException("CSV header in input file is not proper. Column names in schema and csv header are not the same. Input file : " + CarbonUtil.removeAKSK((String)csvFile));
        }
        if (staticPartitionCols.size() > 0) {
            ArrayList<String> updatedColumns = new ArrayList<String>();
            for (i = 0; i < csvColumns.length; ++i) {
                if (staticPartitionCols.contains(csvColumns[i])) {
                    updatedColumns.add(csvColumns[i] + "1");
                    continue;
                }
                updatedColumns.add(csvColumns[i]);
            }
            updatedColumns.addAll(staticPartitionCols);
            return updatedColumns.toArray(new String[updatedColumns.size()]);
        }
        return csvColumns;
    }
}

