/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.processing.loading.parser.GenericParser;
import org.apache.carbondata.processing.loading.parser.impl.ArrayParserImpl;
import org.apache.carbondata.processing.loading.parser.impl.MapParserImpl;
import org.apache.carbondata.processing.loading.parser.impl.PrimitiveParserImpl;
import org.apache.carbondata.processing.loading.parser.impl.StructParserImpl;

public final class CarbonParserFactory {
    public static GenericParser createParser(CarbonColumn carbonColumn, ArrayList<String> complexDelimiters, String nullFormat) {
        return CarbonParserFactory.createParser(carbonColumn, complexDelimiters, nullFormat, 0);
    }

    private static GenericParser createParser(CarbonColumn carbonColumn, ArrayList<String> complexDelimiters, String nullFormat, int depth) {
        DataType dataType = carbonColumn.getDataType();
        if (DataTypes.isArrayType((DataType)dataType)) {
            List listOfChildDimensions = ((CarbonDimension)carbonColumn).getListOfChildDimensions();
            ArrayParserImpl arrayParser = new ArrayParserImpl(complexDelimiters.get(depth), nullFormat);
            for (CarbonDimension dimension : listOfChildDimensions) {
                arrayParser.addChildren(CarbonParserFactory.createParser((CarbonColumn)dimension, complexDelimiters, nullFormat, depth + 1));
            }
            return arrayParser;
        }
        if (DataTypes.isMapType((DataType)dataType)) {
            List listOfChildDimensions = ((CarbonDimension)carbonColumn).getListOfChildDimensions();
            MapParserImpl mapParser = new MapParserImpl(complexDelimiters.get(depth), nullFormat, complexDelimiters.get(depth + 1));
            for (CarbonDimension dimension : listOfChildDimensions) {
                mapParser.addChildren(CarbonParserFactory.createParser((CarbonColumn)dimension, complexDelimiters, nullFormat, depth + 1));
            }
            return mapParser;
        }
        if (DataTypes.isStructType((DataType)dataType)) {
            List dimensions = ((CarbonDimension)carbonColumn).getListOfChildDimensions();
            StructParserImpl parser = new StructParserImpl(complexDelimiters.get(depth), nullFormat);
            for (CarbonDimension dimension : dimensions) {
                parser.addChildren(CarbonParserFactory.createParser((CarbonColumn)dimension, complexDelimiters, nullFormat, depth + 1));
            }
            return parser;
        }
        return new PrimitiveParserImpl();
    }
}

