/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.parser.impl;

import java.util.regex.Pattern;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.processing.loading.complexobjects.ArrayObject;
import org.apache.carbondata.processing.loading.parser.ComplexParser;
import org.apache.carbondata.processing.loading.parser.GenericParser;
import org.apache.commons.lang.ArrayUtils;

public class ArrayParserImpl
implements ComplexParser<ArrayObject> {
    protected Pattern pattern;
    protected GenericParser child;
    protected String nullFormat;

    public ArrayParserImpl(String delimiter, String nullFormat) {
        this.pattern = Pattern.compile(CarbonUtil.delimiterConverter((String)delimiter));
        this.nullFormat = nullFormat;
    }

    @Override
    public ArrayObject parse(Object data) {
        if (data != null) {
            String value = data.toString();
            if (!(value.isEmpty() || value.equals(this.nullFormat) || value.equals("!LENGTH_ZERO_DATA_RETURN!"))) {
                Object[] split = this.pattern.split(value, -1);
                if (ArrayUtils.isNotEmpty((Object[])split)) {
                    Object[] array = new Object[split.length];
                    for (int i = 0; i < split.length; ++i) {
                        array[i] = this.child.parse(split[i]);
                    }
                    return new ArrayObject(array);
                }
            } else {
                if (value.isEmpty()) {
                    Object[] array = new Object[]{this.child.parse(value)};
                    return new ArrayObject(array);
                }
                if (value.equals("!LENGTH_ZERO_DATA_RETURN!")) {
                    Object[] array = new Object[]{};
                    return new ArrayObject(array);
                }
            }
        }
        return null;
    }

    @Override
    public ArrayObject parseRaw(Object data) {
        return new ArrayObject((Object[])data);
    }

    @Override
    public void addChildren(GenericParser parser) {
        this.child = parser;
    }
}

