/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.parser.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.carbondata.processing.loading.complexobjects.ArrayObject;
import org.apache.carbondata.processing.loading.parser.impl.ArrayParserImpl;
import org.apache.commons.lang.ArrayUtils;

public class MapParserImpl
extends ArrayParserImpl {
    private String keyValueDelimiter;

    public MapParserImpl(String delimiter, String nullFormat, String keyValueDelimiter) {
        super(delimiter, nullFormat);
        this.keyValueDelimiter = keyValueDelimiter;
    }

    @Override
    public ArrayObject parse(Object data) {
        if (data != null) {
            String value = data.toString();
            if (!(value.isEmpty() || value.equals(this.nullFormat) || value.equals("!LENGTH_ZERO_DATA_RETURN!"))) {
                Object[] split = this.pattern.split(value, -1);
                if (ArrayUtils.isNotEmpty((Object[])split)) {
                    ArrayList array = new ArrayList();
                    HashMap<Object, Object> map = new HashMap<Object, Object>();
                    for (int i = 0; i < split.length; ++i) {
                        String[] splitedKeyAndValue = ((String)split[i]).split(this.keyValueDelimiter);
                        Object currKey = splitedKeyAndValue.length > 0 ? ((String)split[i]).split(this.keyValueDelimiter)[0] : new Object();
                        map.put(currKey, split[i]);
                    }
                    for (Map.Entry entry : map.entrySet()) {
                        array.add(this.child.parse(entry.getValue()));
                    }
                    return new ArrayObject(array.toArray());
                }
            } else if (value.equals("!LENGTH_ZERO_DATA_RETURN!")) {
                Object[] array = new Object[]{};
                return new ArrayObject(array);
            }
        }
        return null;
    }

    @Override
    public ArrayObject parseRaw(Object data) {
        Object[] keyValuePairs = (Object[])data;
        Object[] objectArray = new Object[keyValuePairs.length];
        for (int i = 0; i < ((Object[])data).length; ++i) {
            objectArray[i] = this.child.parseRaw(keyValuePairs[i]);
        }
        return new ArrayObject(objectArray);
    }
}

