/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.parser.impl;

import java.util.ArrayList;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.parser.CarbonParserFactory;
import org.apache.carbondata.processing.loading.parser.GenericParser;
import org.apache.carbondata.processing.loading.parser.RowParser;

public class RangeColumnParserImpl
implements RowParser {
    private GenericParser genericParser;

    public RangeColumnParserImpl(DataField rangeField, CarbonDataLoadConfiguration configuration) {
        String[] complexDelimiters = (String[])configuration.getDataLoadProperty("COMPLEX_DELIMITERS");
        ArrayList<String> complexDelimiterList = new ArrayList<String>(complexDelimiters.length);
        for (int index = 0; index < complexDelimiters.length; ++index) {
            complexDelimiterList.add(complexDelimiters[index]);
        }
        String nullFormat = configuration.getDataLoadProperty("SERIALIZATION_NULL_FORMAT").toString();
        this.genericParser = CarbonParserFactory.createParser(rangeField.getColumn(), complexDelimiterList, nullFormat);
    }

    @Override
    public Object[] parseRow(Object[] row) {
        if (row == null || row.length < 1) {
            return new String[1];
        }
        Object[] result = new Object[]{this.genericParser.parse(row[0])};
        return result;
    }
}

