/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.parser.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.parser.CarbonParserFactory;
import org.apache.carbondata.processing.loading.parser.GenericParser;
import org.apache.carbondata.processing.loading.parser.RowParser;

public class RowParserImpl
implements RowParser {
    private GenericParser[] genericParsers;
    private int[] outputMapping;
    private int[] inputMapping;
    private int numberOfColumns;
    private boolean skipParsing;

    public RowParserImpl(DataField[] output, CarbonDataLoadConfiguration configuration) {
        int i;
        this.skipParsing = configuration.isSkipParsers();
        String[] tempComplexDelimiters = (String[])configuration.getDataLoadProperty("COMPLEX_DELIMITERS");
        ArrayList<String> complexDelimiters = new ArrayList<String>();
        for (int i2 = 0; i2 < tempComplexDelimiters.length; ++i2) {
            complexDelimiters.add(tempComplexDelimiters[i2]);
        }
        String nullFormat = configuration.getDataLoadProperty("SERIALIZATION_NULL_FORMAT").toString();
        DataField[] input = this.getInput(configuration);
        this.genericParsers = new GenericParser[input.length];
        for (i = 0; i < this.genericParsers.length; ++i) {
            this.genericParsers[i] = CarbonParserFactory.createParser(input[i].getColumn(), complexDelimiters, nullFormat);
        }
        this.outputMapping = new int[output.length];
        block2: for (i = 0; i < input.length; ++i) {
            for (int j = 0; j < output.length; ++j) {
                if (!input[i].getColumn().equals(output[j].getColumn())) continue;
                this.outputMapping[i] = j;
                continue block2;
            }
        }
    }

    public DataField[] getInput(CarbonDataLoadConfiguration configuration) {
        DataField[] fields = configuration.getDataFields();
        String[] header = configuration.getHeader();
        this.numberOfColumns = header.length;
        DataField[] input = new DataField[fields.length];
        this.inputMapping = new int[input.length];
        Map properties = configuration.getTableSpec().getCarbonTable().getTableInfo().getFactTable().getTableProperties();
        String spatialProperty = (String)properties.get("spatial_index");
        int k = 0;
        block0: for (int i = 0; i < fields.length; ++i) {
            if (spatialProperty != null && fields[i].getColumn().getColName().equalsIgnoreCase(spatialProperty.trim()) && !Arrays.asList(header).contains(spatialProperty.trim())) {
                input[k] = fields[i];
                this.inputMapping[k] = -1;
                ++k;
                continue;
            }
            for (int j = 0; j < this.numberOfColumns; ++j) {
                if (!header[j].equalsIgnoreCase(fields[i].getColumn().getColName())) continue;
                input[k] = fields[i];
                this.inputMapping[k] = j;
                ++k;
                continue block0;
            }
        }
        return input;
    }

    @Override
    public Object[] parseRow(Object[] row) {
        if (row == null) {
            return new String[this.numberOfColumns];
        }
        if (row.length == 1 && row.length != this.numberOfColumns && row[0].equals("")) {
            row = new String[this.numberOfColumns];
        } else if (row.length < this.numberOfColumns) {
            String[] temp = new String[this.numberOfColumns];
            System.arraycopy(row, 0, temp, 0, row.length);
            row = temp;
        }
        Object[] out = new Object[this.genericParsers.length];
        for (int i = 0; i < this.genericParsers.length; ++i) {
            if (this.inputMapping[i] == -1) continue;
            Object obj = row[this.inputMapping[i]];
            out[this.outputMapping[i]] = this.skipParsing ? this.genericParsers[i].parseRaw(obj) : this.genericParsers[i].parse(obj);
        }
        return out;
    }
}

