/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.parser.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.processing.loading.complexobjects.StructObject;
import org.apache.carbondata.processing.loading.parser.ComplexParser;
import org.apache.carbondata.processing.loading.parser.GenericParser;
import org.apache.commons.lang.ArrayUtils;

public class StructParserImpl
implements ComplexParser<StructObject> {
    private Pattern pattern;
    private List<GenericParser> children = new ArrayList<GenericParser>();
    private String nullFormat;

    public StructParserImpl(String delimiter, String nullFormat) {
        this.pattern = Pattern.compile(CarbonUtil.delimiterConverter((String)delimiter));
        this.nullFormat = nullFormat;
    }

    @Override
    public StructObject parse(Object data) {
        Object[] split;
        String value;
        if (data != null && !(value = data.toString()).isEmpty() && !value.equals(this.nullFormat) && ArrayUtils.isNotEmpty((Object[])(split = this.pattern.split(value, -1)))) {
            Object[] array = new Object[this.children.size()];
            for (int i = 0; i < split.length && i < array.length; ++i) {
                array[i] = this.children.get(i).parse(split[i]);
            }
            return new StructObject(array);
        }
        return null;
    }

    @Override
    public StructObject parseRaw(Object data) {
        Object[] d = (Object[])data;
        Object[] array = new Object[this.children.size()];
        for (int i = 0; i < d.length; ++i) {
            array[i] = this.children.get(i).parseRaw(d[i]);
        }
        return new StructObject(array);
    }

    @Override
    public void addChildren(GenericParser parser) {
        this.children.add(parser);
    }
}

