/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.partition.impl;

import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.processing.loading.partition.Partitioner;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.apache.spark.unsafe.types.UTF8String;

@InterfaceAudience.Internal
public class SparkHashExpressionPartitionerImpl
implements Partitioner<CarbonRow> {
    private int numberOfBuckets;
    private Hash[] hashes;

    public SparkHashExpressionPartitionerImpl(List<Integer> indexes, List<ColumnSchema> columnSchemas, int numberOfBuckets) {
        this.numberOfBuckets = numberOfBuckets;
        this.hashes = new Hash[indexes.size()];
        for (int i = 0; i < indexes.size(); ++i) {
            DataType dataType = columnSchemas.get(i).getDataType();
            this.hashes[i] = dataType == DataTypes.LONG || dataType == DataTypes.DOUBLE ? new LongHash(indexes.get(i)) : (dataType == DataTypes.SHORT || dataType == DataTypes.INT || dataType == DataTypes.FLOAT || dataType == DataTypes.BOOLEAN || dataType == DataTypes.DATE ? new IntegralHash(indexes.get(i)) : (DataTypes.isDecimal((DataType)dataType) ? new DecimalHash(indexes.get(i)) : (dataType == DataTypes.TIMESTAMP ? new TimestampHash(indexes.get(i)) : new StringHash(indexes.get(i)))));
        }
    }

    @Override
    public int getPartition(CarbonRow key) {
        int hashCode = 0;
        for (Hash hash : this.hashes) {
            hashCode += hash.getHash(key.getData());
        }
        int reminder = hashCode % this.numberOfBuckets;
        if (reminder < 0) {
            return (reminder + this.numberOfBuckets) % this.numberOfBuckets;
        }
        return reminder;
    }

    private static class StringHash
    implements Hash {
        private int index;

        private StringHash(int index) {
            this.index = index;
        }

        @Override
        public int getHash(Object[] value) {
            if (value[this.index] == null) {
                return 42;
            }
            UTF8String utf8String = UTF8String.fromBytes((byte[])((byte[])value[this.index]));
            return utf8String.hashCode();
        }
    }

    private static class DecimalHash
    implements Hash {
        private int index;

        private DecimalHash(int index) {
            this.index = index;
        }

        @Override
        public int getHash(Object[] value) {
            if (value[this.index] == null) {
                return 42;
            }
            return Double.valueOf(value[this.index].toString()).hashCode();
        }
    }

    private static class TimestampHash
    implements Hash {
        private int index;

        private TimestampHash(int index) {
            this.index = index;
        }

        @Override
        public int getHash(Object[] value) {
            if (value[this.index] == null) {
                return 42;
            }
            long timeMilSec = (Long)value[this.index];
            long timeMicSec = timeMilSec * 1000L;
            return Murmur3_x86_32.hashLong((long)timeMicSec, (int)42);
        }
    }

    private static class LongHash
    implements Hash {
        private int index;

        private LongHash(int index) {
            this.index = index;
        }

        @Override
        public int getHash(Object[] value) {
            if (value[this.index] == null) {
                return 42;
            }
            long longValue = 0L;
            longValue = value[this.index] instanceof Double ? Double.doubleToLongBits((Double)value[this.index]) : Long.parseLong(value[this.index].toString());
            return Murmur3_x86_32.hashLong((long)longValue, (int)42);
        }
    }

    private static class IntegralHash
    implements Hash {
        private int index;

        private IntegralHash(int index) {
            this.index = index;
        }

        @Override
        public int getHash(Object[] value) {
            boolean boolValue;
            if (value[this.index] == null) {
                return 42;
            }
            int intValue = 0;
            intValue = value[this.index] instanceof Boolean ? ((boolValue = ((Boolean)value[this.index]).booleanValue()) ? 1 : 0) : (value[this.index] instanceof Float ? Float.floatToIntBits(((Float)value[this.index]).floatValue()) : Integer.parseInt(value[this.index].toString()));
            return Murmur3_x86_32.hashInt((int)intValue, (int)42);
        }
    }

    private static interface Hash {
        public int getHash(Object[] var1);
    }
}

