/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.sort;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;

public class CarbonPriorityQueue<E>
extends PriorityQueue<E> {
    private transient Field queueField;
    private transient Method siftDownMethod;
    private static final long serialVersionUID = 1L;

    public CarbonPriorityQueue(int initialCapacity) {
        super(initialCapacity);
        this.init();
    }

    public CarbonPriorityQueue(int initialCapacity, Comparator<? super E> comparator) {
        super(initialCapacity, comparator);
        this.init();
    }

    private void init() {
        try {
            this.queueField = PriorityQueue.class.getDeclaredField("queue");
            this.queueField.setAccessible(true);
            this.siftDownMethod = PriorityQueue.class.getDeclaredMethod("siftDown", Integer.TYPE, Object.class);
            this.siftDownMethod.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new CarbonDataLoadingException("Reflective operation failed", e);
        }
    }

    public void siftTopDown() {
        try {
            Object topNode = ((Object[])this.queueField.get(this))[0];
            this.siftDownMethod.invoke((Object)this, 0, topNode);
        }
        catch (ReflectiveOperationException e) {
            throw new CarbonDataLoadingException("Reflective operation failed", e);
        }
    }
}

