/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.sort;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.carbondata.core.memory.CarbonUnsafe;
import org.apache.carbondata.core.memory.MemoryException;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.util.CarbonUnsafeUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.core.util.NonDictionaryUtil;
import org.apache.carbondata.core.util.ReUsableByteArrayDataOutputStream;
import org.apache.carbondata.processing.loading.row.IntermediateSortTempRow;
import org.apache.carbondata.processing.sort.SortTempRowUpdater;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;
import org.apache.carbondata.processing.sort.sortdata.TableFieldStat;

public class SortStepRowHandler
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int dictSortDimCnt = 0;
    private int dictNoSortDimCnt = 0;
    private int noDictSortDimCnt = 0;
    private int noDictNoSortDimCnt = 0;
    private int varcharDimCnt = 0;
    private int complexDimCnt = 0;
    private int measureCnt;
    private int[] dictSortDimIdx;
    private int[] dictNoSortDimIdx;
    private int[] noDictSortDimIdx;
    private int[] noDictNoSortDimIdx;
    private int[] varcharDimIdx;
    private int[] complexDimIdx;
    private int[] measureIdx;
    private DataType[] dataTypes;
    private DataType[] noDictSortDataTypes;
    private boolean[] noDictSortColMapping;
    private DataType[] noDictNoSortDataTypes;
    private boolean[] noDictNoSortColMapping;
    private SortTempRowUpdater sortTempRowUpdater;

    public SortStepRowHandler(TableFieldStat tableFieldStat) {
        int i;
        this.dictSortDimCnt = tableFieldStat.getDictSortDimCnt();
        this.dictNoSortDimCnt = tableFieldStat.getDictNoSortDimCnt();
        this.noDictSortDimCnt = tableFieldStat.getNoDictSortDimCnt();
        this.noDictNoSortDimCnt = tableFieldStat.getNoDictNoSortDimCnt();
        this.varcharDimCnt = tableFieldStat.getVarcharDimCnt();
        this.complexDimCnt = tableFieldStat.getComplexDimCnt();
        this.measureCnt = tableFieldStat.getMeasureCnt();
        this.dictSortDimIdx = tableFieldStat.getDictSortDimIdx();
        this.dictNoSortDimIdx = tableFieldStat.getDictNoSortDimIdx();
        this.noDictSortDimIdx = tableFieldStat.getNoDictSortDimIdx();
        this.noDictNoSortDimIdx = tableFieldStat.getNoDictNoSortDimIdx();
        this.varcharDimIdx = tableFieldStat.getVarcharDimIdx();
        this.complexDimIdx = tableFieldStat.getComplexDimIdx();
        this.measureIdx = tableFieldStat.getMeasureIdx();
        this.dataTypes = tableFieldStat.getMeasureDataType();
        this.noDictSortDataTypes = tableFieldStat.getNoDictSortDataType();
        this.noDictSortColMapping = new boolean[this.noDictSortDataTypes.length];
        for (i = 0; i < this.noDictSortDataTypes.length; ++i) {
            this.noDictSortColMapping[i] = DataTypeUtil.isPrimitiveColumn((DataType)this.noDictSortDataTypes[i]);
        }
        this.noDictNoSortDataTypes = tableFieldStat.getNoDictNoSortDataType();
        this.noDictNoSortColMapping = new boolean[this.noDictNoSortDataTypes.length];
        for (i = 0; i < this.noDictNoSortDataTypes.length; ++i) {
            this.noDictNoSortColMapping[i] = DataTypeUtil.isPrimitiveColumn((DataType)this.noDictNoSortDataTypes[i]);
        }
        this.sortTempRowUpdater = tableFieldStat.getSortTempRowUpdater();
    }

    public SortStepRowHandler(SortParameters sortParameters) {
        this(new TableFieldStat(sortParameters));
    }

    public Object[] convertRawRowTo3Parts(Object[] row) {
        Object[] holder = new Object[3];
        try {
            int idx;
            int[] dictDims = new int[this.dictSortDimCnt + this.dictNoSortDimCnt];
            Object[] nonDictArray = new Object[this.noDictSortDimCnt + this.noDictNoSortDimCnt + this.varcharDimCnt + this.complexDimCnt];
            Object[] measures = new Object[this.measureCnt];
            int idxAcc = 0;
            for (idx = 0; idx < this.dictSortDimCnt; ++idx) {
                dictDims[idxAcc++] = (Integer)row[this.dictSortDimIdx[idx]];
            }
            for (idx = 0; idx < this.dictNoSortDimCnt; ++idx) {
                dictDims[idxAcc++] = (Integer)row[this.dictNoSortDimIdx[idx]];
            }
            idxAcc = 0;
            for (idx = 0; idx < this.noDictSortDimCnt; ++idx) {
                nonDictArray[idxAcc++] = row[this.noDictSortDimIdx[idx]];
            }
            for (idx = 0; idx < this.noDictNoSortDimCnt; ++idx) {
                nonDictArray[idxAcc++] = row[this.noDictNoSortDimIdx[idx]];
            }
            for (idx = 0; idx < this.varcharDimCnt; ++idx) {
                nonDictArray[idxAcc++] = row[this.varcharDimIdx[idx]];
            }
            for (idx = 0; idx < this.complexDimCnt; ++idx) {
                nonDictArray[idxAcc++] = row[this.complexDimIdx[idx]];
            }
            for (idx = 0; idx < this.measureCnt; ++idx) {
                measures[idx] = row[this.measureIdx[idx]];
            }
            this.sortTempRowUpdater.updateOutputRow(holder, dictDims, nonDictArray, measures);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem while converting row to 3 parts", e);
        }
        return holder;
    }

    public Object[] convertIntermediateSortTempRowTo3Parted(IntermediateSortTempRow sortTempRow) {
        Object[] out = new Object[3];
        NonDictionaryUtil.prepareOutObj((Object[])out, (int[])sortTempRow.getDictSortDims(), (Object[])sortTempRow.getNoDictSortDims(), (Object[])sortTempRow.getMeasures());
        return out;
    }

    public IntermediateSortTempRow readWithoutNoSortFieldConvert(DataInputStream inputStream) throws IOException {
        int idx;
        int[] dictSortDims = new int[this.dictSortDimCnt];
        Object[] noDictSortDims = new Object[this.noDictSortDimCnt];
        for (idx = 0; idx < this.dictSortDimCnt; ++idx) {
            dictSortDims[idx] = inputStream.readInt();
        }
        for (idx = 0; idx < this.noDictSortDimCnt; ++idx) {
            noDictSortDims[idx] = this.getDataForNoDictSortColumn(inputStream, idx);
        }
        int len = inputStream.readInt();
        byte[] noSortDimsAndMeasures = new byte[len];
        inputStream.readFully(noSortDimsAndMeasures);
        return new IntermediateSortTempRow(dictSortDims, noDictSortDims, noSortDimsAndMeasures);
    }

    public IntermediateSortTempRow readWithNoSortFieldConvert(DataInputStream inputStream) throws IOException {
        int idx;
        int[] dictSortDims = new int[this.dictSortDimCnt + this.dictNoSortDimCnt];
        Object[] noDictSortDims = new Object[this.noDictSortDimCnt + this.noDictNoSortDimCnt + this.varcharDimCnt + this.complexDimCnt];
        for (idx = 0; idx < this.dictSortDimCnt; ++idx) {
            dictSortDims[idx] = inputStream.readInt();
        }
        for (idx = 0; idx < this.noDictSortDimCnt; ++idx) {
            noDictSortDims[idx] = this.getDataForNoDictSortColumn(inputStream, idx);
        }
        int len = inputStream.readInt();
        byte[] noSortDimsAndMeasures = new byte[len];
        inputStream.readFully(noSortDimsAndMeasures);
        Object[] measure = new Object[this.measureCnt];
        this.unpackNoSortFromBytes(noSortDimsAndMeasures, dictSortDims, noDictSortDims, measure);
        return new IntermediateSortTempRow(dictSortDims, noDictSortDims, measure);
    }

    private Object getDataForNoDictSortColumn(DataInputStream inputStream, int idx) throws IOException {
        if (this.noDictSortColMapping[idx]) {
            return this.readDataFromStream(inputStream, idx);
        }
        short len = inputStream.readShort();
        byte[] bytes = new byte[len];
        inputStream.readFully(bytes);
        return bytes;
    }

    private Object readDataFromStream(DataInputStream inputStream, int idx) throws IOException {
        DataType dataType = this.noDictSortDataTypes[idx];
        Object data = null;
        if (!inputStream.readBoolean()) {
            return null;
        }
        if (dataType == DataTypes.BOOLEAN) {
            data = inputStream.readBoolean();
        } else if (dataType == DataTypes.BYTE) {
            data = inputStream.readByte();
        } else if (dataType == DataTypes.SHORT) {
            data = inputStream.readShort();
        } else if (dataType == DataTypes.INT) {
            data = inputStream.readInt();
        } else if (dataType == DataTypes.LONG || dataType == DataTypes.TIMESTAMP) {
            data = inputStream.readLong();
        } else if (dataType == DataTypes.DOUBLE) {
            data = inputStream.readDouble();
        } else if (dataType == DataTypes.FLOAT) {
            data = Float.valueOf(inputStream.readFloat());
        } else if (dataType == DataTypes.BYTE_ARRAY || DataTypes.isDecimal((DataType)dataType)) {
            byte[] bytes = inputStream.readUTF().getBytes(Charset.forName("UTF-8"));
            data = bytes;
        }
        return data;
    }

    private void unpackNoSortFromBytes(byte[] noSortDimsAndMeasures, int[] dictDims, Object[] noDictDims, Object[] measures) {
        byte[] bytes;
        int len;
        int i;
        ByteBuffer rowBuffer = ByteBuffer.wrap(noSortDimsAndMeasures);
        for (int i2 = this.dictSortDimCnt; i2 < dictDims.length; ++i2) {
            dictDims[i2] = rowBuffer.getInt();
        }
        int noDictIndex = this.noDictSortDimCnt;
        for (i = 0; i < this.noDictNoSortDimCnt; ++i) {
            if (this.noDictNoSortColMapping[i]) {
                noDictDims[noDictIndex++] = this.getDataFromRowBuffer(this.noDictNoSortDataTypes[i], rowBuffer);
                continue;
            }
            len = rowBuffer.getShort();
            bytes = new byte[len];
            rowBuffer.get(bytes);
            noDictDims[noDictIndex++] = bytes;
        }
        for (i = 0; i < this.varcharDimCnt; ++i) {
            len = rowBuffer.getInt();
            bytes = new byte[len];
            rowBuffer.get(bytes);
            noDictDims[noDictIndex++] = bytes;
        }
        for (i = 0; i < this.complexDimCnt; ++i) {
            len = rowBuffer.getInt();
            bytes = new byte[len];
            rowBuffer.get(bytes);
            noDictDims[noDictIndex++] = bytes;
        }
        int measureCnt = measures.length;
        for (int idx = 0; idx < measureCnt; idx = (int)((short)(idx + 1))) {
            Object tmpContent;
            measures[idx] = tmpContent = this.getDataFromRowBuffer(this.dataTypes[idx], rowBuffer);
        }
    }

    private Object getDataFromRowBuffer(DataType tmpDataType, ByteBuffer rowBuffer) {
        Object tmpContent;
        if (0 == rowBuffer.get()) {
            return null;
        }
        if (DataTypes.BOOLEAN == tmpDataType) {
            tmpContent = 1 == rowBuffer.get() ? Boolean.valueOf(true) : Boolean.valueOf(false);
        } else if (DataTypes.SHORT == tmpDataType) {
            tmpContent = rowBuffer.getShort();
        } else if (DataTypes.INT == tmpDataType) {
            tmpContent = rowBuffer.getInt();
        } else if (DataTypes.LONG == tmpDataType || DataTypes.TIMESTAMP == tmpDataType) {
            tmpContent = rowBuffer.getLong();
        } else if (DataTypes.DOUBLE == tmpDataType) {
            tmpContent = rowBuffer.getDouble();
        } else if (DataTypes.FLOAT == tmpDataType) {
            tmpContent = Float.valueOf(rowBuffer.getFloat());
        } else if (DataTypes.BYTE == tmpDataType) {
            tmpContent = rowBuffer.get();
        } else if (DataTypes.isDecimal((DataType)tmpDataType)) {
            short len = rowBuffer.getShort();
            byte[] decimalBytes = new byte[len];
            rowBuffer.get(decimalBytes);
            tmpContent = DataTypeUtil.byteToBigDecimal((byte[])decimalBytes);
        } else if (DataTypes.BINARY == tmpDataType) {
            int len = rowBuffer.getInt();
            byte[] bytes = new byte[len];
            rowBuffer.get(bytes);
            tmpContent = bytes;
        } else {
            throw new IllegalArgumentException("Unsupported data type: " + tmpDataType);
        }
        return tmpContent;
    }

    public void writeIntermediateSortTempRowToOutputStream(IntermediateSortTempRow sortTempRow, DataOutputStream outputStream) throws IOException {
        int idx;
        for (idx = 0; idx < this.dictSortDimCnt; ++idx) {
            outputStream.writeInt(sortTempRow.getDictSortDims()[idx]);
        }
        for (idx = 0; idx < this.noDictSortDimCnt; ++idx) {
            if (this.noDictSortColMapping[idx]) {
                this.writeDataToStream(sortTempRow.getNoDictSortDims()[idx], outputStream, idx);
                continue;
            }
            byte[] bytes = (byte[])sortTempRow.getNoDictSortDims()[idx];
            outputStream.writeShort(bytes.length);
            outputStream.write(bytes);
        }
        outputStream.writeInt(sortTempRow.getNoSortDimsAndMeasures().length);
        outputStream.write(sortTempRow.getNoSortDimsAndMeasures());
    }

    public void writeRawRowAsIntermediateSortTempRowToOutputStream(Object[] row, DataOutputStream outputStream, ReUsableByteArrayDataOutputStream reUsableByteArrayDataOutputStream) throws IOException {
        int idx;
        for (idx = 0; idx < this.dictSortDimCnt; ++idx) {
            outputStream.writeInt((Integer)row[this.dictSortDimIdx[idx]]);
        }
        for (idx = 0; idx < this.noDictSortDimCnt; ++idx) {
            if (this.noDictSortColMapping[idx]) {
                this.writeDataToStream(row[this.noDictSortDimIdx[idx]], outputStream, idx);
                continue;
            }
            byte[] bytes = (byte[])row[this.noDictSortDimIdx[idx]];
            outputStream.writeShort(bytes.length);
            outputStream.write(bytes);
        }
        reUsableByteArrayDataOutputStream.reset();
        this.packNoSortFieldsToBytes(row, reUsableByteArrayDataOutputStream);
        int packSize = reUsableByteArrayDataOutputStream.getSize();
        outputStream.writeInt(packSize);
        outputStream.write(reUsableByteArrayDataOutputStream.getByteArray(), 0, packSize);
    }

    private void writeDataToStream(Object data, DataOutputStream outputStream, int idx) throws IOException {
        DataType dataType = this.noDictSortDataTypes[idx];
        if (null == data) {
            outputStream.writeBoolean(false);
        } else {
            outputStream.writeBoolean(true);
            if (dataType == DataTypes.BOOLEAN) {
                outputStream.writeBoolean((Boolean)data);
            } else if (dataType == DataTypes.BYTE) {
                outputStream.writeByte(((Byte)data).byteValue());
            } else if (dataType == DataTypes.SHORT) {
                outputStream.writeShort(((Short)data).shortValue());
            } else if (dataType == DataTypes.INT) {
                outputStream.writeInt((Integer)data);
            } else if (dataType == DataTypes.LONG || dataType == DataTypes.TIMESTAMP) {
                outputStream.writeLong((Long)data);
            } else if (dataType == DataTypes.DOUBLE) {
                outputStream.writeDouble((Double)data);
            } else if (DataTypes.isDecimal((DataType)dataType)) {
                BigDecimal val = (BigDecimal)data;
                byte[] bigDecimalInBytes = DataTypeUtil.bigDecimalToByte((BigDecimal)val);
                outputStream.writeShort(bigDecimalInBytes.length);
                outputStream.write(bigDecimalInBytes);
            } else if (dataType == DataTypes.FLOAT) {
                outputStream.writeFloat(((Float)data).floatValue());
            } else if (dataType == DataTypes.BYTE_ARRAY) {
                outputStream.writeUTF(data.toString());
            }
        }
    }

    public IntermediateSortTempRow readFromMemoryWithoutNoSortFieldConvert(Object baseObject, long address) {
        int idx;
        int size = 0;
        int[] dictSortDims = new int[this.dictSortDimCnt];
        byte[][] noDictSortDims = new byte[this.noDictSortDimCnt][];
        for (idx = 0; idx < dictSortDims.length; ++idx) {
            dictSortDims[idx] = CarbonUnsafe.getUnsafe().getInt(baseObject, address + (long)size);
            size += 4;
        }
        for (idx = 0; idx < noDictSortDims.length; ++idx) {
            short length = CarbonUnsafe.getUnsafe().getShort(baseObject, address + (long)size);
            byte[] bytes = new byte[length];
            CarbonUnsafe.getUnsafe().copyMemory(baseObject, address + (long)(size += 2), bytes, CarbonUnsafe.BYTE_ARRAY_OFFSET, length);
            size += length;
            noDictSortDims[idx] = bytes;
        }
        int len = CarbonUnsafe.getUnsafe().getInt(baseObject, address + (long)size);
        byte[] noSortDimsAndMeasures = new byte[len];
        CarbonUnsafe.getUnsafe().copyMemory(baseObject, address + (long)(size += 4), noSortDimsAndMeasures, CarbonUnsafe.BYTE_ARRAY_OFFSET, len);
        return new IntermediateSortTempRow(dictSortDims, (Object[])noDictSortDims, noSortDimsAndMeasures);
    }

    public IntermediateSortTempRow readRowFromMemoryWithNoSortFieldConvert(Object baseObject, long address) {
        int idx;
        int size = 0;
        int[] dictSortDims = new int[this.dictSortDimCnt + this.dictNoSortDimCnt];
        Object[] noDictSortDims = new Object[this.noDictSortDimCnt + this.noDictNoSortDimCnt + this.varcharDimCnt + this.complexDimCnt];
        for (idx = 0; idx < this.dictSortDimCnt; ++idx) {
            dictSortDims[idx] = CarbonUnsafe.getUnsafe().getInt(baseObject, address + (long)size);
            size += 4;
        }
        for (idx = 0; idx < this.noDictSortDimCnt; ++idx) {
            short length = CarbonUnsafe.getUnsafe().getShort(baseObject, address + (long)size);
            size += 2;
            if (this.noDictSortColMapping[idx]) {
                if (0 == length) {
                    noDictSortDims[idx] = null;
                    continue;
                }
                Object data = CarbonUnsafeUtil.getDataFromUnsafe((DataType)this.noDictSortDataTypes[idx], (Object)baseObject, (long)address, (int)size, (int)length);
                size += length;
                noDictSortDims[idx] = data;
                continue;
            }
            byte[] bytes = new byte[length];
            CarbonUnsafe.getUnsafe().copyMemory(baseObject, address + (long)size, bytes, CarbonUnsafe.BYTE_ARRAY_OFFSET, length);
            size += length;
            noDictSortDims[idx] = bytes;
        }
        int len = CarbonUnsafe.getUnsafe().getInt(baseObject, address + (long)size);
        byte[] noSortDimsAndMeasures = new byte[len];
        CarbonUnsafe.getUnsafe().copyMemory(baseObject, address + (long)(size += 4), noSortDimsAndMeasures, CarbonUnsafe.BYTE_ARRAY_OFFSET, len);
        Object[] measures = new Object[this.measureCnt];
        this.unpackNoSortFromBytes(noSortDimsAndMeasures, dictSortDims, noDictSortDims, measures);
        return new IntermediateSortTempRow(dictSortDims, noDictSortDims, measures);
    }

    public void writeIntermediateSortTempRowFromUnsafeMemoryToStream(Object baseObject, long address, DataOutputStream outputStream, long unsafeRemainingLength, long unsafeTotalLength) throws IOException, MemoryException {
        int idx;
        int size = 0;
        for (idx = 0; idx < this.dictSortDimCnt; ++idx) {
            outputStream.writeInt(CarbonUnsafe.getUnsafe().getInt(baseObject, address + (long)size));
            size += 4;
        }
        for (idx = 0; idx < this.noDictSortDimCnt; ++idx) {
            short length = CarbonUnsafe.getUnsafe().getShort(baseObject, address + (long)size);
            size += 2;
            if (this.noDictSortColMapping[idx]) {
                if (0 == length) {
                    this.writeDataToStream(null, outputStream, idx);
                    continue;
                }
                Object data = CarbonUnsafeUtil.getDataFromUnsafe((DataType)this.noDictSortDataTypes[idx], (Object)baseObject, (long)address, (int)size, (int)length);
                size += length;
                this.writeDataToStream(data, outputStream, idx);
                continue;
            }
            this.validateUnsafeMemoryBlockSizeLimit(unsafeRemainingLength, length, unsafeTotalLength);
            byte[] bytes = new byte[length];
            CarbonUnsafe.getUnsafe().copyMemory(baseObject, address + (long)size, bytes, CarbonUnsafe.BYTE_ARRAY_OFFSET, length);
            size += length;
            outputStream.writeShort(length);
            outputStream.write(bytes);
        }
        int len = CarbonUnsafe.getUnsafe().getInt(baseObject, address + (long)size);
        this.validateUnsafeMemoryBlockSizeLimit(unsafeRemainingLength, len, unsafeTotalLength);
        byte[] noSortDimsAndMeasures = new byte[len];
        CarbonUnsafe.getUnsafe().copyMemory(baseObject, address + (long)(size += 4), noSortDimsAndMeasures, CarbonUnsafe.BYTE_ARRAY_OFFSET, len);
        outputStream.writeInt(len);
        outputStream.write(noSortDimsAndMeasures);
    }

    public int writeRawRowAsIntermediateSortTempRowToUnsafeMemory(Object[] row, Object baseObject, long address, ReUsableByteArrayDataOutputStream reUsableByteArrayDataOutputStream, long unsafeRemainingLength, long unsafeTotalLength) throws MemoryException, IOException {
        int idx;
        int size = 0;
        for (idx = 0; idx < this.dictSortDimCnt; ++idx) {
            this.validateUnsafeMemoryBlockSizeLimit(unsafeRemainingLength, 4, unsafeTotalLength);
            CarbonUnsafe.getUnsafe().putInt(baseObject, address + (long)size, (Integer)row[this.dictSortDimIdx[idx]]);
            size += 4;
        }
        for (idx = 0; idx < this.noDictSortDimCnt; ++idx) {
            if (this.noDictSortColMapping[idx]) {
                Object data = row[this.noDictSortDimIdx[idx]];
                if (null == data) {
                    CarbonUnsafe.getUnsafe().putShort(baseObject, address + (long)size, (short)0);
                    size += 2;
                    continue;
                }
                int sizeInBytes = this.noDictSortDataTypes[idx].getSizeInBytes();
                if (this.noDictSortDataTypes[idx] == DataTypes.TIMESTAMP) {
                    sizeInBytes = DataTypes.LONG.getSizeInBytes();
                }
                CarbonUnsafe.getUnsafe().putShort(baseObject, address + (long)size, (short)sizeInBytes);
                CarbonUnsafeUtil.putDataToUnsafe((DataType)this.noDictSortDataTypes[idx], (Object)data, (Object)baseObject, (long)address, (int)(size += 2), (int)sizeInBytes);
                size += sizeInBytes;
                continue;
            }
            byte[] bytes = (byte[])row[this.noDictSortDimIdx[idx]];
            this.validateUnsafeMemoryBlockSizeLimit(unsafeRemainingLength, 2 + bytes.length, unsafeTotalLength);
            CarbonUnsafe.getUnsafe().putShort(baseObject, address + (long)size, (short)bytes.length);
            CarbonUnsafe.getUnsafe().copyMemory(bytes, CarbonUnsafe.BYTE_ARRAY_OFFSET, baseObject, address + (long)(size += 2), bytes.length);
            size += bytes.length;
        }
        reUsableByteArrayDataOutputStream.reset();
        this.packNoSortFieldsToBytes(row, reUsableByteArrayDataOutputStream);
        int packSize = reUsableByteArrayDataOutputStream.getSize();
        this.validateUnsafeMemoryBlockSizeLimit(unsafeRemainingLength, 4 + packSize, unsafeTotalLength);
        CarbonUnsafe.getUnsafe().putInt(baseObject, address + (long)size, packSize);
        CarbonUnsafe.getUnsafe().copyMemory(reUsableByteArrayDataOutputStream.getByteArray(), CarbonUnsafe.BYTE_ARRAY_OFFSET, baseObject, address + (long)(size += 4), packSize);
        return size += packSize;
    }

    private void validateUnsafeMemoryBlockSizeLimit(long unsafeRemainingLength, int requestedSize, long unsafeTotalLength) throws MemoryException {
        if (unsafeTotalLength <= (long)requestedSize) {
            throw new MemoryException("not enough unsafe memory for sort: increase the 'offheap.sort.chunk.size.inmb' ");
        }
        if (unsafeRemainingLength <= (long)requestedSize) {
            throw new MemoryException("cannot handle this row. create new page");
        }
    }

    private void packNoSortFieldsToBytes(Object[] row, ReUsableByteArrayDataOutputStream reUsableByteArrayDataOutputStream) throws IOException {
        byte[] bytes;
        int idx;
        for (idx = 0; idx < this.dictNoSortDimCnt; ++idx) {
            reUsableByteArrayDataOutputStream.writeInt(((Integer)row[this.dictNoSortDimIdx[idx]]).intValue());
        }
        for (idx = 0; idx < this.noDictNoSortDimCnt; ++idx) {
            if (this.noDictNoSortColMapping[idx]) {
                this.putDataToRowBuffer(this.noDictNoSortDataTypes[idx], row[this.noDictNoSortDimIdx[idx]], reUsableByteArrayDataOutputStream);
                continue;
            }
            bytes = (byte[])row[this.noDictNoSortDimIdx[idx]];
            reUsableByteArrayDataOutputStream.writeShort((int)((short)bytes.length));
            reUsableByteArrayDataOutputStream.write(bytes);
        }
        for (idx = 0; idx < this.varcharDimCnt; ++idx) {
            bytes = (byte[])row[this.varcharDimIdx[idx]];
            reUsableByteArrayDataOutputStream.writeInt(bytes.length);
            reUsableByteArrayDataOutputStream.write(bytes);
        }
        for (idx = 0; idx < this.complexDimCnt; ++idx) {
            bytes = (byte[])row[this.complexDimIdx[idx]];
            reUsableByteArrayDataOutputStream.writeInt(bytes.length);
            reUsableByteArrayDataOutputStream.write(bytes);
        }
        for (idx = 0; idx < this.measureCnt; ++idx) {
            this.putDataToRowBuffer(this.dataTypes[idx], row[this.measureIdx[idx]], reUsableByteArrayDataOutputStream);
        }
    }

    private void putDataToRowBuffer(DataType tmpDataType, Object tmpValue, ReUsableByteArrayDataOutputStream reUsableByteArrayDataOutputStream) throws IOException {
        if (null == tmpValue) {
            reUsableByteArrayDataOutputStream.write(0);
            return;
        }
        reUsableByteArrayDataOutputStream.write(1);
        if (DataTypes.BOOLEAN == tmpDataType) {
            if (((Boolean)tmpValue).booleanValue()) {
                reUsableByteArrayDataOutputStream.write(1);
            } else {
                reUsableByteArrayDataOutputStream.write(0);
            }
        } else if (DataTypes.SHORT == tmpDataType) {
            reUsableByteArrayDataOutputStream.writeShort((int)((Short)tmpValue).shortValue());
        } else if (DataTypes.INT == tmpDataType) {
            reUsableByteArrayDataOutputStream.writeInt(((Integer)tmpValue).intValue());
        } else if (DataTypes.LONG == tmpDataType || DataTypes.TIMESTAMP == tmpDataType) {
            reUsableByteArrayDataOutputStream.writeLong(((Long)tmpValue).longValue());
        } else if (DataTypes.DOUBLE == tmpDataType) {
            reUsableByteArrayDataOutputStream.writeDouble(((Double)tmpValue).doubleValue());
        } else if (DataTypes.FLOAT == tmpDataType) {
            reUsableByteArrayDataOutputStream.writeFloat(((Float)tmpValue).floatValue());
        } else if (DataTypes.BYTE == tmpDataType) {
            reUsableByteArrayDataOutputStream.write((int)((Byte)tmpValue).byteValue());
        } else if (DataTypes.isDecimal((DataType)tmpDataType)) {
            byte[] decimalBytes = DataTypeUtil.bigDecimalToByte((BigDecimal)((BigDecimal)tmpValue));
            reUsableByteArrayDataOutputStream.writeShort((int)((short)decimalBytes.length));
            reUsableByteArrayDataOutputStream.write(decimalBytes);
        } else if (DataTypes.BINARY == tmpDataType) {
            byte[] bytes = (byte[])tmpValue;
            reUsableByteArrayDataOutputStream.writeInt(bytes.length);
            reUsableByteArrayDataOutputStream.write(bytes);
        } else {
            throw new IllegalArgumentException("Unsupported data type: " + tmpDataType);
        }
    }
}

