/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.sort.unsafe;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.carbondata.core.memory.IntPointerBuffer;
import org.apache.carbondata.core.memory.MemoryBlock;
import org.apache.carbondata.core.memory.MemoryException;
import org.apache.carbondata.core.memory.UnsafeMemoryManager;
import org.apache.carbondata.core.memory.UnsafeSortMemoryManager;
import org.apache.carbondata.core.util.ReUsableByteArrayDataOutputStream;
import org.apache.carbondata.processing.loading.row.IntermediateSortTempRow;
import org.apache.carbondata.processing.loading.sort.SortStepRowHandler;
import org.apache.carbondata.processing.sort.SortTempRowUpdater;
import org.apache.carbondata.processing.sort.sortdata.TableFieldStat;

public class UnsafeCarbonRowPage {
    private IntPointerBuffer buffer;
    private int lastSize;
    private long sizeToBeUsed;
    private MemoryBlock dataBlock;
    private MemoryManagerType managerType;
    private String taskId;
    private TableFieldStat tableFieldStat;
    private SortStepRowHandler sortStepRowHandler;
    private boolean convertNoSortFields;
    private SortTempRowUpdater sortTempRowUpdater;
    private boolean isSaveToDisk;
    private int[] changedDataFieldOrder;

    public UnsafeCarbonRowPage(TableFieldStat tableFieldStat, MemoryBlock memoryBlock, String taskId, boolean isSaveToDisk) {
        this.tableFieldStat = tableFieldStat;
        this.sortStepRowHandler = new SortStepRowHandler(tableFieldStat);
        this.taskId = taskId;
        this.buffer = new IntPointerBuffer(this.taskId);
        this.dataBlock = memoryBlock;
        this.sizeToBeUsed = this.dataBlock.size() - this.dataBlock.size() * 5L / 100L;
        this.managerType = MemoryManagerType.UNSAFE_MEMORY_MANAGER;
        this.sortTempRowUpdater = tableFieldStat.getSortTempRowUpdater();
        this.isSaveToDisk = isSaveToDisk;
        this.changedDataFieldOrder = tableFieldStat.getChangedDataFieldOrder();
    }

    public int addRow(Object[] row, ReUsableByteArrayDataOutputStream reUsableByteArrayDataOutputStream) throws MemoryException, IOException {
        int size = this.addRow(this.getConvertedRow(row), this.dataBlock.getBaseOffset() + (long)this.lastSize, reUsableByteArrayDataOutputStream);
        this.buffer.set(this.lastSize);
        this.lastSize += size;
        return size;
    }

    private Object[] getConvertedRow(Object[] row) {
        if (this.changedDataFieldOrder != null && this.changedDataFieldOrder.length == row.length) {
            Object[] convertedRow = new Object[row.length];
            for (int i = 0; i < row.length; ++i) {
                convertedRow[i] = row[this.changedDataFieldOrder[i]];
            }
            return convertedRow;
        }
        return row;
    }

    private int addRow(Object[] row, long address, ReUsableByteArrayDataOutputStream reUsableByteArrayDataOutputStream) throws MemoryException, IOException {
        return this.sortStepRowHandler.writeRawRowAsIntermediateSortTempRowToUnsafeMemory(row, this.dataBlock.getBaseObject(), address, reUsableByteArrayDataOutputStream, this.dataBlock.size() - (long)this.lastSize, this.dataBlock.size());
    }

    public IntermediateSortTempRow getRow(long address) {
        if (this.convertNoSortFields) {
            IntermediateSortTempRow intermediateSortTempRow = this.sortStepRowHandler.readRowFromMemoryWithNoSortFieldConvert(this.dataBlock.getBaseObject(), address);
            this.sortTempRowUpdater.updateSortTempRow(intermediateSortTempRow);
            return intermediateSortTempRow;
        }
        return this.sortStepRowHandler.readFromMemoryWithoutNoSortFieldConvert(this.dataBlock.getBaseObject(), address);
    }

    public void writeRow(long address, DataOutputStream stream) throws IOException, MemoryException {
        this.sortStepRowHandler.writeIntermediateSortTempRowFromUnsafeMemoryToStream(this.dataBlock.getBaseObject(), address, stream, this.dataBlock.size() - (long)this.lastSize, this.dataBlock.size());
    }

    public void freeMemory() {
        switch (this.managerType) {
            case UNSAFE_MEMORY_MANAGER: {
                UnsafeMemoryManager.INSTANCE.freeMemory(this.taskId, this.dataBlock);
                break;
            }
            default: {
                UnsafeSortMemoryManager.INSTANCE.freeMemory(this.taskId, this.dataBlock);
                this.buffer.freeMemory();
            }
        }
    }

    public IntPointerBuffer getBuffer() {
        return this.buffer;
    }

    public int getUsedSize() {
        return this.lastSize;
    }

    public boolean canAdd() {
        return (long)this.lastSize < this.sizeToBeUsed;
    }

    public MemoryBlock getDataBlock() {
        return this.dataBlock;
    }

    public TableFieldStat getTableFieldStat() {
        return this.tableFieldStat;
    }

    public void setNewDataBlock(MemoryBlock newMemoryBlock) {
        this.dataBlock = newMemoryBlock;
        this.managerType = MemoryManagerType.UNSAFE_SORT_MEMORY_MANAGER;
    }

    public void setReadConvertedNoSortField() {
        this.convertNoSortFields = true;
    }

    public void makeCanAddFail() {
        this.lastSize = (int)this.sizeToBeUsed;
    }

    public boolean isSaveToDisk() {
        return this.isSaveToDisk;
    }

    public static enum MemoryManagerType {
        UNSAFE_MEMORY_MANAGER,
        UNSAFE_SORT_MEMORY_MANAGER;

    }
}

