/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.sort.unsafe;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.memory.CarbonUnsafe;
import org.apache.carbondata.core.memory.IntPointerBuffer;
import org.apache.carbondata.core.memory.MemoryBlock;
import org.apache.carbondata.core.memory.MemoryException;
import org.apache.carbondata.core.memory.UnsafeMemoryManager;
import org.apache.carbondata.core.memory.UnsafeSortMemoryManager;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.ReUsableByteArrayDataOutputStream;
import org.apache.carbondata.core.util.ThreadLocalTaskInfo;
import org.apache.carbondata.processing.loading.sort.unsafe.UnsafeCarbonRowPage;
import org.apache.carbondata.processing.loading.sort.unsafe.comparator.UnsafeRowComparator;
import org.apache.carbondata.processing.loading.sort.unsafe.comparator.UnsafeRowComparatorForNormalDims;
import org.apache.carbondata.processing.loading.sort.unsafe.holder.UnsafeCarbonRow;
import org.apache.carbondata.processing.loading.sort.unsafe.merger.UnsafeIntermediateMerger;
import org.apache.carbondata.processing.loading.sort.unsafe.sort.TimSort;
import org.apache.carbondata.processing.loading.sort.unsafe.sort.UnsafeIntSortDataFormat;
import org.apache.carbondata.processing.sort.exception.CarbonSortKeyAndGroupByException;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;
import org.apache.carbondata.processing.sort.sortdata.TableFieldStat;
import org.apache.log4j.Logger;

public class UnsafeSortDataRows {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)UnsafeSortDataRows.class.getName());
    private ThreadStatusObserver threadStatusObserver;
    private SortParameters parameters;
    private TableFieldStat tableFieldStat;
    private ThreadLocal<ReUsableByteArrayDataOutputStream> reUsableByteArrayDataOutputStream;
    private UnsafeIntermediateMerger unsafeInMemoryIntermediateFileMerger;
    private UnsafeCarbonRowPage rowPage;
    private long inMemoryChunkSize;
    private final String taskId;
    private int instanceId;

    public UnsafeSortDataRows(SortParameters parameters, UnsafeIntermediateMerger unsafeInMemoryIntermediateFileMerger, int inMemoryChunkSize) {
        this.parameters = parameters;
        this.tableFieldStat = new TableFieldStat(parameters);
        this.reUsableByteArrayDataOutputStream = new ThreadLocal<ReUsableByteArrayDataOutputStream>(){

            @Override
            protected ReUsableByteArrayDataOutputStream initialValue() {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                return new ReUsableByteArrayDataOutputStream(byteStream);
            }
        };
        this.unsafeInMemoryIntermediateFileMerger = unsafeInMemoryIntermediateFileMerger;
        this.threadStatusObserver = new ThreadStatusObserver();
        this.taskId = ThreadLocalTaskInfo.getCarbonTaskInfo().getTaskId();
        this.inMemoryChunkSize = (long)inMemoryChunkSize * 1024L * 1024L;
    }

    public void setInstanceId(int instanceId) {
        this.instanceId = instanceId;
    }

    public void initialize() {
        MemoryBlock baseBlock = UnsafeMemoryManager.allocateMemoryWithRetry((String)this.taskId, (long)this.inMemoryChunkSize);
        boolean isMemoryAvailable = UnsafeSortMemoryManager.INSTANCE.isMemoryAvailable(baseBlock.size());
        this.rowPage = new UnsafeCarbonRowPage(this.tableFieldStat, baseBlock, this.taskId, isMemoryAvailable);
    }

    private UnsafeCarbonRowPage createUnsafeRowPage() {
        MemoryBlock baseBlock = UnsafeMemoryManager.allocateMemoryWithRetry((String)this.taskId, (long)this.inMemoryChunkSize);
        boolean isSaveToDisk = UnsafeSortMemoryManager.INSTANCE.isMemoryAvailable(baseBlock.size());
        if (!isSaveToDisk) {
            this.unsafeInMemoryIntermediateFileMerger.tryTriggerInMemoryMerging(true);
        }
        return new UnsafeCarbonRowPage(this.tableFieldStat, baseBlock, this.taskId, true);
    }

    public void addRowBatch(Object[][] rowBatch, int size) throws CarbonSortKeyAndGroupByException {
        if (this.rowPage == null) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            try {
                if (!this.rowPage.canAdd()) {
                    this.handlePreviousPage();
                    try {
                        this.rowPage = this.createUnsafeRowPage();
                    }
                    catch (Exception ex) {
                        this.rowPage = null;
                        LOGGER.error((Object)("exception occurred while trying to acquire a semaphore lock: " + ex.getMessage()), (Throwable)ex);
                        throw new CarbonSortKeyAndGroupByException(ex);
                    }
                }
                this.rowPage.addRow(rowBatch[i], this.reUsableByteArrayDataOutputStream.get());
                continue;
            }
            catch (Exception e) {
                if (e.getMessage().contains("cannot handle this row. create new page")) {
                    this.rowPage.makeCanAddFail();
                    --i;
                    continue;
                }
                LOGGER.error((Object)("exception occurred while trying to acquire a semaphore lock: " + e.getMessage()), (Throwable)e);
                throw new CarbonSortKeyAndGroupByException(e);
            }
        }
    }

    public void addRow(Object[] row) throws CarbonSortKeyAndGroupByException {
        if (this.rowPage == null) {
            return;
        }
        try {
            if (!this.rowPage.canAdd()) {
                this.handlePreviousPage();
                try {
                    this.rowPage = this.createUnsafeRowPage();
                }
                catch (Exception ex) {
                    this.rowPage = null;
                    LOGGER.error((Object)("exception occurred while trying to acquire a semaphore lock: " + ex.getMessage()), (Throwable)ex);
                    throw new CarbonSortKeyAndGroupByException(ex);
                }
            }
            this.rowPage.addRow(row, this.reUsableByteArrayDataOutputStream.get());
        }
        catch (Exception e) {
            if (e.getMessage().contains("cannot handle this row. create new page")) {
                this.rowPage.makeCanAddFail();
                this.addRow(row);
            }
            LOGGER.error((Object)("exception occurred while trying to acquire a semaphore lock: " + e.getMessage()), (Throwable)e);
            throw new CarbonSortKeyAndGroupByException(e);
        }
    }

    public void startSorting() {
        LOGGER.info((Object)"Unsafe based sorting will be used");
        if (this.rowPage.getUsedSize() > 0) {
            TimSort<UnsafeCarbonRow, IntPointerBuffer> timSort = new TimSort<UnsafeCarbonRow, IntPointerBuffer>(new UnsafeIntSortDataFormat(this.rowPage));
            if (this.parameters.getNumberOfNoDictSortColumns() > 0) {
                timSort.sort(this.rowPage.getBuffer(), 0, this.rowPage.getBuffer().getActualSize(), new UnsafeRowComparator(this.rowPage));
            } else {
                timSort.sort(this.rowPage.getBuffer(), 0, this.rowPage.getBuffer().getActualSize(), new UnsafeRowComparatorForNormalDims(this.rowPage));
            }
            this.unsafeInMemoryIntermediateFileMerger.addDataChunkToMerge(this.rowPage);
        } else {
            this.rowPage.freeMemory();
        }
    }

    private void writeDataToFile(UnsafeCarbonRowPage rowPage, File file) throws CarbonSortKeyAndGroupByException {
        DataOutputStream stream = null;
        try {
            stream = FileFactory.getDataOutputStream((String)file.getPath(), (int)this.parameters.getFileWriteBufferSize(), (String)this.parameters.getSortTempCompressorName());
            int actualSize = rowPage.getBuffer().getActualSize();
            stream.writeInt(actualSize);
            for (int i = 0; i < actualSize; ++i) {
                rowPage.writeRow((long)rowPage.getBuffer().get(i) + rowPage.getDataBlock().getBaseOffset(), stream);
            }
        }
        catch (IOException | MemoryException e) {
            try {
                throw new CarbonSortKeyAndGroupByException("Problem while writing the file", e);
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams((Closeable[])new Closeable[]{stream});
                throw throwable;
            }
        }
        CarbonUtil.closeStreams((Closeable[])new Closeable[]{stream});
    }

    private void handlePreviousPage() {
        try {
            long startTime = System.currentTimeMillis();
            TimSort<UnsafeCarbonRow, IntPointerBuffer> timSort = new TimSort<UnsafeCarbonRow, IntPointerBuffer>(new UnsafeIntSortDataFormat(this.rowPage));
            if (this.parameters.getNumberOfNoDictSortColumns() > 0) {
                timSort.sort(this.rowPage.getBuffer(), 0, this.rowPage.getBuffer().getActualSize(), new UnsafeRowComparator(this.rowPage));
            } else {
                timSort.sort(this.rowPage.getBuffer(), 0, this.rowPage.getBuffer().getActualSize(), new UnsafeRowComparatorForNormalDims(this.rowPage));
            }
            MemoryBlock sortStorageMemoryBlock = null;
            if (!this.rowPage.isSaveToDisk()) {
                sortStorageMemoryBlock = UnsafeSortMemoryManager.INSTANCE.allocateMemory(this.taskId, this.rowPage.getDataBlock().size());
            }
            if (null == sortStorageMemoryBlock || this.rowPage.isSaveToDisk()) {
                String tmpDir = this.parameters.getTempFileLocation()[new Random().nextInt(this.parameters.getTempFileLocation().length)];
                File sortTempFile = new File(tmpDir + File.separator + this.parameters.getTableName() + '_' + this.parameters.getRangeId() + '_' + this.instanceId + '_' + System.nanoTime() + ".sorttemp");
                this.writeDataToFile(this.rowPage, sortTempFile);
                LOGGER.info((Object)("Time taken to sort row page with size" + this.rowPage.getBuffer().getActualSize() + " and write is: " + (System.currentTimeMillis() - startTime) + ": location:" + sortTempFile + ", sort temp file size in MB is " + (double)sortTempFile.length() * 0.1 * 10.0 / 1024.0 / 1024.0));
                this.rowPage.freeMemory();
                this.unsafeInMemoryIntermediateFileMerger.addFileToMerge(sortTempFile);
            } else {
                CarbonUnsafe.getUnsafe().copyMemory(this.rowPage.getDataBlock().getBaseObject(), this.rowPage.getDataBlock().getBaseOffset(), sortStorageMemoryBlock.getBaseObject(), sortStorageMemoryBlock.getBaseOffset(), this.rowPage.getDataBlock().size());
                this.rowPage.freeMemory();
                this.rowPage.setNewDataBlock(sortStorageMemoryBlock);
                this.rowPage.getBuffer().loadToUnsafe();
                this.unsafeInMemoryIntermediateFileMerger.addDataChunkToMerge(this.rowPage);
                LOGGER.info((Object)("Time taken to sort row page with size: " + this.rowPage.getBuffer().getActualSize() + " is: " + (System.currentTimeMillis() - startTime)));
            }
        }
        catch (Throwable e) {
            try {
                this.threadStatusObserver.notifyFailed(e);
            }
            catch (CarbonSortKeyAndGroupByException ex) {
                LOGGER.error((Object)e.getMessage(), e);
            }
        }
    }

    private class ThreadStatusObserver {
        private ThreadStatusObserver() {
        }

        public void notifyFailed(Throwable exception) throws CarbonSortKeyAndGroupByException {
            UnsafeSortDataRows.this.unsafeInMemoryIntermediateFileMerger.close();
            UnsafeSortDataRows.this.parameters.getObserver().setFailed(true);
            LOGGER.error((Object)exception);
            throw new CarbonSortKeyAndGroupByException(exception);
        }
    }
}

