/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.sort.unsafe.comparator;

import java.util.Comparator;
import org.apache.carbondata.core.memory.CarbonUnsafe;
import org.apache.carbondata.processing.loading.sort.unsafe.UnsafeCarbonRowPage;
import org.apache.carbondata.processing.loading.sort.unsafe.holder.UnsafeCarbonRow;

public class UnsafeRowComparatorForNormalDims
implements Comparator<UnsafeCarbonRow> {
    private Object baseObject;
    private int numberOfSortColumns;

    public UnsafeRowComparatorForNormalDims(UnsafeCarbonRowPage rowPage) {
        this.baseObject = rowPage.getDataBlock().getBaseObject();
        this.numberOfSortColumns = rowPage.getTableFieldStat().getIsSortColNoDictFlags().length;
    }

    @Override
    public int compare(UnsafeCarbonRow rowL, UnsafeCarbonRow rowR) {
        int diff = 0;
        long rowA = rowL.address;
        long rowB = rowR.address;
        int sizeA = 0;
        int sizeB = 0;
        for (int i = 0; i < this.numberOfSortColumns; ++i) {
            int dimFieldA = CarbonUnsafe.getUnsafe().getInt(this.baseObject, rowA + (long)sizeA);
            sizeA += 4;
            int dimFieldB = CarbonUnsafe.getUnsafe().getInt(this.baseObject, rowB + (long)sizeB);
            sizeB += 4;
            diff = dimFieldA - dimFieldB;
            if (diff == 0) continue;
            return diff;
        }
        return diff;
    }
}

