/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.sort.unsafe.holder;

import java.util.Comparator;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.processing.loading.row.IntermediateSortTempRow;
import org.apache.carbondata.processing.loading.sort.unsafe.UnsafeCarbonRowPage;
import org.apache.carbondata.processing.loading.sort.unsafe.holder.SortTempChunkHolder;
import org.apache.carbondata.processing.sort.sortdata.FileMergeSortComparator;
import org.apache.log4j.Logger;

public class UnsafeInmemoryHolder
implements SortTempChunkHolder {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)UnsafeInmemoryHolder.class.getName());
    private int counter;
    private int actualSize;
    private UnsafeCarbonRowPage rowPage;
    private IntermediateSortTempRow currentRow;
    private long address;
    private Comparator<IntermediateSortTempRow> comparator;

    public UnsafeInmemoryHolder(UnsafeCarbonRowPage rowPage) {
        this.actualSize = rowPage.getBuffer().getActualSize();
        this.rowPage = rowPage;
        LOGGER.info((Object)("Processing unsafe inmemory rows page with size : " + this.actualSize));
        this.comparator = new FileMergeSortComparator(rowPage.getTableFieldStat().getNoDictSchemaDataType(), rowPage.getTableFieldStat().getNoDictSortColumnSchemaOrderMapping(), rowPage.getTableFieldStat().getNoDictSortColIdxSchemaOrderMapping(), rowPage.getTableFieldStat().getDictSortColIdxSchemaOrderMapping());
        this.rowPage.setReadConvertedNoSortField();
    }

    @Override
    public boolean hasNext() {
        return this.counter < this.actualSize;
    }

    @Override
    public void readRow() {
        this.address = this.rowPage.getBuffer().get(this.counter);
        this.currentRow = this.rowPage.getRow(this.address + this.rowPage.getDataBlock().getBaseOffset());
        ++this.counter;
    }

    @Override
    public IntermediateSortTempRow getRow() {
        return this.currentRow;
    }

    @Override
    public int compareTo(SortTempChunkHolder o) {
        return this.comparator.compare(this.currentRow, o.getRow());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UnsafeInmemoryHolder)) {
            return false;
        }
        UnsafeInmemoryHolder o = (UnsafeInmemoryHolder)obj;
        return this == o;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public int numberOfRows() {
        return this.actualSize;
    }

    @Override
    public void close() {
        this.rowPage.freeMemory();
    }
}

