/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.sort.unsafe.merger;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.Callable;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.processing.loading.row.IntermediateSortTempRow;
import org.apache.carbondata.processing.loading.sort.CarbonPriorityQueue;
import org.apache.carbondata.processing.loading.sort.SortStepRowHandler;
import org.apache.carbondata.processing.loading.sort.unsafe.UnsafeCarbonRowPage;
import org.apache.carbondata.processing.loading.sort.unsafe.holder.UnsafeCarbonRowForMerge;
import org.apache.carbondata.processing.loading.sort.unsafe.holder.UnsafeInmemoryMergeHolder;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;
import org.apache.log4j.Logger;

public class UnsafeInMemoryIntermediateDataMerger
implements Callable<Void> {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)UnsafeInMemoryIntermediateDataMerger.class.getName());
    private CarbonPriorityQueue<UnsafeInmemoryMergeHolder> recordHolderHeap;
    private int holderCounter;
    private int entryCount;
    private UnsafeCarbonRowPage[] unsafeCarbonRowPages;
    private long[] mergedAddresses;
    private byte[] rowPageIndexes;
    private int totalSize;
    private SortParameters sortParameters;
    private SortStepRowHandler sortStepRowHandler;
    private boolean spillDisk;
    private File outputFile;
    private DataOutputStream outputStream;

    public UnsafeInMemoryIntermediateDataMerger(UnsafeCarbonRowPage[] unsafeCarbonRowPages, int totalSize, SortParameters sortParameters, boolean spillDisk) {
        this.holderCounter = unsafeCarbonRowPages.length;
        this.unsafeCarbonRowPages = unsafeCarbonRowPages;
        this.mergedAddresses = new long[totalSize];
        this.rowPageIndexes = new byte[totalSize];
        this.entryCount = 0;
        this.totalSize = totalSize;
        this.sortParameters = sortParameters;
        this.sortStepRowHandler = new SortStepRowHandler(sortParameters);
        this.spillDisk = spillDisk;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Void call() throws Exception {
        long intermediateMergeStartTime = System.currentTimeMillis();
        int holderCounterConst = this.holderCounter;
        try {
            this.startSorting();
            if (this.spillDisk) {
                this.initSortTempFile();
                while (this.hasNext()) {
                    this.writeDataToFile(this.next());
                }
            } else {
                while (this.hasNext()) {
                    this.writeDataToMemory(this.next());
                }
            }
            double intermediateMergeCostTime = (double)(System.currentTimeMillis() - intermediateMergeStartTime) / 1000.0;
            LOGGER.info((Object)("Intermediate Merge of " + holderCounterConst + " in-memory sort Cost Time: " + intermediateMergeCostTime + "(s)"));
            if (this.spillDisk) {
                LOGGER.info((Object)("Merge and spill in-memory pages to disk, location: " + this.outputFile.getAbsolutePath() + ", file size in MB: " + (double)this.outputFile.length() * 0.1 * 10.0 / 1024.0 / 1024.0 + ", containing rows: " + this.totalSize));
            }
            if (!this.spillDisk) return null;
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)"Problem while intermediate merging", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                if (!this.spillDisk) throw throwable;
                CarbonUtil.closeStreams((Closeable[])new Closeable[]{this.outputStream});
                this.close();
                throw throwable;
            }
        }
        CarbonUtil.closeStreams((Closeable[])new Closeable[]{this.outputStream});
        this.close();
        return null;
    }

    private UnsafeCarbonRowForMerge getSortedRecordFromMemory() {
        UnsafeCarbonRowForMerge row = null;
        UnsafeInmemoryMergeHolder poll = (UnsafeInmemoryMergeHolder)this.recordHolderHeap.peek();
        row = poll.getRow();
        if (!poll.hasNext()) {
            this.recordHolderHeap.poll();
            --this.holderCounter;
            return row;
        }
        poll.readRow();
        this.recordHolderHeap.siftTopDown();
        return row;
    }

    private void startSorting() {
        LOGGER.info((Object)("Number of row pages in intermediate merger: " + this.holderCounter));
        this.createRecordHolderQueue(this.unsafeCarbonRowPages);
        LOGGER.info((Object)"Started adding first record from row page");
        UnsafeInmemoryMergeHolder unsafePageHolder = null;
        byte index = 0;
        for (UnsafeCarbonRowPage unsafeCarbonRowPage : this.unsafeCarbonRowPages) {
            byte by = index;
            index = (byte)(index + 1);
            unsafePageHolder = new UnsafeInmemoryMergeHolder(unsafeCarbonRowPage, by);
            unsafePageHolder.readRow();
            this.recordHolderHeap.add(unsafePageHolder);
        }
        LOGGER.info((Object)("Heap Size" + this.recordHolderHeap.size()));
    }

    private void createRecordHolderQueue(UnsafeCarbonRowPage[] pages) {
        this.recordHolderHeap = new CarbonPriorityQueue(pages.length);
    }

    private UnsafeCarbonRowForMerge next() {
        if (this.hasNext()) {
            return this.getSortedRecordFromMemory();
        }
        throw new NoSuchElementException("No more elements to return");
    }

    private boolean hasNext() {
        return this.holderCounter > 0;
    }

    private void writeDataToMemory(UnsafeCarbonRowForMerge row) {
        this.mergedAddresses[this.entryCount] = row.address;
        this.rowPageIndexes[this.entryCount] = row.index;
        ++this.entryCount;
    }

    private void initSortTempFile() throws IOException {
        String tmpDir = this.sortParameters.getTempFileLocation()[new Random().nextInt(this.sortParameters.getTempFileLocation().length)];
        this.outputFile = new File(tmpDir + File.separator + this.sortParameters.getTableName() + '_' + this.sortParameters.getRangeId() + '_' + System.nanoTime() + ".sorttemp");
        this.outputStream = FileFactory.getDataOutputStream((String)this.outputFile.getPath(), (int)this.sortParameters.getFileWriteBufferSize(), (String)this.sortParameters.getSortTempCompressorName());
        this.outputStream.writeInt(this.totalSize);
    }

    private void writeDataToFile(UnsafeCarbonRowForMerge row) throws IOException {
        IntermediateSortTempRow sortTempRow = this.unsafeCarbonRowPages[row.index].getRow(row.address);
        this.sortStepRowHandler.writeIntermediateSortTempRowToOutputStream(sortTempRow, this.outputStream);
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public UnsafeCarbonRowPage[] getUnsafeCarbonRowPages() {
        return this.unsafeCarbonRowPages;
    }

    public long[] getMergedAddresses() {
        return this.mergedAddresses;
    }

    public byte[] getRowPageIndexes() {
        return this.rowPageIndexes;
    }

    public boolean isSpillDisk() {
        return this.spillDisk;
    }

    public void close() {
        for (UnsafeCarbonRowPage rowPage : this.unsafeCarbonRowPages) {
            rowPage.freeMemory();
        }
    }
}

