/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.merger;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.Strings;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.datastore.block.TaskBlockInfo;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.indexstore.BlockletDetailInfo;
import org.apache.carbondata.core.indexstore.blockletindex.SegmentIndexFileStore;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.blocklet.DataFileFooter;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.scan.executor.util.QueryUtil;
import org.apache.carbondata.core.scan.executor.util.RestructureUtil;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.LiteralExpression;
import org.apache.carbondata.core.scan.expression.conditional.EqualToExpression;
import org.apache.carbondata.core.scan.expression.conditional.GreaterThanExpression;
import org.apache.carbondata.core.scan.expression.conditional.LessThanEqualToExpression;
import org.apache.carbondata.core.scan.expression.logical.AndExpression;
import org.apache.carbondata.core.scan.expression.logical.OrExpression;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.format.ColumnSchema;
import org.apache.carbondata.format.IndexHeader;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.processing.merger.CompactionType;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class CarbonCompactionUtil {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonCompactionUtil.class.getName());
    public static final String UNSORTED_IDX = "UNSORTED_IDX";
    public static final String SORTED_IDX = "SORTED_IDX";

    public static Map<String, TaskBlockInfo> createMappingForSegments(List<TableBlockInfo> tableBlockInfoList) {
        HashMap<String, TaskBlockInfo> segmentBlockInfoMapping = new HashMap<String, TaskBlockInfo>(16);
        for (TableBlockInfo info : tableBlockInfoList) {
            String segId = info.getSegmentId();
            TaskBlockInfo taskBlockInfoMapping = (TaskBlockInfo)segmentBlockInfoMapping.get(segId);
            String taskNo = CarbonTablePath.DataFileUtil.getTaskNo((String)info.getFilePath());
            if (null == taskBlockInfoMapping) {
                taskBlockInfoMapping = new TaskBlockInfo();
                CarbonCompactionUtil.groupCorrespodingInfoBasedOnTask(info, taskBlockInfoMapping, taskNo);
                segmentBlockInfoMapping.put(segId, taskBlockInfoMapping);
                continue;
            }
            CarbonCompactionUtil.groupCorrespodingInfoBasedOnTask(info, taskBlockInfoMapping, taskNo);
        }
        return segmentBlockInfoMapping;
    }

    private static void groupCorrespodingInfoBasedOnTask(TableBlockInfo info, TaskBlockInfo taskBlockMapping, String taskNo) {
        ArrayList<TableBlockInfo> blockLists = taskBlockMapping.getTableBlockInfoList(taskNo);
        if (null != blockLists) {
            blockLists.add(info);
        } else {
            blockLists = new ArrayList<TableBlockInfo>(16);
            blockLists.add(info);
            taskBlockMapping.addTableBlockInfoList(taskNo, blockLists);
        }
    }

    public static Map<String, List<DataFileFooter>> createDataFileFooterMappingForSegments(List<TableBlockInfo> tableBlockInfoList, boolean isSortedTable) throws IOException {
        HashMap<String, List<DataFileFooter>> segmentBlockInfoMapping = new HashMap<String, List<DataFileFooter>>();
        for (TableBlockInfo blockInfo : tableBlockInfoList) {
            ArrayList<DataFileFooter> eachSegmentBlocks = new ArrayList<DataFileFooter>();
            String segId = blockInfo.getSegmentId();
            DataFileFooter dataFileMatadata = null;
            List metadataList = (List)segmentBlockInfoMapping.get(segId);
            BlockletDetailInfo blockletDetailInfo = blockInfo.getDetailInfo();
            if (null == blockletDetailInfo || blockletDetailInfo.getBlockletInfo() == null || blockInfo.getDetailInfo().getSchemaUpdatedTimeStamp() == 0L || null == blockletDetailInfo.getBlockletInfo().isSorted() || !blockletDetailInfo.getBlockletInfo().isSorted().booleanValue()) {
                dataFileMatadata = CarbonUtil.readMetadataFile((TableBlockInfo)blockInfo, (boolean)true);
                if (blockletDetailInfo == null) {
                    blockletDetailInfo = QueryUtil.getBlockletDetailInfo((DataFileFooter)dataFileMatadata, (TableBlockInfo)blockInfo);
                    blockInfo.setDetailInfo(blockletDetailInfo);
                }
                if (null == dataFileMatadata.isSorted()) {
                    dataFileMatadata.setSorted(Boolean.valueOf(isSortedTable));
                }
            } else {
                dataFileMatadata = CarbonUtil.readMetadataFile((TableBlockInfo)blockInfo);
            }
            blockInfo.setDataFileFooter(dataFileMatadata);
            if (null == metadataList) {
                eachSegmentBlocks.add(dataFileMatadata);
                segmentBlockInfoMapping.put(segId, eachSegmentBlocks);
                continue;
            }
            metadataList.add(dataFileMatadata);
        }
        return segmentBlockInfoMapping;
    }

    public static boolean isCompactionRequiredForTable(String metaFolderPath) {
        String minorCompactionStatusFile = metaFolderPath + "/" + "compactionRequired_minor";
        String majorCompactionStatusFile = metaFolderPath + "/" + "compactionRequired_major";
        try {
            if (FileFactory.isFileExist((String)minorCompactionStatusFile) || FileFactory.isFileExist((String)majorCompactionStatusFile)) {
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Exception in isFileExist compaction request file " + e.getMessage()), (Throwable)e);
        }
        return false;
    }

    public static CompactionType determineCompactionType(String metaFolderPath) {
        String minorCompactionStatusFile = metaFolderPath + "/" + "compactionRequired_minor";
        String majorCompactionStatusFile = metaFolderPath + "/" + "compactionRequired_major";
        try {
            if (FileFactory.isFileExist((String)minorCompactionStatusFile)) {
                return CompactionType.MINOR;
            }
            if (FileFactory.isFileExist((String)majorCompactionStatusFile)) {
                return CompactionType.MAJOR;
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Exception in determining the compaction request file " + e.getMessage()), (Throwable)e);
        }
        return CompactionType.MINOR;
    }

    public static boolean deleteCompactionRequiredFile(String metaFolderPath, CompactionType compactionType) {
        String compactionRequiredFile = compactionType.equals((Object)CompactionType.MINOR) ? metaFolderPath + "/" + "compactionRequired_minor" : metaFolderPath + "/" + "compactionRequired_major";
        try {
            if (FileFactory.isFileExist((String)compactionRequiredFile)) {
                if (FileFactory.getCarbonFile((String)compactionRequiredFile).delete()) {
                    LOGGER.info((Object)("Deleted the compaction request file " + compactionRequiredFile));
                    return true;
                }
                LOGGER.error((Object)("Unable to delete the compaction request file " + compactionRequiredFile));
            } else {
                LOGGER.info((Object)("Compaction request file is not present. file is : " + compactionRequiredFile));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Exception in deleting the compaction request file " + e.getMessage()), (Throwable)e);
        }
        return false;
    }

    public static boolean createCompactionRequiredFile(String metaFolderPath, CompactionType compactionType) {
        String statusFile = CompactionType.MINOR == compactionType ? metaFolderPath + "/" + "compactionRequired_minor" : metaFolderPath + "/" + "compactionRequired_major";
        try {
            if (!FileFactory.isFileExist((String)statusFile)) {
                if (FileFactory.createNewFile((String)statusFile)) {
                    LOGGER.info((Object)("successfully created a compaction required file - " + statusFile));
                    return true;
                }
                LOGGER.error((Object)("Not able to create a compaction required file - " + statusFile));
                return false;
            }
            LOGGER.info((Object)("Compaction request file : " + statusFile + " already exist."));
        }
        catch (IOException e) {
            LOGGER.error((Object)("Exception in creating the compaction request file " + e.getMessage()), (Throwable)e);
        }
        return false;
    }

    public static CarbonTable getNextTableToCompact(CarbonTable[] carbonTables, List<CarbonTableIdentifier> skipList) {
        for (CarbonTable ctable : carbonTables) {
            String metadataPath = ctable.getMetadataPath();
            if (!CarbonCompactionUtil.isCompactionRequiredForTable(metadataPath) || skipList.contains(ctable.getCarbonTableIdentifier())) continue;
            return ctable;
        }
        return null;
    }

    public static void updateColumnSchema(CarbonTable carbonTable, List<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> updatedColumnSchemaList) {
        List masterDimensions = carbonTable.getVisibleDimensions();
        for (CarbonDimension dimension : masterDimensions) {
            updatedColumnSchemaList.add(dimension.getColumnSchema());
            if (dimension.getNumberOfChild() <= 0) continue;
            CarbonCompactionUtil.fillColumnSchemaListForComplexDims(dimension.getListOfChildDimensions(), updatedColumnSchemaList);
        }
        List masterSchemaMeasures = carbonTable.getVisibleMeasures();
        for (CarbonMeasure measure : masterSchemaMeasures) {
            updatedColumnSchemaList.add(measure.getColumnSchema());
        }
    }

    private static void fillColumnSchemaListForComplexDims(List<CarbonDimension> carbonDimensionsList, List<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> updatedColumnSchemaList) {
        for (CarbonDimension carbonDimension : carbonDimensionsList) {
            updatedColumnSchemaList.add(carbonDimension.getColumnSchema());
            List childDims = carbonDimension.getListOfChildDimensions();
            if (null == childDims || childDims.size() <= 0) continue;
            CarbonCompactionUtil.fillColumnSchemaListForComplexDims(childDims, updatedColumnSchemaList);
        }
    }

    public static boolean checkIfAnyRestructuredBlockExists(Map<String, TaskBlockInfo> segmentMapping, Map<String, List<DataFileFooter>> dataFileMetadataSegMapping, long tableLastUpdatedTime) {
        for (Map.Entry<String, TaskBlockInfo> segmentEntry : segmentMapping.entrySet()) {
            String segmentId = segmentEntry.getKey();
            List<DataFileFooter> listMetadata = dataFileMetadataSegMapping.get(segmentId);
            if (!CarbonCompactionUtil.isRestructured(listMetadata, tableLastUpdatedTime)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRestructured(List<DataFileFooter> listMetadata, long tableLastUpdatedTime) {
        for (DataFileFooter dataFileFooter : listMetadata) {
            if (tableLastUpdatedTime <= dataFileFooter.getSchemaUpdatedTimeStamp()) continue;
            return true;
        }
        return false;
    }

    public static Expression getFilterExpressionForRange(CarbonColumn rangeColumn, Object minVal, Object maxVal, DataType dataType) {
        GreaterThanExpression finalExpr;
        String colName = rangeColumn.getColName();
        if (null == minVal) {
            EqualToExpression exp1 = new EqualToExpression((Expression)new ColumnExpression(colName, dataType), (Expression)new LiteralExpression(null, dataType), true);
            if (null == maxVal) {
                finalExpr = exp1;
            } else {
                LessThanEqualToExpression exp2 = new LessThanEqualToExpression((Expression)new ColumnExpression(colName, dataType), (Expression)new LiteralExpression(maxVal, dataType));
                if (rangeColumn.getDataType() == DataTypes.DATE) {
                    exp2.setAlreadyResolved(true);
                }
                finalExpr = new OrExpression((Expression)exp1, (Expression)exp2);
            }
        } else if (null == maxVal) {
            finalExpr = new GreaterThanExpression((Expression)new ColumnExpression(colName, dataType), (Expression)new LiteralExpression(minVal, dataType));
            if (rangeColumn.getDataType() == DataTypes.DATE) {
                finalExpr.setAlreadyResolved(true);
            }
        } else {
            GreaterThanExpression exp1 = new GreaterThanExpression((Expression)new ColumnExpression(colName, dataType), (Expression)new LiteralExpression(minVal, dataType));
            LessThanEqualToExpression exp2 = new LessThanEqualToExpression((Expression)new ColumnExpression(colName, dataType), (Expression)new LiteralExpression(maxVal, dataType));
            if (rangeColumn.getDataType() == DataTypes.DATE) {
                exp2.setAlreadyResolved(true);
                exp1.setAlreadyResolved(true);
            }
            finalExpr = new AndExpression((Expression)exp1, (Expression)exp2);
        }
        return finalExpr;
    }

    public static Object[] getOverallMinMax(CarbonInputSplit[] carbonInputSplits, CarbonColumn rangeCol, boolean isSortCol) {
        byte[] minVal = null;
        byte[] maxVal = null;
        int dictMinVal = Integer.MAX_VALUE;
        int dictMaxVal = Integer.MIN_VALUE;
        int idx = -1;
        DataType dataType = rangeCol.getDataType();
        Object[] minMaxVals = new Object[2];
        boolean isDictEncode = rangeCol.getDataType() == DataTypes.DATE;
        try {
            for (CarbonInputSplit split : carbonInputSplits) {
                byte[] tempMin;
                DataFileFooter dataFileFooter = null;
                dataFileFooter = CarbonUtil.readMetadataFile((TableBlockInfo)CarbonInputSplit.getTableBlockInfo((CarbonInputSplit)split), (boolean)true);
                if (-1 == idx) {
                    List allColumns = dataFileFooter.getColumnInTable();
                    for (int i = 0; i < allColumns.size(); ++i) {
                        if (!((org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema)allColumns.get(i)).getColumnName().equalsIgnoreCase(rangeCol.getColName())) continue;
                        idx = i;
                        break;
                    }
                }
                if (isDictEncode) {
                    tempMin = dataFileFooter.getBlockletIndex().getMinMaxIndex().getMinValues()[idx];
                    int tempMinVal = CarbonUtil.getSurrogateInternal((byte[])tempMin, (int)0, (int)tempMin.length);
                    byte[] tempMax = dataFileFooter.getBlockletIndex().getMinMaxIndex().getMaxValues()[idx];
                    int tempMaxVal = CarbonUtil.getSurrogateInternal((byte[])tempMax, (int)0, (int)tempMax.length);
                    if (dictMinVal > tempMinVal) {
                        dictMinVal = tempMinVal;
                    }
                    if (dictMaxVal >= tempMaxVal) continue;
                    dictMaxVal = tempMaxVal;
                    continue;
                }
                if (null == minVal) {
                    minVal = dataFileFooter.getBlockletIndex().getMinMaxIndex().getMinValues()[idx];
                    maxVal = dataFileFooter.getBlockletIndex().getMinMaxIndex().getMaxValues()[idx];
                    continue;
                }
                tempMin = dataFileFooter.getBlockletIndex().getMinMaxIndex().getMinValues()[idx];
                byte[] tempMax = dataFileFooter.getBlockletIndex().getMinMaxIndex().getMaxValues()[idx];
                if (ByteUtil.compare((byte[])tempMin, (byte[])minVal) <= 0) {
                    minVal = tempMin;
                }
                if (ByteUtil.compare((byte[])tempMax, (byte[])maxVal) < 0) continue;
                maxVal = tempMax;
            }
            if (isDictEncode) {
                minMaxVals[0] = dictMinVal;
                minMaxVals[1] = dictMaxVal;
            } else if (!(isSortCol || dataType != DataTypes.INT && dataType != DataTypes.LONG)) {
                minMaxVals[0] = ByteUtil.toLong(minVal, (int)0, (int)minVal.length);
                minMaxVals[1] = ByteUtil.toLong(maxVal, (int)0, (int)maxVal.length);
            } else if (dataType == DataTypes.DOUBLE) {
                minMaxVals[0] = ByteUtil.toDouble(minVal, (int)0, (int)minVal.length);
                minMaxVals[1] = ByteUtil.toDouble(maxVal, (int)0, (int)maxVal.length);
            } else {
                minMaxVals[0] = DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn(minVal, (DataType)dataType, (boolean)true);
                minMaxVals[1] = DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn(maxVal, (DataType)dataType, (boolean)true);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage());
        }
        return minMaxVals;
    }

    public static int getTaskCountForSegment(CarbonInputSplit[] splits) {
        HashSet<String> taskIdSet = new HashSet<String>();
        for (CarbonInputSplit split : splits) {
            String taskId = split.taskId;
            taskIdSet.add(taskId);
        }
        return taskIdSet.size();
    }

    private static boolean compareSortColumns(CarbonTable table, List<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> fileColumns) {
        ArrayList<CarbonDimension> sortColumnsOfSegment = new ArrayList<CarbonDimension>();
        for (org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema columnSchema : fileColumns) {
            if (!columnSchema.isDimensionColumn() || !columnSchema.isSortColumn()) continue;
            sortColumnsOfSegment.add(new CarbonDimension(columnSchema, -1, -1, -1));
        }
        if (sortColumnsOfSegment.size() < table.getNumberOfSortColumns()) {
            return false;
        }
        ArrayList<CarbonDimension> sortColumnsOfTable = new ArrayList<CarbonDimension>();
        for (CarbonDimension dimension : table.getVisibleDimensions()) {
            if (!dimension.isSortColumn()) continue;
            sortColumnsOfTable.add(dimension);
        }
        int n = sortColumnsOfTable.size();
        if (sortColumnsOfSegment.size() < n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (RestructureUtil.isColumnMatches((boolean)table.isTransactionalTable(), (CarbonColumn)((CarbonColumn)sortColumnsOfTable.get(i)), (CarbonColumn)((CarbonColumn)sortColumnsOfSegment.get(i)))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedByCurrentSortColumns(CarbonTable table, DataFileFooter footer) {
        if (footer.isSorted().booleanValue()) {
            return CarbonCompactionUtil.compareSortColumns(table, footer.getColumnInTable());
        }
        return false;
    }

    public static boolean isSortedByCurrentSortColumns(CarbonTable table, LoadMetadataDetails load) {
        List sortColumnList = table.getSortColumns();
        if (sortColumnList.isEmpty()) {
            return false;
        }
        String sortColumns = Strings.mkString((String[])sortColumnList.toArray(new String[sortColumnList.size()]), (String)",");
        String segmentPath = CarbonTablePath.getSegmentPath((String)table.getTablePath(), (String)load.getLoadName());
        String segmentSortColumns = CarbonCompactionUtil.getSortColumnsOfSegment(segmentPath);
        if (segmentSortColumns == null) {
            return false;
        }
        return segmentSortColumns.equalsIgnoreCase(sortColumns);
    }

    private static String mkSortColumnsString(List<ColumnSchema> columnList) {
        StringBuilder builder = new StringBuilder();
        for (ColumnSchema column : columnList) {
            Map properties;
            if (!column.isDimension() || (properties = column.getColumnProperties()) == null || properties.get("sort_columns") == null) continue;
            builder.append(column.column_name).append(",");
        }
        if (builder.length() > 1) {
            return builder.substring(0, builder.length() - 1);
        }
        return null;
    }

    public static String getSortColumnsOfSegment(String segmentFolder) {
        CarbonFile[] files = SegmentIndexFileStore.getCarbonIndexFiles((String)segmentFolder, (Configuration)FileFactory.getConfiguration());
        HashSet<Boolean> isSortSet = new HashSet<Boolean>();
        HashSet<String> sortColumnsSet = new HashSet<String>();
        if (files != null) {
            for (CarbonFile file : files) {
                IndexHeader indexHeader = SegmentIndexFileStore.readIndexHeader((String)file.getCanonicalPath(), (Configuration)FileFactory.getConfiguration());
                if (indexHeader != null) {
                    if (indexHeader.isSetIs_sort()) {
                        isSortSet.add(indexHeader.is_sort);
                        if (indexHeader.is_sort) {
                            sortColumnsSet.add(CarbonCompactionUtil.mkSortColumnsString(indexHeader.getTable_columns()));
                        }
                    } else {
                        sortColumnsSet.add(CarbonCompactionUtil.mkSortColumnsString(indexHeader.getTable_columns()));
                    }
                }
                if (isSortSet.size() >= 2 || sortColumnsSet.size() >= 2) break;
            }
        }
        if (isSortSet.size() <= 1 && sortColumnsSet.size() == 1) {
            return (String)sortColumnsSet.iterator().next();
        }
        return null;
    }
}

