/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.merger;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.carbondata.common.exceptions.sql.MalformedCarbonCommandException;
import org.apache.carbondata.common.exceptions.sql.NoSuchMVException;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.locks.CarbonLockUtil;
import org.apache.carbondata.core.locks.ICarbonLock;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.mutate.CarbonUpdateUtil;
import org.apache.carbondata.core.mutate.DeleteDeltaBlockDetails;
import org.apache.carbondata.core.mutate.SegmentUpdateDetails;
import org.apache.carbondata.core.reader.CarbonDeleteFilesDataReader;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.statusmanager.SegmentUpdateStatusManager;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.core.view.MVManager;
import org.apache.carbondata.core.view.MVSchema;
import org.apache.carbondata.core.writer.CarbonDeleteDeltaWriterImpl;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.merger.CarbonDataMergerUtilResult;
import org.apache.carbondata.processing.merger.CompactionType;
import org.apache.carbondata.processing.util.CarbonLoaderUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class CarbonDataMergerUtil {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonDataMergerUtil.class.getName());

    private CarbonDataMergerUtil() {
    }

    private static long getSizeOfFactFileInLoad(CarbonFile carbonFile) {
        CarbonFile[] factFile;
        long factSize = 0L;
        for (CarbonFile fact : factFile = carbonFile.listFiles(new CarbonFileFilter(){

            public boolean accept(CarbonFile file) {
                return CarbonTablePath.isCarbonDataFile((String)file.getName());
            }
        })) {
            factSize += fact.getSize();
        }
        return factSize;
    }

    public static boolean checkIfAutoLoadMergingRequired(CarbonTable carbonTable) {
        Map tblProps = carbonTable.getTableInfo().getFactTable().getTableProperties();
        String isLoadMergeEnabled = CarbonProperties.getInstance().getProperty("carbon.enable.auto.load.merge", "false");
        if (tblProps.containsKey("auto_load_merge")) {
            isLoadMergeEnabled = (String)tblProps.get("auto_load_merge");
        }
        return !isLoadMergeEnabled.equalsIgnoreCase("false");
    }

    public static String getMergedLoadName(List<LoadMetadataDetails> segmentsToBeMergedList) {
        String firstSegmentName = segmentsToBeMergedList.get(0).getLoadName();
        if (firstSegmentName.contains(".")) {
            String beforeDecimal = firstSegmentName.substring(0, firstSegmentName.indexOf("."));
            String afterDecimal = firstSegmentName.substring(firstSegmentName.indexOf(".") + 1);
            int fraction = Integer.parseInt(afterDecimal) + 1;
            String mergedSegmentName = beforeDecimal + "." + fraction;
            return "Segment_" + mergedSegmentName;
        }
        String mergeName = firstSegmentName + "." + 1;
        return "Segment_" + mergeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateLoadMetadataWithMergeStatus(List<LoadMetadataDetails> loadsToMerge, String metaDataFilepath, String mergedLoadNumber, CarbonLoadModel carbonLoadModel, CompactionType compactionType, String segmentFile, MVManager viewManager) throws IOException, NoSuchMVException {
        boolean tableStatusUpdationStatus = false;
        AbsoluteTableIdentifier identifier = carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable().getAbsoluteTableIdentifier();
        SegmentStatusManager segmentStatusManager = new SegmentStatusManager(identifier);
        ICarbonLock carbonLock = segmentStatusManager.getTableStatusLock();
        try {
            int retryCount = CarbonLockUtil.getLockProperty((String)"carbon.concurrent.lock.retries", (int)100);
            int maxTimeout = CarbonLockUtil.getLockProperty((String)"carbon.concurrent.lock.retry.timeout.sec", (int)1);
            if (carbonLock.lockWithRetries(retryCount, maxTimeout)) {
                LOGGER.info((Object)("Acquired lock for the table " + carbonLoadModel.getDatabaseName() + "." + carbonLoadModel.getTableName() + " for table status updation "));
                String statusFilePath = CarbonTablePath.getTableStatusFilePath((String)identifier.getTablePath());
                LoadMetadataDetails[] loadDetails = SegmentStatusManager.readLoadMetadata((String)metaDataFilepath);
                long modificationOrDeletionTimeStamp = CarbonUpdateUtil.readCurrentTime();
                for (LoadMetadataDetails loadDetail : loadDetails) {
                    if (!loadsToMerge.contains(loadDetail)) continue;
                    if (loadDetail.getSegmentStatus() == SegmentStatus.MARKED_FOR_DELETE) {
                        LOGGER.error((Object)("Compaction is aborted as the segment " + loadDetail.getLoadName() + " is deleted after the compaction is started."));
                        boolean bl = false;
                        return bl;
                    }
                    loadDetail.setSegmentStatus(SegmentStatus.COMPACTED);
                    loadDetail.setModificationOrDeletionTimestamp(modificationOrDeletionTimeStamp);
                    loadDetail.setMergedLoadName(mergedLoadNumber);
                }
                LoadMetadataDetails loadMetadataDetails = new LoadMetadataDetails();
                loadMetadataDetails.setSegmentStatus(SegmentStatus.SUCCESS);
                long loadEnddate = CarbonUpdateUtil.readCurrentTime();
                loadMetadataDetails.setLoadEndTime(loadEnddate);
                CarbonTable carbonTable = carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable();
                loadMetadataDetails.setLoadName(mergedLoadNumber);
                loadMetadataDetails.setSegmentFile(segmentFile);
                CarbonLoaderUtil.addDataIndexSizeIntoMetaEntry(loadMetadataDetails, mergedLoadNumber, carbonTable);
                loadMetadataDetails.setLoadStartTime(carbonLoadModel.getFactTimeStamp());
                if (CompactionType.MAJOR == compactionType) {
                    loadMetadataDetails.setMajorCompacted("true");
                }
                if (carbonTable.isMV()) {
                    MVSchema viewSchema = viewManager.getSchema(carbonTable.getDatabaseName(), carbonTable.getTableName());
                    if (null != viewSchema) {
                        String segmentMap = MVManager.getUpdatedSegmentMap((String)mergedLoadNumber, (MVSchema)viewSchema, (LoadMetadataDetails[])loadDetails);
                        loadMetadataDetails.setExtraInfo(segmentMap);
                    } else {
                        throw new NoSuchMVException(carbonTable.getDatabaseName(), carbonTable.getTableName());
                    }
                }
                ArrayList<LoadMetadataDetails> updatedDetailsList = new ArrayList<LoadMetadataDetails>(Arrays.asList(loadDetails));
                updatedDetailsList.add(loadMetadataDetails);
                try {
                    SegmentStatusManager.writeLoadDetailsIntoFile((String)statusFilePath, (LoadMetadataDetails[])updatedDetailsList.toArray(new LoadMetadataDetails[updatedDetailsList.size()]));
                    tableStatusUpdationStatus = true;
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Error while writing metadata");
                    tableStatusUpdationStatus = false;
                }
            } else {
                LOGGER.error((Object)("Could not able to obtain lock for table" + carbonLoadModel.getDatabaseName() + "." + carbonLoadModel.getTableName() + "for table status updation"));
            }
        }
        finally {
            if (carbonLock.unlock()) {
                LOGGER.info((Object)("Table unlocked successfully after table status updation" + carbonLoadModel.getDatabaseName() + "." + carbonLoadModel.getTableName()));
            } else {
                LOGGER.error((Object)("Unable to unlock Table lock for table" + carbonLoadModel.getDatabaseName() + "." + carbonLoadModel.getTableName() + " during table status updation"));
            }
        }
        return tableStatusUpdationStatus;
    }

    public static String getLoadNumberFromLoadName(String loadName) {
        return loadName.substring(loadName.lastIndexOf("Segment_") + "Segment_".length(), loadName.length());
    }

    public static List<LoadMetadataDetails> identifySegmentsToBeMerged(CarbonLoadModel carbonLoadModel, long compactionSize, List<LoadMetadataDetails> segments, CompactionType compactionType, List<String> customSegmentIds) throws IOException, MalformedCarbonCommandException {
        Map tableLevelProperties = carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable().getTableInfo().getFactTable().getTableProperties();
        ArrayList<LoadMetadataDetails> sortedSegments = new ArrayList<LoadMetadataDetails>(segments);
        CarbonDataMergerUtil.sortSegments(sortedSegments);
        if (CompactionType.CUSTOM == compactionType) {
            return CarbonDataMergerUtil.identitySegmentsToBeMergedBasedOnSpecifiedSegments(sortedSegments, new LinkedHashSet<String>(customSegmentIds));
        }
        List<LoadMetadataDetails> listOfSegmentsAfterPreserve = CarbonDataMergerUtil.checkPreserveSegmentsPropertyReturnRemaining(sortedSegments, tableLevelProperties);
        List<LoadMetadataDetails> listOfSegmentsLoadedInSameDateInterval = CarbonDataMergerUtil.identifySegmentsToBeMergedBasedOnLoadedDate(listOfSegmentsAfterPreserve, tableLevelProperties);
        List<LoadMetadataDetails> listOfSegmentsToBeMerged = CompactionType.MAJOR == compactionType ? CarbonDataMergerUtil.identifySegmentsToBeMergedBasedOnSize(compactionSize, listOfSegmentsLoadedInSameDateInterval, carbonLoadModel) : CarbonDataMergerUtil.identifySegmentsToBeMergedBasedOnSegCount(compactionSize, listOfSegmentsLoadedInSameDateInterval, tableLevelProperties, carbonLoadModel);
        return listOfSegmentsToBeMerged;
    }

    public static void sortSegments(List segments) {
        Collections.sort(segments, new Comparator<LoadMetadataDetails>(){

            @Override
            public int compare(LoadMetadataDetails seg1, LoadMetadataDetails seg2) {
                double seg1Id = Double.parseDouble(seg1.getLoadName());
                double seg2Id = Double.parseDouble(seg2.getLoadName());
                return Double.compare(seg1Id, seg2Id);
            }
        });
    }

    private static List<LoadMetadataDetails> identitySegmentsToBeMergedBasedOnSpecifiedSegments(List<LoadMetadataDetails> listOfSegments, Set<String> segmentIds) throws MalformedCarbonCommandException {
        LinkedHashMap<String, LoadMetadataDetails> specifiedSegments = new LinkedHashMap<String, LoadMetadataDetails>(16);
        for (LoadMetadataDetails detail : listOfSegments) {
            if (!segmentIds.contains(detail.getLoadName())) continue;
            specifiedSegments.put(detail.getLoadName(), detail);
        }
        for (String segmentId : segmentIds) {
            if (specifiedSegments.containsKey(segmentId) && CarbonDataMergerUtil.isSegmentValid((LoadMetadataDetails)specifiedSegments.get(segmentId))) continue;
            String errMsg = String.format("Segment %s does not exist or is not valid", segmentId);
            LOGGER.error((Object)errMsg);
            throw new MalformedCarbonCommandException(errMsg);
        }
        return new ArrayList<LoadMetadataDetails>(specifiedSegments.values());
    }

    private static List<LoadMetadataDetails> identifySegmentsToBeMergedBasedOnLoadedDate(List<LoadMetadataDetails> listOfSegmentsBelowThresholdSize, Map<String, String> tblProps) {
        ArrayList<LoadMetadataDetails> loadsOfSameDate = new ArrayList<LoadMetadataDetails>(16);
        long numberOfDaysAllowedToMerge = 0L;
        try {
            numberOfDaysAllowedToMerge = Long.parseLong(CarbonProperties.getInstance().getProperty("carbon.allowed.compaction.days", "0"));
            if (tblProps.containsKey("allowed_compaction_days")) {
                numberOfDaysAllowedToMerge = Long.parseLong(tblProps.get("allowed_compaction_days"));
            }
            if (numberOfDaysAllowedToMerge < 0L || numberOfDaysAllowedToMerge > 100L) {
                LOGGER.error((Object)"The specified value for property carbon.allowed.compaction.days is incorrect. Correct value should be in range of 0 -100. Taking the default value.");
                numberOfDaysAllowedToMerge = Long.parseLong("0");
            }
        }
        catch (NumberFormatException e) {
            numberOfDaysAllowedToMerge = Long.parseLong("0");
        }
        if (numberOfDaysAllowedToMerge > 0L) {
            boolean first = true;
            Date segDate1 = null;
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            for (LoadMetadataDetails segment : listOfSegmentsBelowThresholdSize) {
                if (segment.getSegmentStatus() == SegmentStatus.STREAMING || segment.getSegmentStatus() == SegmentStatus.STREAMING_FINISH) continue;
                if (first) {
                    segDate1 = CarbonDataMergerUtil.initializeFirstSegment(loadsOfSameDate, segment, sdf);
                    first = false;
                    continue;
                }
                long segmentDate = segment.getLoadStartTime();
                Date segDate2 = null;
                try {
                    segDate2 = sdf.parse(sdf.format(segmentDate));
                }
                catch (ParseException e) {
                    LOGGER.error((Object)("Error while parsing segment start time" + e.getMessage()), (Throwable)e);
                }
                if (CarbonDataMergerUtil.isTwoDatesPresentInRequiredRange(segDate1, segDate2, numberOfDaysAllowedToMerge)) {
                    loadsOfSameDate.add(segment);
                    continue;
                }
                if (loadsOfSameDate.size() < 2) {
                    loadsOfSameDate.clear();
                    segDate1 = CarbonDataMergerUtil.initializeFirstSegment(loadsOfSameDate, segment, sdf);
                    continue;
                }
                break;
            }
        } else {
            for (LoadMetadataDetails segment : listOfSegmentsBelowThresholdSize) {
                if (segment.getSegmentStatus() == SegmentStatus.STREAMING || segment.getSegmentStatus() == SegmentStatus.STREAMING_FINISH) continue;
                loadsOfSameDate.add(segment);
            }
        }
        return loadsOfSameDate;
    }

    private static Date initializeFirstSegment(List<LoadMetadataDetails> loadsOfSameDate, LoadMetadataDetails segment, SimpleDateFormat sdf) {
        long baselineLoadStartTime = segment.getLoadStartTime();
        Date segDate1 = null;
        try {
            segDate1 = sdf.parse(sdf.format(baselineLoadStartTime));
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Error while parsing segment start time" + e.getMessage()), (Throwable)e);
        }
        loadsOfSameDate.add(segment);
        return segDate1;
    }

    private static boolean isTwoDatesPresentInRequiredRange(Date segDate1, Date segDate2, long numberOfDaysAllowedToMerge) {
        if (segDate1 == null || segDate2 == null) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.set(segDate1.getYear(), segDate1.getMonth(), segDate1.getDate());
        Calendar cal2 = Calendar.getInstance();
        cal2.set(segDate2.getYear(), segDate2.getMonth(), segDate2.getDate());
        long diff = cal2.getTimeInMillis() - cal1.getTimeInMillis();
        return diff / 86400000L < numberOfDaysAllowedToMerge;
    }

    private static List<LoadMetadataDetails> identifySegmentsToBeMergedBasedOnSize(long compactionSize, List<LoadMetadataDetails> listOfSegmentsAfterPreserve, CarbonLoadModel carbonLoadModel) throws IOException {
        ArrayList<Object> segmentsToBeMerged = new ArrayList<LoadMetadataDetails>(16);
        CarbonTable carbonTable = carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable();
        long totalLength = 0L;
        for (LoadMetadataDetails segment : listOfSegmentsAfterPreserve) {
            if (segment.getSegmentStatus() == SegmentStatus.STREAMING || segment.getSegmentStatus() == SegmentStatus.STREAMING_FINISH) continue;
            String segId = segment.getLoadName();
            long sizeOfOneSegmentAcrossPartition = segment.getSegmentFile() != null ? (!StringUtils.isEmpty((String)segment.getDataSize()) ? Long.parseLong(segment.getDataSize()) : CarbonUtil.getSizeOfSegment((String)carbonTable.getTablePath(), (Segment)new Segment(segId, segment.getSegmentFile()))) : CarbonDataMergerUtil.getSizeOfSegment(carbonTable.getTablePath(), segId);
            if (sizeOfOneSegmentAcrossPartition > compactionSize * 1024L * 1024L) {
                if (segmentsToBeMerged.size() > 1) break;
                segmentsToBeMerged = new ArrayList(16);
                totalLength = 0L;
                continue;
            }
            if ((totalLength += sizeOfOneSegmentAcrossPartition) < compactionSize * 1024L * 1024L) {
                segmentsToBeMerged.add(segment);
                continue;
            }
            if (segmentsToBeMerged.size() > 1) break;
            segmentsToBeMerged = new ArrayList(16);
            segmentsToBeMerged.add(segment);
            totalLength = sizeOfOneSegmentAcrossPartition;
        }
        return segmentsToBeMerged;
    }

    private static long getSizeOfSegment(String tablePath, String segId) {
        String loadPath = CarbonTablePath.getSegmentPath((String)tablePath, (String)segId);
        CarbonFile segmentFolder = FileFactory.getCarbonFile((String)loadPath);
        return CarbonDataMergerUtil.getSizeOfFactFileInLoad(segmentFolder);
    }

    private static List<LoadMetadataDetails> identifySegmentsToBeMergedBasedOnSegCount(long compactionSize, List<LoadMetadataDetails> listOfSegmentsAfterPreserve, Map<String, String> tblProps, CarbonLoadModel carbonLoadModel) throws IOException {
        ArrayList<LoadMetadataDetails> mergedSegments = new ArrayList<LoadMetadataDetails>(16);
        ArrayList<LoadMetadataDetails> unMergedSegments = new ArrayList<LoadMetadataDetails>(16);
        int[] noOfSegmentLevelsCount = CarbonProperties.getInstance().getCompactionSegmentLevelCount();
        if (tblProps.containsKey("compaction_level_threshold") && 0 == (noOfSegmentLevelsCount = CarbonProperties.getInstance().getIntArray(tblProps.get("compaction_level_threshold"))).length) {
            noOfSegmentLevelsCount = CarbonProperties.getInstance().getCompactionSegmentLevelCount();
        }
        int level1Size = 0;
        int level2Size = 0;
        int size = noOfSegmentLevelsCount.length;
        if (size >= 2) {
            level1Size = noOfSegmentLevelsCount[0];
            level2Size = noOfSegmentLevelsCount[1];
            level2Size = level2Size == 1 ? 0 : level2Size;
        } else if (size == 1) {
            level1Size = noOfSegmentLevelsCount[0];
        }
        int unMergeCounter = 0;
        int mergeCounter = 0;
        CarbonTable carbonTable = carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable();
        for (LoadMetadataDetails segment : listOfSegmentsAfterPreserve) {
            long sizeOfOneSegmentAcrossPartition = segment.getSegmentFile() != null ? (!StringUtils.isEmpty((String)segment.getDataSize()) ? Long.parseLong(segment.getDataSize()) : CarbonUtil.getSizeOfSegment((String)carbonTable.getTablePath(), (Segment)new Segment(segment.getLoadName(), segment.getSegmentFile()))) : CarbonDataMergerUtil.getSizeOfSegment(carbonTable.getTablePath(), segment.getLoadName());
            if (segment.getSegmentStatus() == SegmentStatus.STREAMING || segment.getSegmentStatus() == SegmentStatus.STREAMING_FINISH || compactionSize > 0L && sizeOfOneSegmentAcrossPartition / 0x100000L >= compactionSize) continue;
            String segName = segment.getLoadName();
            boolean isMoreThanOrEqualsToLevel2 = false;
            if (segName.contains(".") && Integer.parseInt(segName.substring(segName.lastIndexOf(".") + 1)) >= 2) {
                isMoreThanOrEqualsToLevel2 = true;
            }
            if (isMoreThanOrEqualsToLevel2 || segment.isMajorCompacted() != null && segment.isMajorCompacted().equalsIgnoreCase("true") || segment.getSegmentStatus() != SegmentStatus.SUCCESS && segment.getSegmentStatus() != SegmentStatus.LOAD_PARTIAL_SUCCESS) continue;
            if (!CarbonDataMergerUtil.isMergedSegment(segName)) {
                unMergedSegments.add(segment);
                if (++unMergeCounter != level1Size) continue;
                return unMergedSegments;
            }
            mergedSegments.add(segment);
            if (++mergeCounter != level2Size) continue;
            return mergedSegments;
        }
        return new ArrayList<LoadMetadataDetails>(0);
    }

    private static boolean isMergedSegment(String segName) {
        return segName.contains(".");
    }

    private static List<LoadMetadataDetails> checkPreserveSegmentsPropertyReturnRemaining(List<LoadMetadataDetails> segments, Map<String, String> tblProps) {
        int numberOfSegmentsToBePreserved = CarbonProperties.getInstance().getNumberOfSegmentsToBePreserved();
        if (tblProps.containsKey("compaction_preserve_segments")) {
            numberOfSegmentsToBePreserved = Integer.parseInt(tblProps.get("compaction_preserve_segments"));
        }
        return CarbonDataMergerUtil.getValidLoadDetailsWithRetaining(segments, numberOfSegmentsToBePreserved);
    }

    private static List<LoadMetadataDetails> getValidLoadDetailsWithRetaining(List<LoadMetadataDetails> loadMetadataDetails, int numberOfSegToBeRetained) {
        ArrayList<LoadMetadataDetails> validList = new ArrayList<LoadMetadataDetails>(16);
        for (LoadMetadataDetails segment : loadMetadataDetails) {
            if (!CarbonDataMergerUtil.isSegmentValid(segment)) continue;
            validList.add(segment);
        }
        int removingIndex = validList.size() - 1;
        for (int i = validList.size(); i > 0 && numberOfSegToBeRetained != 0; --numberOfSegToBeRetained, --i) {
            validList.remove(removingIndex--);
        }
        return validList;
    }

    public static long getCompactionSize(CompactionType compactionType, CarbonLoadModel carbonLoadModel) {
        long compactionSize = 0L;
        Map tblProps = carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable().getTableInfo().getFactTable().getTableProperties();
        switch (compactionType) {
            case MAJOR: {
                if (tblProps.containsKey("major_compaction_size")) {
                    compactionSize = Long.parseLong((String)tblProps.get("major_compaction_size"));
                    break;
                }
                compactionSize = CarbonProperties.getInstance().getMajorCompactionSize();
                break;
            }
            case MINOR: {
                if (tblProps.containsKey("minor_compaction_size")) {
                    compactionSize = Long.parseLong((String)tblProps.get("minor_compaction_size"));
                    break;
                }
                compactionSize = CarbonProperties.getInstance().getMinorCompactionSize();
                break;
            }
        }
        return compactionSize;
    }

    public static List<Segment> getValidSegments(List<LoadMetadataDetails> loadMetadataDetails) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        for (LoadMetadataDetails segment : loadMetadataDetails) {
            if (null != segment.getMergedLoadName()) {
                segments.add(new Segment(segment.getMergedLoadName(), segment.getSegmentFile(), null, segment));
                continue;
            }
            segments.add(new Segment(segment.getLoadName(), segment.getSegmentFile(), null, segment));
        }
        return segments;
    }

    public static List<Segment> getValidSegmentList(CarbonTable carbonTable) throws IOException {
        SegmentStatusManager.ValidAndInvalidSegmentsInfo validAndInvalidSegments = null;
        try {
            validAndInvalidSegments = new SegmentStatusManager(carbonTable.getAbsoluteTableIdentifier()).getValidAndInvalidSegments(Boolean.valueOf(carbonTable.isMV()));
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error while getting valid segment list for a table identifier");
            throw new IOException();
        }
        return validAndInvalidSegments.getValidSegments();
    }

    public static List<LoadMetadataDetails> filterOutNewlyAddedSegments(List<LoadMetadataDetails> segments, LoadMetadataDetails lastSeg) {
        ArrayList<LoadMetadataDetails> list = new ArrayList<LoadMetadataDetails>(segments);
        CarbonDataMergerUtil.sortSegments(list);
        return list.subList(0, list.indexOf(lastSeg) + 1);
    }

    private static boolean isSegmentValid(LoadMetadataDetails seg) {
        return seg.getSegmentStatus() == SegmentStatus.SUCCESS || seg.getSegmentStatus() == SegmentStatus.LOAD_PARTIAL_SUCCESS || seg.getSegmentStatus() == SegmentStatus.MARKED_FOR_UPDATE;
    }

    public static List<String> getSegListIUDCompactionQualified(List<Segment> segments, AbsoluteTableIdentifier absoluteTableIdentifier, SegmentUpdateStatusManager segmentUpdateStatusManager, CompactionType compactionTypeIUD) {
        ArrayList<String> validSegments = new ArrayList<String>();
        int numberDeleteDeltaFilesThreshold = CarbonProperties.getInstance().getNoDeleteDeltaFilesThresholdForIUDCompaction();
        for (Segment seg : segments) {
            List<String> segmentNoAndBlocks = CarbonDataMergerUtil.checkDeleteDeltaFilesInSeg(seg, segmentUpdateStatusManager, numberDeleteDeltaFilesThreshold);
            validSegments.addAll(segmentNoAndBlocks);
        }
        return validSegments;
    }

    private static List<String> checkDeleteDeltaFilesInSeg(Segment seg, SegmentUpdateStatusManager segmentUpdateStatusManager, int numberDeltaFilesThreshold) {
        ArrayList<String> blockLists = new ArrayList<String>();
        HashSet<String> uniqueBlocks = new HashSet<String>();
        List blockNameList = segmentUpdateStatusManager.getBlockNameFromSegment(seg.getSegmentNo());
        block0: for (String blockName : blockNameList) {
            List deleteDeltaFiles = segmentUpdateStatusManager.getDeleteDeltaFilesList(seg, blockName);
            if (null == deleteDeltaFiles || deleteDeltaFiles.size() <= numberDeltaFilesThreshold) continue;
            for (String deleteDeltaFile : deleteDeltaFiles) {
                String task = CarbonTablePath.DataFileUtil.getTaskNo((String)deleteDeltaFile);
                String timestamp = CarbonTablePath.DataFileUtil.getTimeStampFromDeleteDeltaFile((String)deleteDeltaFile);
                String taskAndTimeStamp = task + "-" + timestamp;
                uniqueBlocks.add(taskAndTimeStamp);
                if (uniqueBlocks.size() <= numberDeltaFilesThreshold) continue;
                blockLists.add(seg.getSegmentNo() + "/" + blockName);
                continue block0;
            }
        }
        return blockLists;
    }

    public static boolean isHorizontalCompactionEnabled() {
        return CarbonProperties.getInstance().getProperty("carbon.horizontal.compaction.enable", "true").equalsIgnoreCase("true");
    }

    public static List<CarbonDataMergerUtilResult> compactBlockDeleteDeltaFiles(String seg, String blockName, CarbonTable table, SegmentUpdateDetails[] segmentUpdateDetails, Long timestamp) throws IOException {
        SegmentUpdateStatusManager segmentUpdateStatusManager = new SegmentUpdateStatusManager(table);
        ArrayList<CarbonDataMergerUtilResult> resultList = new ArrayList<CarbonDataMergerUtilResult>(1);
        segmentUpdateStatusManager.setUpdateStatusDetails(segmentUpdateDetails);
        List deleteFilePathList = segmentUpdateStatusManager.getDeleteDeltaFilesList(new Segment(seg), blockName);
        String destFileName = blockName + "-" + timestamp.toString() + ".deletedelta";
        if (deleteFilePathList.size() > 0) {
            String deleteDeltaFilePath = (String)deleteFilePathList.get(0);
            String fullBlockFilePath = deleteDeltaFilePath.substring(0, deleteDeltaFilePath.lastIndexOf("/")) + "/" + destFileName;
            CarbonDataMergerUtilResult blockDetails = new CarbonDataMergerUtilResult();
            blockDetails.setBlockName(blockName);
            blockDetails.setSegmentName(seg);
            blockDetails.setDeleteDeltaStartTimestamp(timestamp.toString());
            blockDetails.setDeleteDeltaEndTimestamp(timestamp.toString());
            try {
                CarbonDataMergerUtil.startCompactionDeleteDeltaFiles(deleteFilePathList, blockName, fullBlockFilePath);
                blockDetails.setCompactionStatus(true);
                resultList.add(blockDetails);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Compaction of Delete Delta Files failed. The complete file path is " + fullBlockFilePath));
                throw new IOException();
            }
        }
        return resultList;
    }

    public static void startCompactionDeleteDeltaFiles(List<String> deleteDeltaFiles, String blockName, String fullBlockFilePath) throws IOException {
        DeleteDeltaBlockDetails deleteDeltaBlockDetails = null;
        int numberOfcores = CarbonProperties.getInstance().getNumberOfCompactingCores();
        CarbonDeleteFilesDataReader dataReader = new CarbonDeleteFilesDataReader(numberOfcores);
        try {
            deleteDeltaBlockDetails = dataReader.getCompactedDeleteDeltaFileFromBlock(deleteDeltaFiles, blockName);
        }
        catch (Exception e) {
            String blockFilePath = fullBlockFilePath.substring(0, fullBlockFilePath.lastIndexOf("/"));
            LOGGER.error((Object)("Error while getting the delete delta blocks in path " + blockFilePath));
            throw new IOException();
        }
        CarbonDeleteDeltaWriterImpl carbonDeleteWriter = new CarbonDeleteDeltaWriterImpl(fullBlockFilePath);
        try {
            carbonDeleteWriter.write(deleteDeltaBlockDetails);
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error while writing compacted delete delta file " + fullBlockFilePath));
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean updateStatusFile(List<CarbonDataMergerUtilResult> updateDataMergerDetailsList, CarbonTable table, String timestamp, SegmentUpdateStatusManager segmentUpdateStatusManager) {
        block17: {
            ArrayList<SegmentUpdateDetails> segmentUpdateDetails = new ArrayList<SegmentUpdateDetails>(updateDataMergerDetailsList.size());
            for (CarbonDataMergerUtilResult carbonDataMergerUtilResult : updateDataMergerDetailsList) {
                if (carbonDataMergerUtilResult.getCompactionStatus()) {
                    SegmentUpdateDetails tempSegmentUpdateDetails = new SegmentUpdateDetails();
                    tempSegmentUpdateDetails.setSegmentName(carbonDataMergerUtilResult.getSegmentName());
                    tempSegmentUpdateDetails.setBlockName(carbonDataMergerUtilResult.getBlockName());
                    for (SegmentUpdateDetails origDetails : segmentUpdateStatusManager.getUpdateStatusDetails()) {
                        if (!origDetails.getBlockName().equalsIgnoreCase(carbonDataMergerUtilResult.getBlockName()) || !origDetails.getSegmentName().equalsIgnoreCase(carbonDataMergerUtilResult.getSegmentName())) continue;
                        tempSegmentUpdateDetails.setDeletedRowsInBlock(origDetails.getDeletedRowsInBlock());
                        tempSegmentUpdateDetails.setSegmentStatus(origDetails.getSegmentStatus());
                        break;
                    }
                    tempSegmentUpdateDetails.setDeleteDeltaStartTimestamp(carbonDataMergerUtilResult.getDeleteDeltaStartTimestamp());
                    tempSegmentUpdateDetails.setDeleteDeltaEndTimestamp(carbonDataMergerUtilResult.getDeleteDeltaEndTimestamp());
                    segmentUpdateDetails.add(tempSegmentUpdateDetails);
                    continue;
                }
                return false;
            }
            CarbonUpdateUtil.updateSegmentStatus(segmentUpdateDetails, (CarbonTable)table, (String)timestamp, (boolean)true, (boolean)false);
            String metaDataFilepath = table.getMetadataPath();
            AbsoluteTableIdentifier identifier = table.getAbsoluteTableIdentifier();
            String tableStatusPath = CarbonTablePath.getTableStatusFilePath((String)identifier.getTablePath());
            SegmentStatusManager segmentStatusManager = new SegmentStatusManager(identifier);
            ICarbonLock carbonLock = segmentStatusManager.getTableStatusLock();
            boolean lockStatus = false;
            try {
                lockStatus = carbonLock.lockWithRetries();
                if (lockStatus) {
                    LoadMetadataDetails[] listOfLoadFolderDetailsArray;
                    LOGGER.info((Object)("Acquired lock for table" + table.getDatabaseName() + "." + table.getTableName() + " for table status updation"));
                    for (LoadMetadataDetails loadMetadata : listOfLoadFolderDetailsArray = SegmentStatusManager.readLoadMetadata((String)metaDataFilepath)) {
                        if (!loadMetadata.getLoadName().equalsIgnoreCase("0")) continue;
                        loadMetadata.setUpdateStatusFileName(CarbonUpdateUtil.getUpdateStatusFileName((String)timestamp));
                    }
                    try {
                        SegmentStatusManager.writeLoadDetailsIntoFile((String)tableStatusPath, (LoadMetadataDetails[])listOfLoadFolderDetailsArray);
                        break block17;
                    }
                    catch (IOException e) {
                        Boolean bl = false;
                        if (lockStatus) {
                            if (carbonLock.unlock()) {
                                LOGGER.info((Object)("Table unlocked successfully after table status updation" + table.getDatabaseName() + "." + table.getTableName()));
                            } else {
                                LOGGER.error((Object)("Unable to unlock Table lock for table" + table.getDatabaseName() + "." + table.getTableName() + " during table status updation"));
                            }
                        }
                        return bl;
                    }
                }
                LOGGER.error((Object)("Not able to acquire the lock for Table status updation for table " + table.getDatabaseName() + "." + table.getTableName()));
            }
            finally {
                if (lockStatus) {
                    if (carbonLock.unlock()) {
                        LOGGER.info((Object)("Table unlocked successfully after table status updation" + table.getDatabaseName() + "." + table.getTableName()));
                    } else {
                        LOGGER.error((Object)("Unable to unlock Table lock for table" + table.getDatabaseName() + "." + table.getTableName() + " during table status updation"));
                    }
                }
            }
        }
        return true;
    }
}

