/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.merger;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.exception.CarbonDataWriterException;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.metadata.SegmentFileStore;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.scan.result.iterator.RawResultIterator;
import org.apache.carbondata.core.scan.wrappers.ByteArrayWrapper;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.merger.AbstractResultProcessor;
import org.apache.carbondata.processing.merger.CompactionType;
import org.apache.carbondata.processing.sort.exception.CarbonSortKeyAndGroupByException;
import org.apache.carbondata.processing.sort.sortdata.SingleThreadFinalSortFilesMerger;
import org.apache.carbondata.processing.sort.sortdata.SortDataRows;
import org.apache.carbondata.processing.sort.sortdata.SortIntermediateFileMerger;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;
import org.apache.carbondata.processing.store.CarbonFactDataHandlerModel;
import org.apache.carbondata.processing.store.CarbonFactHandler;
import org.apache.carbondata.processing.store.CarbonFactHandlerFactory;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;
import org.apache.log4j.Logger;

public class CompactionResultSortProcessor
extends AbstractResultProcessor {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CompactionResultSortProcessor.class.getName());
    private CarbonLoadModel carbonLoadModel;
    private CarbonTable carbonTable;
    private SortDataRows sortDataRows;
    private SingleThreadFinalSortFilesMerger finalMerger;
    private CarbonFactHandler dataHandler;
    private SegmentProperties segmentProperties;
    private CompactionType compactionType;
    private boolean[] noDictionaryColMapping;
    private boolean[] sortColumnMapping;
    private boolean[] isVarcharDimMapping;
    private DataType[] dataTypes;
    private String segmentId;
    private String[] tempStoreLocation;
    private String tableName;
    private int noDictionaryCount;
    private int measureCount;
    private int dimensionColumnCount;
    private List<CarbonDimension> dimensions;
    private boolean isRecordFound;
    private SortIntermediateFileMerger intermediateFileMerger;
    private PartitionSpec partitionSpec;
    private SortParameters sortParameters;
    private CarbonColumn[] noDicAndComplexColumns;

    public CompactionResultSortProcessor(CarbonLoadModel carbonLoadModel, CarbonTable carbonTable, SegmentProperties segmentProperties, CompactionType compactionType, String tableName, PartitionSpec partitionSpec) {
        this.carbonLoadModel = carbonLoadModel;
        this.carbonTable = carbonTable;
        this.segmentProperties = segmentProperties;
        this.segmentId = carbonLoadModel.getSegmentId();
        this.compactionType = compactionType;
        this.tableName = tableName;
        this.partitionSpec = partitionSpec;
    }

    @Override
    public boolean execute(List<RawResultIterator> unsortedResultIteratorList, List<RawResultIterator> sortedResultIteratorList) throws Exception {
        boolean isCompactionSuccess = false;
        try {
            this.initTempStoreLocation();
            this.initSortDataRows();
            this.dataTypes = CarbonDataProcessorUtil.initDataType(this.carbonTable, this.tableName, this.measureCount);
            this.processResult(unsortedResultIteratorList);
            if (this.isRecordFound) {
                this.initializeFinalThreadMergerForMergeSort();
                this.initDataHandler();
                this.readAndLoadDataFromSortTempFiles(sortedResultIteratorList);
            }
            isCompactionSuccess = true;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        finally {
            boolean isMergeIndex = Boolean.parseBoolean(CarbonProperties.getInstance().getProperty("carbon.merge.index.in.segment", "true"));
            if (this.partitionSpec != null && !isMergeIndex) {
                SegmentFileStore.writeSegmentFileForPartitionTable((String)this.carbonLoadModel.getTablePath(), (String)this.carbonLoadModel.getTaskNo(), (String)this.partitionSpec.getLocation().toString(), (String)(this.carbonLoadModel.getFactTimeStamp() + ""), (List)this.partitionSpec.getPartitions());
            }
            this.deleteTempStoreLocation();
        }
        return isCompactionSuccess;
    }

    @Override
    public void close() {
        if (null != this.sortDataRows) {
            this.sortDataRows.close();
        }
        if (null != this.finalMerger) {
            this.finalMerger.close();
        }
        if (null != this.dataHandler) {
            this.dataHandler.closeHandler();
        }
    }

    private void deleteTempStoreLocation() {
        if (null != this.tempStoreLocation) {
            for (String tempLoc : this.tempStoreLocation) {
                try {
                    CarbonUtil.deleteFoldersAndFiles((File[])new File[]{new File(tempLoc)});
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.error((Object)("Problem deleting local folders during compaction: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private void processResult(List<RawResultIterator> resultIteratorList) throws Exception {
        for (RawResultIterator resultIterator : resultIteratorList) {
            if (CompactionType.STREAMING == this.compactionType) {
                while (resultIterator.hasNext()) {
                    this.addRowForSorting(this.prepareStreamingRowObjectForSorting(resultIterator.next()));
                    this.isRecordFound = true;
                }
            } else {
                while (resultIterator.hasNext()) {
                    this.addRowForSorting(this.prepareRowObjectForSorting(resultIterator.next()));
                    this.isRecordFound = true;
                }
            }
            resultIterator.close();
        }
        try {
            this.sortDataRows.startSorting();
        }
        catch (CarbonSortKeyAndGroupByException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Problem loading data during compaction: " + e.getMessage(), e);
        }
    }

    private Object[] prepareStreamingRowObjectForSorting(Object[] row) {
        int i;
        Object[] preparedRow = new Object[this.dimensions.size() + this.measureCount];
        for (i = 0; i < this.dimensions.size(); ++i) {
            CarbonDimension dims = this.dimensions.get(i);
            if (dims.getDataType() == DataTypes.DATE) {
                preparedRow[i] = row[i];
                continue;
            }
            if (DataTypeUtil.isPrimitiveColumn((DataType)dims.getDataType()) && !dims.isComplex().booleanValue()) {
                preparedRow[i] = DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn((byte[])((byte[])row[i]), (DataType)dims.getDataType());
                if (null == preparedRow[i] || dims.getDataType() != DataTypes.TIMESTAMP) continue;
                preparedRow[i] = (Long)preparedRow[i] / 1000L;
                continue;
            }
            preparedRow[i] = row[i];
        }
        for (i = 0; i < this.measureCount; ++i) {
            preparedRow[this.dimensionColumnCount + i] = row[this.dimensionColumnCount + i];
        }
        return preparedRow;
    }

    private Object[] prepareRowObjectForSorting(Object[] row) {
        ByteArrayWrapper wrapper = (ByteArrayWrapper)row[0];
        Object[] preparedRow = new Object[this.dimensions.size() + this.measureCount];
        int noDictionaryIndex = 0;
        int dictionaryIndex = 0;
        int complexIndex = 0;
        for (int i = 0; i < this.dimensions.size(); ++i) {
            CarbonDimension dims = this.dimensions.get(i);
            if (dims.getDataType() == DataTypes.DATE && !dims.isComplex().booleanValue()) {
                preparedRow[i] = wrapper.getDictionaryKeyByIndex(dictionaryIndex++);
                continue;
            }
            if (!dims.isComplex().booleanValue()) {
                byte[] noDictionaryKeyByIndex = wrapper.getNoDictionaryKeyByIndex(noDictionaryIndex++);
                if (DataTypeUtil.isPrimitiveColumn((DataType)dims.getDataType())) {
                    preparedRow[i] = DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn((byte[])noDictionaryKeyByIndex, (DataType)dims.getDataType());
                    if (null == preparedRow[i] || dims.getDataType() != DataTypes.TIMESTAMP) continue;
                    preparedRow[i] = (Long)preparedRow[i] / 1000L;
                    continue;
                }
                preparedRow[i] = noDictionaryKeyByIndex;
                continue;
            }
            preparedRow[i] = wrapper.getComplexKeyByIndex(complexIndex++);
        }
        int measureIndexInRow = 1;
        for (int i = 0; i < this.measureCount; ++i) {
            preparedRow[this.dimensionColumnCount + i] = this.getConvertedMeasureValue(row[measureIndexInRow++], this.dataTypes[i]);
        }
        return preparedRow;
    }

    private Object getConvertedMeasureValue(Object value, DataType type) {
        if (DataTypes.isDecimal((DataType)type)) {
            if (value != null) {
                value = DataTypeUtil.getDataTypeConverter().convertFromDecimalToBigDecimal(value);
            }
            return value;
        }
        return value;
    }

    private void readAndLoadDataFromSortTempFiles(List<RawResultIterator> sortedRawResultIterator) throws Exception {
        try {
            this.intermediateFileMerger.finish();
            this.finalMerger.startFinalMerge();
            if (sortedRawResultIterator != null && sortedRawResultIterator.size() > 0) {
                this.finalMerger.addInMemoryRawResultIterator(sortedRawResultIterator, this.segmentProperties, this.noDicAndComplexColumns, this.dataTypes);
            }
            while (this.finalMerger.hasNext()) {
                Object[] row = this.finalMerger.next();
                this.dataHandler.addDataToStore(new CarbonRow(row));
            }
            this.dataHandler.finish();
        }
        catch (CarbonDataWriterException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Problem loading data during compaction.", e);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Problem loading data during compaction.", e);
        }
        finally {
            if (null != this.dataHandler) {
                try {
                    this.dataHandler.closeHandler();
                }
                catch (CarbonDataWriterException e) {
                    LOGGER.error((Object)"Error in close data handler", (Throwable)e);
                    throw new Exception("Error in close data handler", e);
                }
            }
        }
    }

    private void addRowForSorting(Object[] row) throws Exception {
        try {
            this.sortDataRows.addRow(row);
        }
        catch (CarbonSortKeyAndGroupByException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Row addition for sorting failed during compaction: " + e.getMessage(), e);
        }
    }

    private void initSortDataRows() {
        this.measureCount = this.carbonTable.getVisibleMeasures().size();
        this.dimensions = new ArrayList<CarbonDimension>(2);
        this.dimensions.addAll(this.segmentProperties.getDimensions());
        this.dimensions.addAll(this.segmentProperties.getComplexDimensions());
        this.noDictionaryColMapping = new boolean[this.dimensions.size()];
        this.sortColumnMapping = new boolean[this.dimensions.size()];
        this.isVarcharDimMapping = new boolean[this.dimensions.size()];
        int i = 0;
        for (CarbonDimension dimension : this.dimensions) {
            if (dimension.isSortColumn()) {
                this.sortColumnMapping[i] = true;
            }
            if (dimension.getDataType() == DataTypes.DATE) {
                ++i;
                continue;
            }
            this.noDictionaryColMapping[i] = true;
            if (dimension.getColumnSchema().getDataType() == DataTypes.VARCHAR) {
                this.isVarcharDimMapping[i] = true;
            }
            ++i;
            ++this.noDictionaryCount;
        }
        this.dimensionColumnCount = this.dimensions.size();
        this.sortParameters = this.createSortParameters();
        this.intermediateFileMerger = new SortIntermediateFileMerger(this.sortParameters);
        CarbonDataProcessorUtil.deleteSortLocationIfExists(this.sortParameters.getTempFileLocation());
        CarbonDataProcessorUtil.createLocations(this.sortParameters.getTempFileLocation());
        this.sortDataRows = new SortDataRows(this.sortParameters, this.intermediateFileMerger);
        this.sortDataRows.initialize();
    }

    private SortParameters createSortParameters() {
        int numberOfCompactingCores = CarbonProperties.getInstance().getNumberOfCompactingCores();
        return SortParameters.createSortParameters(this.carbonTable, this.carbonLoadModel.getDatabaseName(), this.tableName, this.dimensionColumnCount, this.segmentProperties.getComplexDimensions().size(), this.measureCount, this.noDictionaryCount, this.segmentId, this.carbonLoadModel.getTaskNo(), this.noDictionaryColMapping, this.sortColumnMapping, this.isVarcharDimMapping, true, numberOfCompactingCores / 2);
    }

    private void initializeFinalThreadMergerForMergeSort() {
        boolean[] noDictionarySortColumnMapping = CarbonDataProcessorUtil.getNoDictSortColMapping(this.carbonTable);
        this.sortParameters.setNoDictionarySortColumn(noDictionarySortColumnMapping);
        Map<String, int[]> columnIdxMap = CarbonDataProcessorUtil.getColumnIdxBasedOnSchemaInRow(this.carbonTable);
        this.sortParameters.setNoDictSortColumnSchemaOrderMapping(columnIdxMap.get("columnIdxBasedOnSchemaInRow"));
        this.sortParameters.setNoDictSortColIdxSchemaOrderMapping(columnIdxMap.get("noDictSortIdxBasedOnSchemaInRow"));
        this.sortParameters.setDictSortColIdxSchemaOrderMapping(columnIdxMap.get("dictSortIdxBasedOnSchemaInRow"));
        String[] sortTempFileLocation = CarbonDataProcessorUtil.arrayAppend(this.tempStoreLocation, "/", "sortrowtmp");
        this.finalMerger = new SingleThreadFinalSortFilesMerger(sortTempFileLocation, this.tableName, this.sortParameters);
    }

    private void initDataHandler() throws Exception {
        String carbonStoreLocation = this.partitionSpec != null ? this.partitionSpec.getLocation().toString() + "/" + this.carbonLoadModel.getFactTimeStamp() + ".tmp" : CarbonDataProcessorUtil.createCarbonStoreLocation(this.carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable(), this.carbonLoadModel.getSegmentId());
        CarbonFactDataHandlerModel carbonFactDataHandlerModel = CarbonFactDataHandlerModel.getCarbonFactDataHandlerModel(this.carbonLoadModel, this.carbonTable, this.segmentProperties, this.tableName, this.tempStoreLocation, carbonStoreLocation);
        carbonFactDataHandlerModel.setSegmentId(this.carbonLoadModel.getSegmentId());
        carbonFactDataHandlerModel.setBucketId(this.carbonLoadModel.getBucketId());
        this.setDataFileAttributesInModel(this.carbonLoadModel, this.compactionType, carbonFactDataHandlerModel);
        this.noDicAndComplexColumns = carbonFactDataHandlerModel.getNoDictAndComplexColumns();
        this.dataHandler = CarbonFactHandlerFactory.createCarbonFactHandler(carbonFactDataHandlerModel);
        try {
            this.dataHandler.initialise();
        }
        catch (CarbonDataWriterException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Problem initialising data handler during compaction: " + e.getMessage(), e);
        }
    }

    private void initTempStoreLocation() {
        this.tempStoreLocation = CarbonDataProcessorUtil.getLocalDataFolderLocation(this.carbonTable, this.carbonLoadModel.getTaskNo(), this.segmentId, true, false);
    }
}

