/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.sort;

import org.apache.carbondata.processing.loading.row.IntermediateSortTempRow;
import org.apache.carbondata.processing.sort.SortTempRowUpdater;

public class SchemaBasedRowUpdater
implements SortTempRowUpdater {
    private static final long serialVersionUID = -8864989617597611912L;
    private boolean isUpdateDictDims;
    private boolean isUpdateNonDictDims;
    private int[] dictDimActualPosition;
    private int[] noDictActualPosition;

    public SchemaBasedRowUpdater(int[] dictDimActualPosition, int[] noDictActualPosition, boolean isUpdateDictDims, boolean isUpdateNonDictDims) {
        this.dictDimActualPosition = dictDimActualPosition;
        this.noDictActualPosition = noDictActualPosition;
        this.isUpdateDictDims = isUpdateDictDims;
        this.isUpdateNonDictDims = isUpdateNonDictDims;
    }

    @Override
    public void updateSortTempRow(IntermediateSortTempRow intermediateSortTempRow) {
        int[] dictSortDims = intermediateSortTempRow.getDictSortDims();
        if (this.isUpdateDictDims) {
            int[] dimArrayNew = new int[intermediateSortTempRow.getDictSortDims().length];
            for (int i = 0; i < dictSortDims.length; ++i) {
                dimArrayNew[this.dictDimActualPosition[i]] = dictSortDims[i];
            }
            dictSortDims = dimArrayNew;
        }
        Object[] noDictSortDims = intermediateSortTempRow.getNoDictSortDims();
        if (this.isUpdateNonDictDims) {
            Object[] noDictArrayNew = new Object[noDictSortDims.length];
            for (int i = 0; i < noDictArrayNew.length; ++i) {
                noDictArrayNew[this.noDictActualPosition[i]] = noDictSortDims[i];
            }
            noDictSortDims = noDictArrayNew;
        }
        intermediateSortTempRow.setDictData(dictSortDims);
        intermediateSortTempRow.setNoDictData(noDictSortDims);
    }

    @Override
    public void updateOutputRow(Object[] out, int[] dimArray, Object[] noDictArray, Object[] measureArray) {
        int i;
        if (this.isUpdateDictDims) {
            int[] dimArrayNew = new int[dimArray.length];
            for (i = 0; i < dimArray.length; ++i) {
                dimArrayNew[this.dictDimActualPosition[i]] = dimArray[i];
            }
            dimArray = dimArrayNew;
        }
        if (this.isUpdateNonDictDims) {
            Object[] noDictArrayNew = new Object[noDictArray.length];
            for (i = 0; i < noDictArrayNew.length; ++i) {
                noDictArrayNew[this.noDictActualPosition[i]] = noDictArray[i];
            }
            noDictArray = noDictArrayNew;
        }
        out[0] = dimArray;
        out[1] = noDictArray;
        out[2] = measureArray;
    }
}

