/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.sort.sortdata;

import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.core.util.comparator.Comparator;
import org.apache.carbondata.core.util.comparator.SerializableComparator;
import org.apache.carbondata.processing.loading.row.IntermediateSortTempRow;

public class FileMergeSortComparator
implements java.util.Comparator<IntermediateSortTempRow> {
    private DataType[] noDictDataTypes;
    private int[] noDictPrimitiveIndex;
    private int[] noDictSortColIdxSchemaOrderMapping;
    private int[] dictSortColIdxSchemaOrderMapping;

    public FileMergeSortComparator(DataType[] noDictDataTypes, int[] columnIdBasedOnSchemaInRow, int[] noDictSortColIdxSchemaOrderMapping, int[] dictSortColIdxSchemaOrderMapping) {
        this.noDictDataTypes = noDictDataTypes;
        this.noDictPrimitiveIndex = columnIdBasedOnSchemaInRow;
        this.noDictSortColIdxSchemaOrderMapping = noDictSortColIdxSchemaOrderMapping;
        this.dictSortColIdxSchemaOrderMapping = dictSortColIdxSchemaOrderMapping;
    }

    @Override
    public int compare(IntermediateSortTempRow rowA, IntermediateSortTempRow rowB) {
        int i;
        int diff = 0;
        int dictIndex = 0;
        int nonDictIndex = 0;
        int noDicTypeIdx = 0;
        int schemaRowIdx = 0;
        for (i = 0; i < this.noDictSortColIdxSchemaOrderMapping.length; ++i) {
            if (DataTypeUtil.isPrimitiveColumn((DataType)this.noDictDataTypes[this.noDictSortColIdxSchemaOrderMapping[noDicTypeIdx]])) {
                SerializableComparator comparator = Comparator.getComparator((DataType)this.noDictDataTypes[this.noDictSortColIdxSchemaOrderMapping[noDicTypeIdx]]);
                int difference = comparator.compare(rowA.getNoDictSortDims()[this.noDictPrimitiveIndex[schemaRowIdx]], rowB.getNoDictSortDims()[this.noDictPrimitiveIndex[schemaRowIdx]]);
                ++schemaRowIdx;
                if (difference != 0) {
                    return difference;
                }
            } else {
                byte[] byteArr2;
                byte[] byteArr1 = (byte[])rowA.getNoDictSortDims()[this.noDictSortColIdxSchemaOrderMapping[nonDictIndex]];
                int difference = ByteUtil.UnsafeComparer.INSTANCE.compareTo(byteArr1, byteArr2 = (byte[])rowB.getNoDictSortDims()[this.noDictSortColIdxSchemaOrderMapping[nonDictIndex]]);
                if (difference != 0) {
                    return difference;
                }
            }
            ++nonDictIndex;
            ++noDicTypeIdx;
        }
        for (i = 0; i < this.dictSortColIdxSchemaOrderMapping.length; ++i) {
            int dimFieldA = rowA.getDictSortDims()[this.dictSortColIdxSchemaOrderMapping[dictIndex]];
            int dimFieldB = rowB.getDictSortDims()[this.dictSortColIdxSchemaOrderMapping[dictIndex]];
            ++dictIndex;
            diff = dimFieldA - dimFieldB;
            if (diff == 0) continue;
            return diff;
        }
        return diff;
    }
}

