/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.sort.sortdata;

import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.datastore.row.WriteStepRowUtil;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.scan.result.iterator.RawResultIterator;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.processing.loading.row.IntermediateSortTempRow;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;
import org.apache.carbondata.processing.sort.sortdata.SortTempFileChunkHolder;

public class InMemorySortTempChunkHolder
extends SortTempFileChunkHolder {
    private final RawResultIterator rawResultIterator;
    private SegmentProperties segmentProperties;
    private CarbonColumn[] noDicAndComplexColumns;
    private DataType[] measureDataType;

    public InMemorySortTempChunkHolder(RawResultIterator rawResultIterator, SegmentProperties segmentProperties, CarbonColumn[] noDicAndComplexColumns, SortParameters sortParameters, DataType[] measureDataType) {
        super(sortParameters);
        this.rawResultIterator = rawResultIterator;
        this.segmentProperties = segmentProperties;
        this.noDicAndComplexColumns = noDicAndComplexColumns;
        this.measureDataType = measureDataType;
    }

    public void initialise() {
        throw new UnsupportedOperationException("Operation Not supported");
    }

    @Override
    public void readRow() {
        Object[] row = this.rawResultIterator.next();
        CarbonRow carbonRow = WriteStepRowUtil.fromMergerRow((Object[])row, (SegmentProperties)this.segmentProperties, (CarbonColumn[])this.noDicAndComplexColumns);
        Object[] data = carbonRow.getData();
        Object[] measuresValue = (Object[])data[2];
        for (int i = 0; i < measuresValue.length; ++i) {
            measuresValue[i] = this.getConvertedMeasureValue(measuresValue[i], this.measureDataType[i]);
        }
        this.returnRow = new IntermediateSortTempRow((int[])data[0], (Object[])data[1], measuresValue);
    }

    @Override
    public int getEntryCount() {
        throw new UnsupportedOperationException("Operation Not supported");
    }

    @Override
    public boolean hasNext() {
        return this.rawResultIterator.hasNext();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hash = this.rawResultIterator.hashCode();
        return hash += this.segmentProperties.hashCode();
    }

    @Override
    public void closeStream() {
        this.rawResultIterator.close();
    }

    @Override
    public IntermediateSortTempRow getRow() {
        return this.returnRow;
    }

    private Object getConvertedMeasureValue(Object value, DataType type) {
        if (DataTypes.isDecimal((DataType)type)) {
            if (value != null) {
                value = DataTypeUtil.getDataTypeConverter().convertFromDecimalToBigDecimal(value);
            }
            return value;
        }
        return value;
    }
}

