/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.sort.sortdata;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.exception.CarbonDataWriterException;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.scan.result.iterator.RawResultIterator;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.processing.loading.row.IntermediateSortTempRow;
import org.apache.carbondata.processing.loading.sort.CarbonPriorityQueue;
import org.apache.carbondata.processing.loading.sort.SortStepRowHandler;
import org.apache.carbondata.processing.sort.exception.CarbonSortKeyAndGroupByException;
import org.apache.carbondata.processing.sort.sortdata.InMemorySortTempChunkHolder;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;
import org.apache.carbondata.processing.sort.sortdata.SortTempFileChunkHolder;
import org.apache.log4j.Logger;

public class SingleThreadFinalSortFilesMerger
extends CarbonIterator<Object[]> {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)SingleThreadFinalSortFilesMerger.class.getName());
    private static final Object LOCKOBJECT = new Object();
    private CarbonPriorityQueue<SortTempFileChunkHolder> recordHolderHeapLocal;
    private String tableName;
    private SortParameters sortParameters;
    private SortStepRowHandler sortStepRowHandler;
    private String[] tempFileLocation;
    private int maxThreadForSorting;
    private ExecutorService executorService;
    private List<Future<Void>> mergerTask;

    public SingleThreadFinalSortFilesMerger(String[] tempFileLocation, String tableName, SortParameters sortParameters) {
        this.tempFileLocation = tempFileLocation;
        this.tableName = tableName;
        this.sortParameters = sortParameters;
        this.sortStepRowHandler = new SortStepRowHandler(sortParameters);
        try {
            this.maxThreadForSorting = Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.merge.sort.reader.thread", "3"));
        }
        catch (NumberFormatException e) {
            this.maxThreadForSorting = Integer.parseInt("3");
        }
        this.mergerTask = new ArrayList<Future<Void>>();
    }

    public void startFinalMerge() throws CarbonDataWriterException {
        List<File> filesToMerge = this.getFilesToMergeSort();
        if (filesToMerge.size() == 0) {
            LOGGER.info((Object)"No file to merge in final merge stage");
            return;
        }
        this.startSorting(filesToMerge);
    }

    public void addInMemoryRawResultIterator(List<RawResultIterator> sortedRawResultMergerList, SegmentProperties segmentProperties, CarbonColumn[] noDicAndComplexColumns, DataType[] measureDataType) {
        for (RawResultIterator rawResultIterator : sortedRawResultMergerList) {
            InMemorySortTempChunkHolder inMemorySortTempChunkHolder = new InMemorySortTempChunkHolder(rawResultIterator, segmentProperties, noDicAndComplexColumns, this.sortParameters, measureDataType);
            if (!inMemorySortTempChunkHolder.hasNext()) continue;
            inMemorySortTempChunkHolder.readRow();
            this.recordHolderHeapLocal.add(inMemorySortTempChunkHolder);
        }
    }

    private List<File> getFilesToMergeSort() {
        final int rangeId = this.sortParameters.getRangeId();
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith(SingleThreadFinalSortFilesMerger.this.tableName + '_' + rangeId);
            }
        };
        ArrayList<File> files = new ArrayList<File>(this.tempFileLocation.length);
        for (String tempLoc : this.tempFileLocation) {
            File[] subFiles = new File(tempLoc).listFiles(fileFilter);
            if (null == subFiles || subFiles.length <= 0) continue;
            files.addAll(Arrays.asList(subFiles));
        }
        return files;
    }

    private void startSorting(List<File> files) throws CarbonDataWriterException {
        if (files.size() == 0) {
            LOGGER.info((Object)"No files to merge sort");
            return;
        }
        LOGGER.info((Object)"Started Final Merge");
        LOGGER.info((Object)("Number of temp file: " + files.size()));
        this.createRecordHolderQueue(files.size());
        LOGGER.info((Object)"Started adding first record from each file");
        this.executorService = Executors.newFixedThreadPool(this.maxThreadForSorting);
        for (final File tempFile : files) {
            Callable<Void> callable = new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() {
                    SortTempFileChunkHolder sortTempFileChunkHolder = new SortTempFileChunkHolder(tempFile, SingleThreadFinalSortFilesMerger.this.sortParameters, SingleThreadFinalSortFilesMerger.this.tableName, true);
                    try {
                        sortTempFileChunkHolder.initialize();
                        sortTempFileChunkHolder.readRow();
                    }
                    catch (CarbonSortKeyAndGroupByException ex) {
                        sortTempFileChunkHolder.closeStream();
                        SingleThreadFinalSortFilesMerger.this.notifyFailure(ex);
                    }
                    Object object = LOCKOBJECT;
                    synchronized (object) {
                        SingleThreadFinalSortFilesMerger.this.recordHolderHeapLocal.add(sortTempFileChunkHolder);
                    }
                    return null;
                }
            };
            this.mergerTask.add(this.executorService.submit(callable));
        }
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(2L, TimeUnit.HOURS);
        }
        catch (Exception e) {
            throw new CarbonDataWriterException((Throwable)e);
        }
        this.checkFailure();
        LOGGER.info((Object)("final merger Heap Size" + this.recordHolderHeapLocal.size()));
    }

    private void checkFailure() {
        for (int i = 0; i < this.mergerTask.size(); ++i) {
            try {
                this.mergerTask.get(i).get();
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new CarbonDataWriterException((Throwable)e);
            }
        }
    }

    private void createRecordHolderQueue(int size) {
        this.recordHolderHeapLocal = new CarbonPriorityQueue(size);
    }

    private synchronized void notifyFailure(Throwable throwable) {
        this.close();
        LOGGER.error((Object)throwable);
    }

    public Object[] next() {
        if (this.hasNext()) {
            IntermediateSortTempRow sortTempRow = this.getSortedRecordFromFile();
            return this.sortStepRowHandler.convertIntermediateSortTempRowTo3Parted(sortTempRow);
        }
        throw new NoSuchElementException("No more elements to return");
    }

    private IntermediateSortTempRow getSortedRecordFromFile() throws CarbonDataWriterException {
        IntermediateSortTempRow row = null;
        SortTempFileChunkHolder poll = (SortTempFileChunkHolder)this.recordHolderHeapLocal.peek();
        row = poll.getRow();
        if (!poll.hasNext()) {
            poll.closeStream();
            this.recordHolderHeapLocal.poll();
            return row;
        }
        try {
            poll.readRow();
        }
        catch (CarbonSortKeyAndGroupByException e) {
            this.close();
            throw new CarbonDataWriterException((Throwable)e);
        }
        this.recordHolderHeapLocal.siftTopDown();
        return row;
    }

    public boolean hasNext() {
        return this.recordHolderHeapLocal != null && this.recordHolderHeapLocal.size() > 0;
    }

    public void close() {
        if (null != this.executorService && !this.executorService.isShutdown()) {
            this.executorService.shutdownNow();
        }
        if (null != this.recordHolderHeapLocal) {
            while (!this.recordHolderHeapLocal.isEmpty()) {
                SortTempFileChunkHolder sortTempFileChunkHolder = (SortTempFileChunkHolder)this.recordHolderHeapLocal.poll();
                if (null == sortTempFileChunkHolder) continue;
                sortTempFileChunkHolder.closeStream();
            }
        }
    }
}

