/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.sort.sortdata;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.ReUsableByteArrayDataOutputStream;
import org.apache.carbondata.processing.loading.sort.SortStepRowHandler;
import org.apache.carbondata.processing.sort.exception.CarbonSortKeyAndGroupByException;
import org.apache.carbondata.processing.sort.sortdata.NewRowComparator;
import org.apache.carbondata.processing.sort.sortdata.NewRowComparatorForNormalDims;
import org.apache.carbondata.processing.sort.sortdata.SortIntermediateFileMerger;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;
import org.apache.log4j.Logger;

public class SortDataRows {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)SortDataRows.class.getName());
    private int entryCount;
    private Object[][] recordHolderList;
    private ThreadStatusObserver threadStatusObserver;
    private SortParameters parameters;
    private SortStepRowHandler sortStepRowHandler;
    private ThreadLocal<ReUsableByteArrayDataOutputStream> reUsableByteArrayDataOutputStream;
    private int sortBufferSize;
    private int instanceId;
    private SortIntermediateFileMerger intermediateFileMerger;

    public SortDataRows(SortParameters parameters, SortIntermediateFileMerger intermediateFileMerger) {
        this.parameters = parameters;
        this.sortStepRowHandler = new SortStepRowHandler(parameters);
        this.intermediateFileMerger = intermediateFileMerger;
        int batchSize = CarbonProperties.getInstance().getBatchSize();
        this.sortBufferSize = Math.max(parameters.getSortBufferSize(), batchSize);
        this.threadStatusObserver = new ThreadStatusObserver();
        this.reUsableByteArrayDataOutputStream = new ThreadLocal<ReUsableByteArrayDataOutputStream>(){

            @Override
            protected ReUsableByteArrayDataOutputStream initialValue() {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                return new ReUsableByteArrayDataOutputStream(byteStream);
            }
        };
    }

    public void initialize() {
        this.recordHolderList = new Object[this.sortBufferSize][];
    }

    public void setInstanceId(int instanceId) {
        this.instanceId = instanceId;
    }

    public void addRow(Object[] row) throws CarbonSortKeyAndGroupByException {
        int currentSize = this.entryCount;
        if (this.sortBufferSize == currentSize) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"************ Writing to temp file ********** ");
            }
            Object[][] recordHolderListLocal = this.recordHolderList;
            this.handlePreviousPage(recordHolderListLocal);
            this.recordHolderList = new Object[this.sortBufferSize][];
            this.entryCount = 0;
        }
        this.recordHolderList[this.entryCount++] = row;
    }

    public void addRowBatch(Object[][] rowBatch, int size) throws CarbonSortKeyAndGroupByException {
        int sizeLeft = 0;
        if (this.entryCount + size >= this.sortBufferSize) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"************ Writing to temp file ********** ");
            }
            Object[][] recordHolderListLocal = this.recordHolderList;
            sizeLeft = this.sortBufferSize - this.entryCount;
            if (sizeLeft > 0) {
                System.arraycopy(rowBatch, 0, recordHolderListLocal, this.entryCount, sizeLeft);
            }
            this.handlePreviousPage(recordHolderListLocal);
            this.recordHolderList = new Object[this.sortBufferSize][];
            this.entryCount = 0;
            if ((size -= sizeLeft) == 0) {
                return;
            }
        }
        System.arraycopy(rowBatch, sizeLeft, this.recordHolderList, this.entryCount, size);
        this.entryCount += size;
    }

    private void handlePreviousPage(Object[][] recordHolderArray) throws CarbonSortKeyAndGroupByException {
        try {
            long startTime = System.currentTimeMillis();
            if (this.parameters.getNumberOfNoDictSortColumns() > 0) {
                Arrays.sort(recordHolderArray, new NewRowComparator(this.parameters.getNoDictionarySortColumn(), this.parameters.getNoDictDataType()));
            } else {
                Arrays.sort(recordHolderArray, new NewRowComparatorForNormalDims(this.parameters.getNumberOfSortColumns()));
            }
            String[] tmpFileLocation = this.parameters.getTempFileLocation();
            String locationChosen = tmpFileLocation[new Random().nextInt(tmpFileLocation.length)];
            File sortTempFile = new File(locationChosen + File.separator + this.parameters.getTableName() + '_' + this.parameters.getRangeId() + '_' + this.instanceId + '_' + System.nanoTime() + ".sorttemp");
            this.writeDataToFile(recordHolderArray, recordHolderArray.length, sortTempFile);
            this.intermediateFileMerger.addFileToMerge(sortTempFile);
            LOGGER.info((Object)("Time taken to sort and write sort temp file " + sortTempFile + " is: " + (System.currentTimeMillis() - startTime) + ", sort temp file size in MB is " + (double)sortTempFile.length() * 0.1 * 10.0 / 1024.0 / 1024.0));
        }
        catch (Throwable e) {
            this.threadStatusObserver.notifyFailed(e);
        }
    }

    public void startSorting() throws CarbonSortKeyAndGroupByException {
        LOGGER.info((Object)"File based sorting will be used");
        if (this.entryCount > 0) {
            Object[][] toSort = new Object[this.entryCount][];
            System.arraycopy(this.recordHolderList, 0, toSort, 0, this.entryCount);
            if (this.parameters.getNumberOfNoDictSortColumns() > 0) {
                Arrays.sort(toSort, new NewRowComparator(this.parameters.getNoDictionarySortColumn(), this.parameters.getNoDictDataType()));
            } else {
                Arrays.sort(toSort, new NewRowComparatorForNormalDims(this.parameters.getNumberOfSortColumns()));
            }
            this.recordHolderList = toSort;
            String[] tmpLocation = this.parameters.getTempFileLocation();
            String locationChosen = tmpLocation[new Random().nextInt(tmpLocation.length)];
            File file = new File(locationChosen + File.separator + this.parameters.getTableName() + '_' + this.parameters.getRangeId() + '_' + this.instanceId + '_' + System.nanoTime() + ".sorttemp");
            this.writeDataToFile(this.recordHolderList, this.entryCount, file);
        }
        this.recordHolderList = null;
    }

    private void writeDataToFile(Object[][] recordHolderList, int entryCountLocal, File file) throws CarbonSortKeyAndGroupByException {
        DataOutputStream stream = null;
        try {
            stream = FileFactory.getDataOutputStream((String)file.getPath(), (int)this.parameters.getFileWriteBufferSize(), (String)this.parameters.getSortTempCompressorName());
            stream.writeInt(entryCountLocal);
            for (int i = 0; i < entryCountLocal; ++i) {
                this.sortStepRowHandler.writeRawRowAsIntermediateSortTempRowToOutputStream(recordHolderList[i], stream, this.reUsableByteArrayDataOutputStream.get());
            }
        }
        catch (IOException e) {
            try {
                throw new CarbonSortKeyAndGroupByException("Problem while writing the file", e);
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams((Closeable[])new Closeable[]{stream});
                throw throwable;
            }
        }
        CarbonUtil.closeStreams((Closeable[])new Closeable[]{stream});
    }

    public void close() {
        this.intermediateFileMerger.close();
    }

    private class ThreadStatusObserver {
        private ThreadStatusObserver() {
        }

        public void notifyFailed(Throwable exception) throws CarbonSortKeyAndGroupByException {
            SortDataRows.this.close();
            SortDataRows.this.parameters.getObserver().setFailed(true);
            LOGGER.error((Object)exception);
            throw new CarbonSortKeyAndGroupByException(exception);
        }
    }
}

