/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.sort.sortdata;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.util.CarbonThreadFactory;
import org.apache.carbondata.processing.sort.exception.CarbonSortKeyAndGroupByException;
import org.apache.carbondata.processing.sort.sortdata.IntermediateFileMerger;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;
import org.apache.log4j.Logger;

public class SortIntermediateFileMerger {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)SortIntermediateFileMerger.class.getName());
    private ExecutorService executorService;
    private List<File> procFiles;
    private SortParameters parameters;
    private final Object lockObject = new Object();
    private List<Future<Void>> mergerTask;

    public SortIntermediateFileMerger(SortParameters parameters) {
        this.parameters = parameters;
        this.procFiles = new ArrayList<File>(10);
        this.executorService = Executors.newFixedThreadPool(parameters.getNumberOfCores(), (ThreadFactory)new CarbonThreadFactory("SafeIntermediateMergerPool:" + parameters.getTableName(), true));
        this.mergerTask = new ArrayList<Future<Void>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileToMerge(File sortTempFile) {
        Object object = this.lockObject;
        synchronized (object) {
            this.procFiles.add(sortTempFile);
            if (this.procFiles.size() >= this.parameters.getNumberOfIntermediateFileToBeMerged()) {
                File[] fileList = this.procFiles.toArray(new File[this.procFiles.size()]);
                this.procFiles = new ArrayList<File>();
                this.startIntermediateMerging(fileList);
            }
        }
    }

    private void startIntermediateMerging(File[] intermediateFiles) {
        int index = new Random().nextInt(this.parameters.getTempFileLocation().length);
        String chosenTempDir = this.parameters.getTempFileLocation()[index];
        File file = new File(chosenTempDir + File.separator + this.parameters.getTableName() + '_' + this.parameters.getRangeId() + '_' + System.nanoTime() + ".merge");
        IntermediateFileMerger merger = new IntermediateFileMerger(this.parameters, intermediateFiles, file);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Submitting request for intermediate merging number of files: " + intermediateFiles.length));
        }
        this.mergerTask.add(this.executorService.submit(merger));
    }

    public void finish() throws CarbonSortKeyAndGroupByException {
        try {
            this.executorService.shutdown();
            this.executorService.awaitTermination(2L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new CarbonSortKeyAndGroupByException("Problem while shutdown the server ", e);
        }
        this.procFiles.clear();
        this.procFiles = null;
        this.checkForFailure();
    }

    private void checkForFailure() throws CarbonSortKeyAndGroupByException {
        for (int i = 0; i < this.mergerTask.size(); ++i) {
            try {
                this.mergerTask.get(i).get();
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                throw new CarbonSortKeyAndGroupByException(e);
            }
        }
    }

    public void close() {
        if (!this.executorService.isShutdown()) {
            this.executorService.shutdownNow();
        }
    }
}

