/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.sort.sortdata;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.sort.sortdata.SortObserver;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SortParameters
implements Serializable {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)SortParameters.class.getName());
    private String[] tempFileLocation;
    private int sortBufferSize;
    private int measureColCount;
    private int dimColCount;
    private int complexDimColCount;
    private int fileBufferSize;
    private int numberOfIntermediateFileToBeMerged;
    private int fileWriteBufferSize;
    private SortObserver observer;
    private String sortTempCompressorName;
    private boolean prefetch;
    private int bufferSize;
    private String databaseName;
    private String tableName;
    private DataType[] measureDataType;
    private DataType[] noDictDataType;
    private DataType[] noDictSortDataType;
    private DataType[] noDictNoSortDataType;
    private DataType[] noDictSchemaDataType;
    private int noDictionaryCount;
    private String partitionID;
    private String segmentId;
    private String taskNo;
    private boolean[] noDictionarySortColumn;
    private boolean[] sortColumn;
    private boolean[] isVarcharDimensionColumn;
    private int numberOfSortColumns;
    private int numberOfNoDictSortColumns;
    private int numberOfCores;
    private int rangeId = 0;
    private CarbonTable carbonTable;
    private boolean isUpdateDictDims;
    private boolean isUpdateNonDictDims;
    private int[] dictDimActualPosition;
    private int[] noDictActualPosition;
    private int[] noDictSortColumnSchemaOrderMapping;
    private int[] noDictSortColIdxSchemaOrderMapping;
    private int[] dictSortColIdxSchemaOrderMapping;
    private boolean isInsertWithoutReArrangeFlow;
    private int noDictSortDimCnt;
    private int dictSortDimCnt;
    private int[] changedOrderInDataField;

    public SortParameters getCopy() {
        SortParameters parameters = new SortParameters();
        parameters.tempFileLocation = this.tempFileLocation;
        parameters.sortBufferSize = this.sortBufferSize;
        parameters.measureColCount = this.measureColCount;
        parameters.dimColCount = this.dimColCount;
        parameters.complexDimColCount = this.complexDimColCount;
        parameters.fileBufferSize = this.fileBufferSize;
        parameters.numberOfIntermediateFileToBeMerged = this.numberOfIntermediateFileToBeMerged;
        parameters.fileWriteBufferSize = this.fileWriteBufferSize;
        parameters.observer = this.observer;
        parameters.sortTempCompressorName = this.sortTempCompressorName;
        parameters.prefetch = this.prefetch;
        parameters.bufferSize = this.bufferSize;
        parameters.databaseName = this.databaseName;
        parameters.tableName = this.tableName;
        parameters.measureDataType = this.measureDataType;
        parameters.noDictDataType = this.noDictDataType;
        parameters.noDictSortDataType = this.noDictSortDataType;
        parameters.noDictNoSortDataType = this.noDictNoSortDataType;
        parameters.noDictionaryCount = this.noDictionaryCount;
        parameters.partitionID = this.partitionID;
        parameters.segmentId = this.segmentId;
        parameters.taskNo = this.taskNo;
        parameters.sortColumn = this.sortColumn;
        parameters.isVarcharDimensionColumn = this.isVarcharDimensionColumn;
        parameters.noDictionarySortColumn = this.noDictionarySortColumn;
        parameters.numberOfSortColumns = this.numberOfSortColumns;
        parameters.numberOfNoDictSortColumns = this.numberOfNoDictSortColumns;
        parameters.numberOfCores = this.numberOfCores;
        parameters.rangeId = this.rangeId;
        parameters.carbonTable = this.carbonTable;
        parameters.isUpdateDictDims = this.isUpdateDictDims;
        parameters.isUpdateNonDictDims = this.isUpdateNonDictDims;
        parameters.dictDimActualPosition = this.dictDimActualPosition;
        parameters.noDictActualPosition = this.noDictActualPosition;
        parameters.noDictSortColumnSchemaOrderMapping = this.noDictSortColumnSchemaOrderMapping;
        parameters.isInsertWithoutReArrangeFlow = this.isInsertWithoutReArrangeFlow;
        parameters.noDictSchemaDataType = this.noDictSchemaDataType;
        parameters.noDictSortColIdxSchemaOrderMapping = this.noDictSortColIdxSchemaOrderMapping;
        parameters.dictSortColIdxSchemaOrderMapping = this.dictSortColIdxSchemaOrderMapping;
        parameters.noDictSortDimCnt = this.noDictSortDimCnt;
        parameters.dictSortDimCnt = this.dictSortDimCnt;
        parameters.changedOrderInDataField = this.changedOrderInDataField;
        return parameters;
    }

    public String[] getTempFileLocation() {
        return this.tempFileLocation;
    }

    public void setTempFileLocation(String[] tempFileLocation) {
        this.tempFileLocation = tempFileLocation;
    }

    public int getSortBufferSize() {
        return this.sortBufferSize;
    }

    public void setSortBufferSize(int sortBufferSize) {
        this.sortBufferSize = sortBufferSize;
    }

    public int getMeasureColCount() {
        return this.measureColCount;
    }

    public void setMeasureColCount(int measureColCount) {
        this.measureColCount = measureColCount;
    }

    public int getDimColCount() {
        return this.dimColCount;
    }

    public void setDimColCount(int dimColCount) {
        this.dimColCount = dimColCount;
    }

    public int getComplexDimColCount() {
        return this.complexDimColCount;
    }

    public void setComplexDimColCount(int complexDimColCount) {
        this.complexDimColCount = complexDimColCount;
    }

    public int getNumberOfIntermediateFileToBeMerged() {
        return this.numberOfIntermediateFileToBeMerged;
    }

    public void setNumberOfIntermediateFileToBeMerged(int numberOfIntermediateFileToBeMerged) {
        this.numberOfIntermediateFileToBeMerged = numberOfIntermediateFileToBeMerged;
    }

    public int getFileWriteBufferSize() {
        return this.fileWriteBufferSize;
    }

    public void setFileWriteBufferSize(int fileWriteBufferSize) {
        this.fileWriteBufferSize = fileWriteBufferSize;
    }

    public SortObserver getObserver() {
        return this.observer;
    }

    public void setObserver(SortObserver observer) {
        this.observer = observer;
    }

    public String getSortTempCompressorName() {
        return this.sortTempCompressorName;
    }

    public void setSortTempCompressorName(String sortTempCompressorName) {
        this.sortTempCompressorName = sortTempCompressorName;
    }

    public boolean isPrefetch() {
        return this.prefetch;
    }

    public void setPrefetch(boolean prefetch) {
        this.prefetch = prefetch;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public DataType[] getMeasureDataType() {
        return this.measureDataType;
    }

    public void setMeasureDataType(DataType[] measureDataType) {
        this.measureDataType = measureDataType;
    }

    public int getNoDictionaryCount() {
        return this.noDictionaryCount;
    }

    public void setNoDictionaryCount(int noDictionaryCount) {
        this.noDictionaryCount = noDictionaryCount;
    }

    public String getPartitionID() {
        return this.partitionID;
    }

    public void setPartitionID(String partitionID) {
        this.partitionID = partitionID;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public void setSegmentId(String segmentId) {
        this.segmentId = segmentId;
    }

    public String getTaskNo() {
        return this.taskNo;
    }

    public void setTaskNo(String taskNo) {
        this.taskNo = taskNo;
    }

    public void setNoDictSortDimCnt(int noDictSortDimCnt) {
        this.noDictSortDimCnt = noDictSortDimCnt;
    }

    public int getNoDictSortDimCnt() {
        return this.noDictSortDimCnt;
    }

    public void setDictSortDimCnt(int dictSortDimCnt) {
        this.dictSortDimCnt = dictSortDimCnt;
    }

    public int getDictSortDimCnt() {
        return this.dictSortDimCnt;
    }

    public boolean[] getIsVarcharDimensionColumn() {
        return this.isVarcharDimensionColumn;
    }

    public void setIsVarcharDimensionColumn(boolean[] isVarcharDimensionColumn) {
        this.isVarcharDimensionColumn = isVarcharDimensionColumn;
    }

    public int getNumberOfCores() {
        return this.numberOfCores;
    }

    public void setNumberOfCores(int numberOfCores) {
        this.numberOfCores = numberOfCores;
    }

    public int getNumberOfSortColumns() {
        return this.numberOfSortColumns;
    }

    public void setNumberOfSortColumns(int numberOfSortColumns) {
        this.numberOfSortColumns = Math.min(numberOfSortColumns, this.dimColCount);
    }

    public boolean[] getNoDictionarySortColumn() {
        return this.noDictionarySortColumn;
    }

    public void setNoDictionarySortColumn(boolean[] noDictionarySortColumn) {
        this.noDictionarySortColumn = noDictionarySortColumn;
    }

    public int getNumberOfNoDictSortColumns() {
        return this.numberOfNoDictSortColumns;
    }

    public void setNumberOfNoDictSortColumns(int numberOfNoDictSortColumns) {
        this.numberOfNoDictSortColumns = Math.min(numberOfNoDictSortColumns, this.noDictionaryCount);
    }

    public void setCarbonTable(CarbonTable carbonTable) {
        this.carbonTable = carbonTable;
    }

    public CarbonTable getCarbonTable() {
        return this.carbonTable;
    }

    int[] getNoDictSortColumnSchemaOrderMapping() {
        return this.noDictSortColumnSchemaOrderMapping;
    }

    public void setNoDictSortColumnSchemaOrderMapping(int[] noDictSortColumnSchemaOrderMapping) {
        this.noDictSortColumnSchemaOrderMapping = noDictSortColumnSchemaOrderMapping;
    }

    public boolean isInsertWithoutReArrangeFlow() {
        return this.isInsertWithoutReArrangeFlow;
    }

    public void setInsertWithoutReArrangeFlow(boolean insertWithoutReArrangeFlow) {
        this.isInsertWithoutReArrangeFlow = insertWithoutReArrangeFlow;
    }

    public void setSortDictAndNoDictDimCnt(DataField[] dataFields) {
        int noDictSortDimCnt = this.getNoDictSortDimCnt();
        int dictSortDimCnt = this.getDictSortDimCnt();
        for (DataField field : dataFields) {
            if (!field.isDateDataType() && field.getColumn().isDimension().booleanValue() && field.getColumn().getColumnSchema().isSortColumn()) {
                ++noDictSortDimCnt;
                continue;
            }
            if (!field.getColumn().isDimension().booleanValue() || !field.getColumn().getColumnSchema().isSortColumn()) continue;
            ++dictSortDimCnt;
        }
        this.setNoDictSortDimCnt(noDictSortDimCnt);
        this.setDictSortDimCnt(dictSortDimCnt);
    }

    public int[] getChangedOrderInDataField() {
        return this.changedOrderInDataField;
    }

    public static SortParameters createSortParameters(CarbonDataLoadConfiguration configuration) {
        SortParameters parameters = new SortParameters();
        CarbonTableIdentifier tableIdentifier = configuration.getTableIdentifier().getCarbonTableIdentifier();
        CarbonProperties carbonProperties = CarbonProperties.getInstance();
        parameters.setCarbonTable(configuration.getTableSpec().getCarbonTable());
        parameters.setDatabaseName(tableIdentifier.getDatabaseName());
        parameters.setTableName(tableIdentifier.getTableName());
        parameters.setPartitionID("0");
        parameters.setSegmentId(configuration.getSegmentId());
        parameters.setTaskNo(configuration.getTaskNo());
        parameters.setMeasureColCount(configuration.getMeasureCount());
        parameters.setDimColCount(configuration.getDimensionCount() - (configuration.getComplexDictionaryColumnCount() + configuration.getComplexNonDictionaryColumnCount()));
        parameters.setNoDictionaryCount(configuration.getNoDictionaryCount());
        parameters.setComplexDimColCount(configuration.getComplexDictionaryColumnCount() + configuration.getComplexNonDictionaryColumnCount());
        parameters.setSortDictAndNoDictDimCnt(configuration.getDataFields());
        parameters.setIsVarcharDimensionColumn(CarbonDataProcessorUtil.getIsVarcharColumnMapping(configuration.getDataFields()));
        parameters.setNumberOfSortColumns(configuration.getNumberOfSortColumns());
        parameters.setNumberOfNoDictSortColumns(configuration.getNumberOfNoDictSortColumns());
        parameters.setSortColumn(configuration.getSortColumnMapping());
        parameters.setObserver(new SortObserver());
        parameters.setSortBufferSize(Integer.parseInt(carbonProperties.getProperty("carbon.sort.size", "100000")));
        LOGGER.info((Object)("Sort size for table: " + parameters.getSortBufferSize()));
        parameters.setNumberOfIntermediateFileToBeMerged(Integer.parseInt(carbonProperties.getProperty("carbon.sort.intermediate.files.limit", "20")));
        LOGGER.info((Object)("Number of intermediate file to be merged: " + parameters.getNumberOfIntermediateFileToBeMerged()));
        String[] carbonDataDirectoryPath = CarbonDataProcessorUtil.getLocalDataFolderLocation(parameters.getCarbonTable(), configuration.getTaskNo(), configuration.getSegmentId(), false, false);
        String[] sortTempDirs = CarbonDataProcessorUtil.arrayAppend(carbonDataDirectoryPath, File.separator, "sortrowtmp");
        parameters.setTempFileLocation(sortTempDirs);
        LOGGER.info((Object)("temp file location: " + StringUtils.join((Object[])parameters.getTempFileLocation(), (String)",")));
        int numberOfCores = 1;
        numberOfCores = configuration.getWritingCoresCount() > 0 ? configuration.getWritingCoresCount() : configuration.getNumberOfLoadingCores() / 2;
        parameters.setNumberOfCores(numberOfCores > 0 ? numberOfCores : 1);
        parameters.setFileWriteBufferSize(Integer.parseInt(carbonProperties.getProperty("carbon.sort.file.write.buffer.size", "16384")));
        parameters.setSortTempCompressorName(CarbonProperties.getInstance().getSortTempCompressor());
        if (!parameters.sortTempCompressorName.isEmpty()) {
            LOGGER.info((Object)(" Compression " + parameters.sortTempCompressorName + " will be used for writing the sort temp File"));
        }
        parameters.setPrefetch(false);
        parameters.setBufferSize(Integer.parseInt(carbonProperties.getProperty("carbon.prefetch.buffersize", "1000")));
        if (configuration.getDataLoadProperty("NO_REARRANGE_OF_ROWS") != null && configuration.getTableSpec().getCarbonTable().getPartitionInfo() != null) {
            parameters.setInsertWithoutReArrangeFlow(true);
            parameters.setNoDictionarySortColumn(CarbonDataProcessorUtil.getNoDictSortColMappingAsDataFieldOrder(configuration.getDataFields()));
            Map<String, int[]> columnIdxMap = CarbonDataProcessorUtil.getColumnIdxBasedOnSchemaInRowAsDataFieldOrder(configuration.getDataFields());
            parameters.setNoDictSortColumnSchemaOrderMapping(columnIdxMap.get("columnIdxBasedOnSchemaInRow"));
            parameters.setNoDictSortColIdxSchemaOrderMapping(columnIdxMap.get("noDictSortIdxBasedOnSchemaInRow"));
            parameters.setDictSortColIdxSchemaOrderMapping(columnIdxMap.get("dictSortIdxBasedOnSchemaInRow"));
            parameters.setNoDictSchemaDataType(CarbonDataProcessorUtil.getNoDictDataTypesAsDataFieldOrder(configuration.getDataFields()));
            parameters.setMeasureDataType(configuration.getMeasureDataTypeAsDataFieldOrder());
            DataField[] changeDataFields = SortParameters.changeDataFieldForSortAndPartition(configuration);
            parameters.changedOrderInDataField = SortParameters.getChangedSchemaOrder(configuration.getDataFields(), changeDataFields);
            parameters.setNoDictDataType(CarbonDataProcessorUtil.getNoDictSortDataTypesAsDataFieldOrder(configuration.getDataFields()));
            Map<String, DataType[]> noDictSortAndNoSortDataTypes = CarbonDataProcessorUtil.getNoDictSortAndNoSortDataTypes(changeDataFields);
            parameters.setNoDictSortDataType(noDictSortAndNoSortDataTypes.get("noDictSortDataTypes"));
            parameters.setNoDictNoSortDataType(noDictSortAndNoSortDataTypes.get("noDictNoSortDataTypes"));
            TableSpec tableSpec = new TableSpec(configuration.getTableSpec().getCarbonTable(), true);
            parameters.setNoDictActualPosition(tableSpec.getNoDictDimActualPosition());
            parameters.setDictDimActualPosition(tableSpec.getDictDimActualPosition());
            parameters.setUpdateDictDims(tableSpec.isUpdateDictDim());
            parameters.setUpdateNonDictDims(tableSpec.isUpdateNoDictDims());
        } else {
            parameters.setNoDictionarySortColumn(CarbonDataProcessorUtil.getNoDictSortColMapping(parameters.getCarbonTable()));
            Map<String, int[]> columnIdxMap = CarbonDataProcessorUtil.getColumnIdxBasedOnSchemaInRow(parameters.getCarbonTable());
            parameters.setNoDictSortColumnSchemaOrderMapping(columnIdxMap.get("columnIdxBasedOnSchemaInRow"));
            parameters.setNoDictSortColIdxSchemaOrderMapping(columnIdxMap.get("noDictSortIdxBasedOnSchemaInRow"));
            parameters.setDictSortColIdxSchemaOrderMapping(columnIdxMap.get("dictSortIdxBasedOnSchemaInRow"));
            parameters.setMeasureDataType(configuration.getMeasureDataType());
            parameters.setNoDictDataType(CarbonDataProcessorUtil.getNoDictSortDataTypes(configuration.getTableSpec().getCarbonTable()));
            parameters.setNoDictSchemaDataType(CarbonDataProcessorUtil.getNoDictDataTypes(parameters.carbonTable));
            Map<String, DataType[]> noDictSortAndNoSortDataTypes = CarbonDataProcessorUtil.getNoDictSortAndNoSortDataTypes(configuration.getTableSpec().getCarbonTable());
            parameters.setNoDictSortDataType(noDictSortAndNoSortDataTypes.get("noDictSortDataTypes"));
            parameters.setNoDictNoSortDataType(noDictSortAndNoSortDataTypes.get("noDictNoSortDataTypes"));
            TableSpec tableSpec = configuration.getTableSpec();
            parameters.setNoDictActualPosition(tableSpec.getNoDictDimActualPosition());
            parameters.setDictDimActualPosition(tableSpec.getDictDimActualPosition());
            parameters.setUpdateDictDims(tableSpec.isUpdateDictDim());
            parameters.setUpdateNonDictDims(tableSpec.isUpdateNoDictDims());
        }
        return parameters;
    }

    private static DataField[] changeDataFieldForSortAndPartition(CarbonDataLoadConfiguration configuration) {
        DataField[] dataFields = configuration.getDataFields();
        CarbonTable carbonTable = configuration.getTableSpec().getCarbonTable();
        String[] sortColumns = carbonTable.getTableInfo().getFactTable().getTableProperties().getOrDefault("sort_columns", "").split(",");
        DataField[] changedDataField = new DataField[dataFields.length];
        int i = 0;
        for (String col : sortColumns) {
            for (DataField dataField : dataFields) {
                if (!dataField.getColumn().getColName().equalsIgnoreCase(col)) continue;
                changedDataField[i++] = dataField;
            }
        }
        for (DataField dataField : dataFields) {
            if (dataField.getColumn().getColumnSchema().isSortColumn()) continue;
            changedDataField[i++] = dataField;
        }
        return changedDataField;
    }

    private static int[] getChangedSchemaOrder(DataField[] dataFields, DataField[] changedDataFields) {
        int[] changedDataFieldOrder = new int[dataFields.length];
        boolean isChanged = false;
        block0: for (int i = 0; i < changedDataFields.length; ++i) {
            for (int j = 0; j < dataFields.length; ++j) {
                if (!dataFields[j].getColumn().getColName().equalsIgnoreCase(changedDataFields[i].getColumn().getColName())) continue;
                changedDataFieldOrder[i] = j;
                if (i == j) continue block0;
                isChanged = true;
                continue block0;
            }
        }
        return (int[])(isChanged ? changedDataFieldOrder : null);
    }

    public int getRangeId() {
        return this.rangeId;
    }

    public void setRangeId(int rangeId) {
        this.rangeId = rangeId;
    }

    public static SortParameters createSortParameters(CarbonTable carbonTable, String databaseName, String tableName, int dimColCount, int complexDimColCount, int measureColCount, int noDictionaryCount, String segmentId, String taskNo, boolean[] noDictionaryColMaping, boolean[] sortColumnMapping, boolean[] isVarcharDimensionColumn, boolean isCompactionFlow, int numberOfCores) {
        SortParameters parameters = new SortParameters();
        CarbonProperties carbonProperties = CarbonProperties.getInstance();
        parameters.setCarbonTable(carbonTable);
        parameters.setDatabaseName(databaseName);
        parameters.setTableName(tableName);
        parameters.setPartitionID("0");
        parameters.setSegmentId(segmentId);
        parameters.setTaskNo(taskNo);
        parameters.setMeasureColCount(measureColCount);
        parameters.setDimColCount(dimColCount);
        parameters.setNumberOfSortColumns(carbonTable.getNumberOfSortColumns());
        parameters.setNoDictionaryCount(noDictionaryCount);
        parameters.setNumberOfNoDictSortColumns(carbonTable.getNumberOfNoDictSortColumns());
        parameters.setComplexDimColCount(complexDimColCount);
        parameters.setSortColumn(sortColumnMapping);
        parameters.setIsVarcharDimensionColumn(isVarcharDimensionColumn);
        parameters.setObserver(new SortObserver());
        parameters.setSortDictAndNoDictDimCount(noDictionaryColMaping, sortColumnMapping);
        parameters.setSortBufferSize(Integer.parseInt(carbonProperties.getProperty("carbon.sort.size", "100000")));
        LOGGER.info((Object)("Sort size for table: " + parameters.getSortBufferSize()));
        parameters.setNumberOfIntermediateFileToBeMerged(Integer.parseInt(carbonProperties.getProperty("carbon.sort.intermediate.files.limit", "20")));
        LOGGER.info((Object)("Number of intermediate file to be merged: " + parameters.getNumberOfIntermediateFileToBeMerged()));
        String[] carbonDataDirectoryPath = CarbonDataProcessorUtil.getLocalDataFolderLocation(carbonTable, taskNo, segmentId, isCompactionFlow, false);
        String[] sortTempDirs = CarbonDataProcessorUtil.arrayAppend(carbonDataDirectoryPath, File.separator, "sortrowtmp");
        parameters.setTempFileLocation(sortTempDirs);
        LOGGER.info((Object)("temp file location: " + StringUtils.join((Object[])parameters.getTempFileLocation(), (String)",")));
        parameters.setNumberOfCores(numberOfCores > 0 ? numberOfCores : 1);
        parameters.setFileWriteBufferSize(Integer.parseInt(carbonProperties.getProperty("carbon.sort.file.write.buffer.size", "16384")));
        parameters.setSortTempCompressorName(CarbonProperties.getInstance().getSortTempCompressor());
        if (!parameters.sortTempCompressorName.isEmpty()) {
            LOGGER.info((Object)(" Compression " + parameters.sortTempCompressorName + " will be used for writing the sort temp File"));
        }
        parameters.setPrefetch(false);
        parameters.setBufferSize(Integer.parseInt(carbonProperties.getProperty("carbon.prefetch.buffersize", "1000")));
        DataType[] type = CarbonDataProcessorUtil.getMeasureDataType(parameters.getMeasureColCount(), parameters.getCarbonTable());
        parameters.setMeasureDataType(type);
        parameters.setNoDictDataType(CarbonDataProcessorUtil.getNoDictSortDataTypes(carbonTable));
        Map<String, DataType[]> noDictSortAndNoSortDataTypes = CarbonDataProcessorUtil.getNoDictSortAndNoSortDataTypes(parameters.getCarbonTable());
        parameters.setNoDictSortDataType(noDictSortAndNoSortDataTypes.get("noDictSortDataTypes"));
        parameters.setNoDictNoSortDataType(noDictSortAndNoSortDataTypes.get("noDictNoSortDataTypes"));
        parameters.setNoDictionarySortColumn(CarbonDataProcessorUtil.getNoDictSortColMapping(parameters.getCarbonTable()));
        parameters.setNoDictSchemaDataType(CarbonDataProcessorUtil.getNoDictDataTypes(parameters.carbonTable));
        Map<String, int[]> columnIdxMap = CarbonDataProcessorUtil.getColumnIdxBasedOnSchemaInRow(parameters.getCarbonTable());
        parameters.setNoDictSortColumnSchemaOrderMapping(columnIdxMap.get("columnIdxBasedOnSchemaInRow"));
        parameters.setNoDictSortColIdxSchemaOrderMapping(columnIdxMap.get("noDictSortIdxBasedOnSchemaInRow"));
        parameters.setDictSortColIdxSchemaOrderMapping(columnIdxMap.get("dictSortIdxBasedOnSchemaInRow"));
        TableSpec tableSpec = new TableSpec(carbonTable, false);
        parameters.setNoDictActualPosition(tableSpec.getNoDictDimActualPosition());
        parameters.setDictDimActualPosition(tableSpec.getDictDimActualPosition());
        parameters.setUpdateDictDims(tableSpec.isUpdateDictDim());
        parameters.setUpdateNonDictDims(tableSpec.isUpdateNoDictDims());
        return parameters;
    }

    private void setSortDictAndNoDictDimCount(boolean[] noDictionaryColMaping, boolean[] sortColumnMapping) {
        int noDictSortDimensionCount = this.getNoDictSortDimCnt();
        int dictSortDimensionCount = this.getDictSortDimCnt();
        for (int i = 0; i < noDictionaryColMaping.length; ++i) {
            if (noDictionaryColMaping[i] && sortColumnMapping[i]) {
                ++noDictSortDimensionCount;
                continue;
            }
            if (noDictionaryColMaping[i] || !sortColumnMapping[i]) continue;
            ++dictSortDimensionCount;
        }
        this.setNoDictSortDimCnt(noDictSortDimensionCount);
        this.setDictSortDimCnt(dictSortDimensionCount);
    }

    public DataType[] getNoDictSortDataType() {
        return this.noDictSortDataType;
    }

    public void setNoDictSortDataType(DataType[] noDictSortDataType) {
        this.noDictSortDataType = noDictSortDataType;
    }

    public DataType[] getNoDictNoSortDataType() {
        return this.noDictNoSortDataType;
    }

    public DataType[] getNoDictDataType() {
        return this.noDictDataType;
    }

    public void setNoDictNoSortDataType(DataType[] noDictNoSortDataType) {
        this.noDictNoSortDataType = noDictNoSortDataType;
    }

    public void setNoDictDataType(DataType[] noDictDataType) {
        this.noDictDataType = noDictDataType;
    }

    public boolean[] getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(boolean[] sortColumn) {
        this.sortColumn = sortColumn;
    }

    public boolean isUpdateDictDims() {
        return this.isUpdateDictDims;
    }

    public void setUpdateDictDims(boolean updateDictDims) {
        this.isUpdateDictDims = updateDictDims;
    }

    public boolean isUpdateNonDictDims() {
        return this.isUpdateNonDictDims;
    }

    public void setUpdateNonDictDims(boolean updateNonDictDims) {
        this.isUpdateNonDictDims = updateNonDictDims;
    }

    public int[] getDictDimActualPosition() {
        return this.dictDimActualPosition;
    }

    public void setDictDimActualPosition(int[] dictDimActualPosition) {
        this.dictDimActualPosition = dictDimActualPosition;
    }

    public int[] getNoDictActualPosition() {
        return this.noDictActualPosition;
    }

    public void setNoDictActualPosition(int[] noDictActualPosition) {
        this.noDictActualPosition = noDictActualPosition;
    }

    public DataType[] getNoDictSchemaDataType() {
        return this.noDictSchemaDataType;
    }

    public void setNoDictSchemaDataType(DataType[] noDictSchemaDataType) {
        this.noDictSchemaDataType = noDictSchemaDataType;
    }

    public int[] getNoDictSortColIdxSchemaOrderMapping() {
        return this.noDictSortColIdxSchemaOrderMapping;
    }

    public void setNoDictSortColIdxSchemaOrderMapping(int[] noDictSortColIdxSchemaOrderMapping) {
        this.noDictSortColIdxSchemaOrderMapping = noDictSortColIdxSchemaOrderMapping;
    }

    public int[] getDictSortColIdxSchemaOrderMapping() {
        return this.dictSortColIdxSchemaOrderMapping;
    }

    public void setDictSortColIdxSchemaOrderMapping(int[] dictSortColIdxSchemaOrderMapping) {
        this.dictSortColIdxSchemaOrderMapping = dictSortColIdxSchemaOrderMapping;
    }
}

