/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.sort.sortdata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.processing.sort.DummyRowUpdater;
import org.apache.carbondata.processing.sort.SchemaBasedRowUpdater;
import org.apache.carbondata.processing.sort.SortTempRowUpdater;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;

public class TableFieldStat
implements Serializable {
    private static final long serialVersionUID = 201712070950L;
    private int dictSortDimCnt = 0;
    private int dictNoSortDimCnt = 0;
    private int noDictSortDimCnt = 0;
    private int noDictNoSortDimCnt = 0;
    private int complexDimCnt = 0;
    private int varcharDimCnt = 0;
    private boolean[] isSortColNoDictFlags;
    private boolean[] isVarcharDimFlags;
    private int measureCnt;
    private DataType[] measureDataType;
    private DataType[] noDictDataType;
    private DataType[] noDictSortDataType;
    private DataType[] noDictNoSortDataType;
    private int[] dictSortDimIdx;
    private int[] dictNoSortDimIdx;
    private int[] noDictSortDimIdx;
    private int[] noDictNoSortDimIdx;
    private int[] varcharDimIdx;
    private int[] complexDimIdx;
    private int[] measureIdx;
    private SortTempRowUpdater sortTempRowUpdater;
    private int[] noDictSortColumnSchemaOrderMapping;
    private DataType[] noDictSchemaDataType;
    private int[] noDictSortColIdxSchemaOrderMapping;
    private int[] dictSortColIdxSchemaOrderMapping;
    private int[] changedOrderInDataField;

    public TableFieldStat(SortParameters sortParameters) {
        int noDictDimCnt = sortParameters.getNoDictionaryCount();
        int dictDimCnt = sortParameters.getDimColCount() - noDictDimCnt;
        this.complexDimCnt = sortParameters.getComplexDimColCount();
        this.isSortColNoDictFlags = sortParameters.getNoDictionarySortColumn();
        this.isVarcharDimFlags = sortParameters.getIsVarcharDimensionColumn();
        this.noDictSortDimCnt = sortParameters.getNoDictSortDimCnt();
        this.dictSortDimCnt = sortParameters.getDictSortDimCnt();
        this.measureCnt = sortParameters.getMeasureColCount();
        this.measureDataType = sortParameters.getMeasureDataType();
        this.noDictDataType = sortParameters.getNoDictDataType();
        this.noDictSortDataType = sortParameters.getNoDictSortDataType();
        this.noDictNoSortDataType = sortParameters.getNoDictNoSortDataType();
        this.noDictSchemaDataType = sortParameters.getNoDictSchemaDataType();
        this.noDictSortColIdxSchemaOrderMapping = sortParameters.getNoDictSortColIdxSchemaOrderMapping();
        this.dictSortColIdxSchemaOrderMapping = sortParameters.getDictSortColIdxSchemaOrderMapping();
        for (boolean flag : this.isVarcharDimFlags) {
            if (!flag) continue;
            ++this.varcharDimCnt;
        }
        this.changedOrderInDataField = sortParameters.getChangedOrderInDataField();
        this.dictSortDimIdx = new int[this.dictSortDimCnt];
        this.dictNoSortDimIdx = new int[dictDimCnt - this.dictSortDimCnt];
        this.noDictSortDimIdx = new int[this.noDictSortDimCnt];
        this.noDictNoSortDimIdx = new int[noDictDimCnt - this.noDictSortDimCnt - this.varcharDimCnt];
        this.complexDimIdx = new int[this.complexDimCnt];
        this.varcharDimIdx = new int[this.varcharDimCnt];
        this.measureIdx = new int[this.measureCnt];
        this.noDictSortColumnSchemaOrderMapping = sortParameters.getNoDictSortColumnSchemaOrderMapping();
        int tmpNoDictSortCnt = 0;
        int tmpNoDictNoSortCnt = 0;
        int tmpDictSortCnt = 0;
        int tmpDictNoSortCnt = 0;
        int tmpVarcharCnt = 0;
        int tmpComplexcount = 0;
        int tmpMeasureIndex = 0;
        if (sortParameters.isInsertWithoutReArrangeFlow() && sortParameters.getCarbonTable().getPartitionInfo() != null) {
            List<ColumnSchema> reArrangedColumnSchema = TableFieldStat.getReArrangedColumnSchema(sortParameters.getCarbonTable());
            for (int i = 0; i < reArrangedColumnSchema.size(); ++i) {
                ColumnSchema columnSchema = reArrangedColumnSchema.get(i);
                if (columnSchema.isDimensionColumn()) {
                    if (columnSchema.getDataType() == DataTypes.DATE && !columnSchema.getDataType().isComplexType()) {
                        if (columnSchema.isSortColumn()) {
                            this.dictSortDimIdx[tmpDictSortCnt++] = i;
                            continue;
                        }
                        this.dictNoSortDimIdx[tmpDictNoSortCnt++] = i;
                        continue;
                    }
                    if (!columnSchema.getDataType().isComplexType()) {
                        if (columnSchema.getDataType() == DataTypes.VARCHAR) {
                            this.varcharDimIdx[tmpVarcharCnt++] = i;
                            continue;
                        }
                        if (columnSchema.isSortColumn()) {
                            this.noDictSortDimIdx[tmpNoDictSortCnt++] = i;
                            continue;
                        }
                        this.noDictNoSortDimIdx[tmpNoDictNoSortCnt++] = i;
                        continue;
                    }
                    this.complexDimIdx[tmpComplexcount++] = i;
                    continue;
                }
                this.measureIdx[tmpMeasureIndex++] = i;
            }
        } else {
            List allDimensions = sortParameters.getCarbonTable().getVisibleDimensions();
            List<CarbonDimension> updatedDimensions = TableFieldStat.updateDimensionsBasedOnSortColumns(allDimensions);
            for (int i = 0; i < updatedDimensions.size(); ++i) {
                CarbonDimension carbonDimension = updatedDimensions.get(i);
                if (carbonDimension.getDataType() == DataTypes.DATE && !carbonDimension.isComplex().booleanValue()) {
                    if (carbonDimension.isSortColumn()) {
                        this.dictSortDimIdx[tmpDictSortCnt++] = i;
                        continue;
                    }
                    this.dictNoSortDimIdx[tmpDictNoSortCnt++] = i;
                    continue;
                }
                if (!carbonDimension.isComplex().booleanValue()) {
                    if (this.isVarcharDimFlags[i]) {
                        this.varcharDimIdx[tmpVarcharCnt++] = i;
                        continue;
                    }
                    if (carbonDimension.isSortColumn()) {
                        this.noDictSortDimIdx[tmpNoDictSortCnt++] = i;
                        continue;
                    }
                    this.noDictNoSortDimIdx[tmpNoDictNoSortCnt++] = i;
                    continue;
                }
                this.complexDimIdx[tmpComplexcount++] = i;
            }
            int base = updatedDimensions.size();
            for (int i = 0; i < this.measureCnt; ++i) {
                this.measureIdx[i] = base + i;
            }
        }
        this.dictNoSortDimCnt = tmpDictNoSortCnt;
        this.noDictNoSortDimCnt = tmpNoDictNoSortCnt;
        this.sortTempRowUpdater = sortParameters.isUpdateDictDims() || sortParameters.isUpdateNonDictDims() ? new SchemaBasedRowUpdater(sortParameters.getDictDimActualPosition(), sortParameters.getNoDictActualPosition(), sortParameters.isUpdateDictDims(), sortParameters.isUpdateNonDictDims()) : new DummyRowUpdater();
    }

    public int[] getChangedDataFieldOrder() {
        return this.changedOrderInDataField;
    }

    public int getDictSortDimCnt() {
        return this.dictSortDimCnt;
    }

    public int getDictNoSortDimCnt() {
        return this.dictNoSortDimCnt;
    }

    public int getNoDictSortDimCnt() {
        return this.noDictSortDimCnt;
    }

    public int getNoDictNoSortDimCnt() {
        return this.noDictNoSortDimCnt;
    }

    public int getComplexDimCnt() {
        return this.complexDimCnt;
    }

    public int getVarcharDimCnt() {
        return this.varcharDimCnt;
    }

    public boolean[] getIsSortColNoDictFlags() {
        return this.isSortColNoDictFlags;
    }

    public boolean[] getIsVarcharDimFlags() {
        return this.isVarcharDimFlags;
    }

    public int getMeasureCnt() {
        return this.measureCnt;
    }

    public DataType[] getMeasureDataType() {
        return this.measureDataType;
    }

    public int[] getDictSortDimIdx() {
        return this.dictSortDimIdx;
    }

    public int[] getDictNoSortDimIdx() {
        return this.dictNoSortDimIdx;
    }

    public int[] getNoDictSortDimIdx() {
        return this.noDictSortDimIdx;
    }

    public int[] getNoDictNoSortDimIdx() {
        return this.noDictNoSortDimIdx;
    }

    public int[] getComplexDimIdx() {
        return this.complexDimIdx;
    }

    public int[] getVarcharDimIdx() {
        return this.varcharDimIdx;
    }

    public int[] getMeasureIdx() {
        return this.measureIdx;
    }

    public int[] getNoDictSortColumnSchemaOrderMapping() {
        return this.noDictSortColumnSchemaOrderMapping;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableFieldStat)) {
            return false;
        }
        TableFieldStat that = (TableFieldStat)o;
        return this.dictSortDimCnt == that.dictSortDimCnt && this.dictNoSortDimCnt == that.dictNoSortDimCnt && this.noDictSortDimCnt == that.noDictSortDimCnt && this.noDictNoSortDimCnt == that.noDictNoSortDimCnt && this.complexDimCnt == that.complexDimCnt && this.varcharDimCnt == that.varcharDimCnt && this.measureCnt == that.measureCnt;
    }

    public int hashCode() {
        return Objects.hash(this.dictSortDimCnt, this.dictNoSortDimCnt, this.noDictSortDimCnt, this.noDictNoSortDimCnt, this.complexDimCnt, this.varcharDimCnt, this.measureCnt);
    }

    public DataType[] getNoDictSortDataType() {
        return this.noDictSortDataType;
    }

    public DataType[] getNoDictNoSortDataType() {
        return this.noDictNoSortDataType;
    }

    public DataType[] getNoDictDataType() {
        return this.noDictDataType;
    }

    public SortTempRowUpdater getSortTempRowUpdater() {
        return this.sortTempRowUpdater;
    }

    private static List<CarbonDimension> updateDimensionsBasedOnSortColumns(List<CarbonDimension> carbonDimensions) {
        return TableFieldStat.getCarbonDimensions(carbonDimensions);
    }

    private static List<CarbonDimension> getCarbonDimensions(List<CarbonDimension> carbonDimensions) {
        ArrayList<CarbonDimension> updatedDataFields = new ArrayList<CarbonDimension>();
        ArrayList<CarbonDimension> sortFields = new ArrayList<CarbonDimension>();
        ArrayList<CarbonDimension> nonSortFields = new ArrayList<CarbonDimension>();
        for (CarbonDimension carbonDimension : carbonDimensions) {
            if (carbonDimension.getColumnSchema().isSortColumn()) {
                sortFields.add(carbonDimension);
                continue;
            }
            nonSortFields.add(carbonDimension);
        }
        updatedDataFields.addAll(sortFields);
        updatedDataFields.addAll(nonSortFields);
        return updatedDataFields;
    }

    private static List<ColumnSchema> getReArrangedColumnSchema(CarbonTable carbonTable) {
        List<CarbonDimension> visibleDimensions = TableFieldStat.updateDimensionsBasedOnSortColumns(carbonTable.getVisibleDimensions());
        List visibleMeasures = carbonTable.getVisibleMeasures();
        ArrayList<ColumnSchema> otherCols = new ArrayList<ColumnSchema>();
        if (carbonTable.getPartitionInfo() != null) {
            List columnSchemaList = carbonTable.getPartitionInfo().getColumnSchemaList();
            for (CarbonDimension dim : visibleDimensions) {
                if (!columnSchemaList.contains(dim.getColumnSchema())) {
                    otherCols.add(dim.getColumnSchema());
                    continue;
                }
                if (!dim.isSortColumn()) continue;
                otherCols.add(dim.getColumnSchema());
            }
            for (CarbonMeasure measure : visibleMeasures) {
                if (columnSchemaList.contains(measure.getColumnSchema())) continue;
                otherCols.add(measure.getColumnSchema());
            }
            columnSchemaList.forEach(columnSchema -> {
                if (!columnSchema.isSortColumn()) {
                    otherCols.add((ColumnSchema)columnSchema);
                }
            });
        }
        return otherCols;
    }

    public DataType[] getNoDictSchemaDataType() {
        return this.noDictSchemaDataType;
    }

    public int[] getNoDictSortColIdxSchemaOrderMapping() {
        return this.noDictSortColIdxSchemaOrderMapping;
    }

    public int[] getDictSortColIdxSchemaOrderMapping() {
        return this.dictSortColIdxSchemaOrderMapping;
    }
}

